/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricPlanItemInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.event.FlowableCmmnEventBuilder;
import org.flowable.cmmn.engine.impl.listener.CaseInstanceLifeCycleListenerUtil;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceHelper;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.EntityLinkUtil;
import org.flowable.cmmn.engine.impl.util.EventInstanceCmmnUtil;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.cmmn.engine.impl.util.JobUtil;
import org.flowable.cmmn.engine.interceptor.StartCaseInstanceAfterContext;
import org.flowable.cmmn.engine.interceptor.StartCaseInstanceBeforeContext;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.ReactivateEventListener;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.callback.CallbackData;
import org.flowable.common.engine.impl.callback.RuntimeInstanceStateChangeCallback;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.el.NoExecutionVariableScope;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInstanceHelperImpl
implements CaseInstanceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseInstanceHelperImpl.class);
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public CaseInstanceHelperImpl(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    @Override
    public CaseInstanceEntity startCaseInstance(CaseInstanceBuilder caseInstanceBuilder) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        return this.startCaseInstance(commandContext, this.getCaseDefinition(caseInstanceBuilder, commandContext), caseInstanceBuilder);
    }

    @Override
    public CaseInstanceEntity startCaseInstanceAsync(CaseInstanceBuilder caseInstanceBuilder) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        return this.startCaseInstanceAsync(commandContext, this.getCaseDefinition(caseInstanceBuilder, commandContext), caseInstanceBuilder);
    }

    @Override
    public CaseInstanceEntity copyHistoricCaseInstanceToRuntime(HistoricCaseInstance caseInstance) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        CaseDefinitionEntityManager caseDefinitionEntityManager = this.cmmnEngineConfiguration.getCaseDefinitionEntityManager();
        CaseDefinition caseDefinition = (CaseDefinition)caseDefinitionEntityManager.findById(caseInstance.getCaseDefinitionId());
        CaseInstanceEntity caseInstanceEntity = this.copyHistoricCaseInstanceToRuntime(commandContext, caseDefinition, caseInstance);
        return caseInstanceEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CaseDefinition getCaseDefinition(CaseInstanceBuilder caseInstanceBuilder, CommandContext commandContext) {
        String defaultTenant;
        CaseDefinition caseDefinition = null;
        if (caseInstanceBuilder.getCaseDefinitionId() != null) {
            String caseDefinitionId = caseInstanceBuilder.getCaseDefinitionId();
            CmmnDeploymentManager deploymentManager = this.cmmnEngineConfiguration.getDeploymentManager();
            return deploymentManager.findDeployedCaseDefinitionById(caseDefinitionId);
        }
        if (caseInstanceBuilder.getCaseDefinitionKey() == null) throw new FlowableIllegalArgumentException("caseDefinitionKey and caseDefinitionId are null");
        String caseDefinitionKey = caseInstanceBuilder.getCaseDefinitionKey();
        CaseDefinitionEntityManager caseDefinitionEntityManager = this.cmmnEngineConfiguration.getCaseDefinitionEntityManager();
        String tenantId = caseInstanceBuilder.getTenantId();
        String parentDeploymentId = caseInstanceBuilder.getCaseDefinitionParentDeploymentId();
        if (tenantId == null || "".equals(tenantId)) {
            if (parentDeploymentId != null) {
                caseDefinition = caseDefinitionEntityManager.findCaseDefinitionByParentDeploymentAndKey(parentDeploymentId, caseDefinitionKey);
            }
            if (caseDefinition == null) {
                caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKey(caseDefinitionKey);
            }
            if (caseDefinition != null) return caseDefinition;
            throw new FlowableObjectNotFoundException("No case definition found for key " + caseDefinitionKey, CaseDefinition.class);
        }
        if ("".equals(tenantId)) return caseDefinition;
        if (parentDeploymentId != null) {
            caseDefinition = caseDefinitionEntityManager.findCaseDefinitionByParentDeploymentAndKeyAndTenantId(parentDeploymentId, caseDefinitionKey, tenantId);
        }
        if (caseDefinition == null) {
            caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
        }
        if (caseDefinition != null) return caseDefinition;
        if (!caseInstanceBuilder.isFallbackToDefaultTenant()) {
            if (!this.cmmnEngineConfiguration.isFallbackToDefaultTenant()) throw new FlowableObjectNotFoundException("Case definition was not found by key '" + caseDefinitionKey + "' and tenant '" + tenantId + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaultTenant = this.cmmnEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(tenantId, "cmmn", caseDefinitionKey)))) {
            caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, defaultTenant);
            caseInstanceBuilder.overrideCaseDefinitionTenantId(tenantId);
        } else {
            caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKey(caseDefinitionKey);
        }
        if (caseDefinition != null) return caseDefinition;
        throw new FlowableObjectNotFoundException("Case definition was not found by key '" + caseDefinitionKey + "'. Fallback to default tenant was also used.");
    }

    protected CaseInstanceEntity startCaseInstance(CommandContext commandContext, CaseDefinition caseDefinition, CaseInstanceBuilder caseInstanceBuilder) {
        CmmnModel cmmnModel = this.getCmmnModel(commandContext, caseDefinition);
        Case caseModel = this.getCaseModel(caseDefinition, cmmnModel);
        CaseInstanceEntity caseInstanceEntity = this.initializeCaseInstanceEntity(commandContext, caseDefinition, cmmnModel, caseModel, caseInstanceBuilder);
        if (!caseModel.isAsync()) {
            CommandContextUtil.getAgenda(commandContext).planInitPlanModelOperation(caseInstanceEntity);
            CaseInstanceLifeCycleListenerUtil.callLifecycleListeners(commandContext, caseInstanceEntity, "", "active");
            FlowableEventDispatcher eventDispatcher = this.cmmnEngineConfiguration.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableCmmnEventBuilder.createCaseStartedEvent(caseInstanceEntity), "cfg.cmmnEngine");
            }
            if (this.cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                CmmnLoggingSessionUtil.addLoggingData("caseStarted", "Started case instance with id " + caseInstanceEntity.getId(), caseInstanceEntity, this.cmmnEngineConfiguration.getObjectMapper());
            }
        } else {
            JobService jobService = this.cmmnEngineConfiguration.getJobServiceConfiguration().getJobService();
            this.createAsyncInitJob(caseInstanceEntity, caseDefinition, caseModel, jobService, commandContext);
        }
        return caseInstanceEntity;
    }

    protected CaseInstanceEntity startCaseInstanceAsync(CommandContext commandContext, CaseDefinition caseDefinition, CaseInstanceBuilder caseInstanceBuilder) {
        CmmnModel cmmnModel = this.getCmmnModel(commandContext, caseDefinition);
        Case caseModel = this.getCaseModel(caseDefinition, cmmnModel);
        CaseInstanceEntity caseInstanceEntity = this.initializeCaseInstanceEntity(commandContext, caseDefinition, cmmnModel, caseModel, caseInstanceBuilder);
        JobService jobService = this.cmmnEngineConfiguration.getJobServiceConfiguration().getJobService();
        this.createAsyncInitJob(caseInstanceEntity, caseDefinition, caseModel, jobService, commandContext);
        return caseInstanceEntity;
    }

    protected CaseInstanceEntity copyHistoricCaseInstanceToRuntime(CommandContext commandContext, CaseDefinition caseDefinition, HistoricCaseInstance caseInstance) {
        CmmnModel cmmnModel = this.getCmmnModel(commandContext, caseDefinition);
        Case caseModel = this.getCaseModel(caseDefinition, cmmnModel);
        ReactivateEventListener listener = caseModel.getReactivateEventListener();
        if (listener == null) {
            throw new FlowableIllegalStateException("The historic case instance " + caseInstance.getId() + " cannot be reactivated as there is no reactivation event in its CMMN model. You need to explicitly model the reactivation event in order to support case reactivation.");
        }
        return this.createCaseInstanceEntityFromHistoricCaseInstance(commandContext, caseInstance);
    }

    protected void createAsyncInitJob(CaseInstanceEntity caseInstance, CaseDefinition caseDefinition, Case caseModel, JobService jobService, CommandContext commandContext) {
        JobEntity job = JobUtil.createJob(caseInstance, (BaseElement)caseModel, "cmmn-async-init-plan-model-instance", this.cmmnEngineConfiguration);
        job.setElementId(caseDefinition.getId());
        job.setElementName(caseDefinition.getName());
        job.setJobHandlerConfiguration(caseInstance.getId());
        jobService.createAsyncJob(job, false);
        jobService.scheduleAsyncJob(job);
    }

    protected CmmnModel getCmmnModel(CommandContext commandContext, CaseDefinition caseDefinition) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CmmnDeploymentManager deploymentManager = cmmnEngineConfiguration.getDeploymentManager();
        return deploymentManager.resolveCaseDefinition(caseDefinition).getCmmnModel();
    }

    protected Case getCaseModel(CaseDefinition caseDefinition, CmmnModel cmmnModel) {
        return cmmnModel.getCaseById(caseDefinition.getKey());
    }

    protected CaseInstanceEntity initializeCaseInstanceEntity(CommandContext commandContext, CaseDefinition caseDefinition, CmmnModel cmmnModel, Case caseModel, CaseInstanceBuilder caseInstanceBuilder) {
        StartCaseInstanceBeforeContext instanceBeforeContext = new StartCaseInstanceBeforeContext(caseInstanceBuilder.getBusinessKey(), caseInstanceBuilder.getBusinessStatus(), caseInstanceBuilder.getName(), caseInstanceBuilder.getCallbackId(), caseInstanceBuilder.getCallbackType(), caseInstanceBuilder.getReferenceId(), caseInstanceBuilder.getReferenceType(), caseInstanceBuilder.getParentId(), caseInstanceBuilder.getVariables(), caseInstanceBuilder.getTransientVariables(), caseInstanceBuilder.getTenantId(), caseInstanceBuilder.getOwner(), caseInstanceBuilder.getAssignee(), caseModel.getInitiatorVariableName(), caseModel, caseDefinition, cmmnModel, caseInstanceBuilder.getOverrideDefinitionTenantId(), caseInstanceBuilder.getPredefinedCaseInstanceId());
        if (this.cmmnEngineConfiguration.getStartCaseInstanceInterceptor() != null) {
            this.cmmnEngineConfiguration.getStartCaseInstanceInterceptor().beforeStartCaseInstance(instanceBeforeContext);
        }
        CaseInstanceEntity caseInstanceEntity = this.createCaseInstanceEntityFromDefinition(commandContext, caseDefinition, instanceBeforeContext);
        this.applyCaseInstanceBuilder(this.cmmnEngineConfiguration, caseInstanceBuilder, caseModel, caseInstanceEntity, caseDefinition, instanceBeforeContext, commandContext);
        if (this.cmmnEngineConfiguration.isEnableEntityLinks() && "cmmn-1.1-to-cmmn-1.1-child-case".equals(caseInstanceEntity.getCallbackType())) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(caseInstanceEntity.getCallbackId());
            EntityLinkUtil.createEntityLinks(planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getId(), planItemInstanceEntity.getPlanItemDefinitionId(), caseInstanceEntity.getId(), "cmmn", this.cmmnEngineConfiguration);
        }
        if (this.cmmnEngineConfiguration.getStartCaseInstanceInterceptor() != null) {
            StartCaseInstanceAfterContext instanceAfterContext = new StartCaseInstanceAfterContext(caseInstanceEntity, caseInstanceBuilder.getVariables(), caseInstanceBuilder.getTransientVariables(), caseModel, caseDefinition, cmmnModel);
            this.cmmnEngineConfiguration.getStartCaseInstanceInterceptor().afterStartCaseInstance(instanceAfterContext);
        }
        CallbackData callbackData = new CallbackData(caseInstanceEntity.getCallbackId(), caseInstanceEntity.getCallbackType(), caseInstanceEntity.getId(), null, "active");
        this.callCaseInstanceStateChangeCallbacks(callbackData);
        this.cmmnEngineConfiguration.getCmmnHistoryManager().recordCaseInstanceStart(caseInstanceEntity);
        return caseInstanceEntity;
    }

    protected void applyCaseInstanceBuilder(CmmnEngineConfiguration cmmnEngineConfiguration, CaseInstanceBuilder caseInstanceBuilder, Case caseModel, CaseInstanceEntity caseInstanceEntity, CaseDefinition caseDefinition, StartCaseInstanceBeforeContext instanceBeforeContext, CommandContext commandContext) {
        Map<String, Object> transientVariables;
        Map<String, Object> variables;
        if (instanceBeforeContext.getCaseInstanceName() != null) {
            caseInstanceEntity.setName(instanceBeforeContext.getCaseInstanceName());
        }
        if (instanceBeforeContext.getBusinessKey() != null) {
            caseInstanceEntity.setBusinessKey(instanceBeforeContext.getBusinessKey());
        }
        if (instanceBeforeContext.getBusinessStatus() != null) {
            caseInstanceEntity.setBusinessStatus(instanceBeforeContext.getBusinessStatus());
        }
        if (instanceBeforeContext.getOverrideDefinitionTenantId() != null) {
            caseInstanceEntity.setTenantId(instanceBeforeContext.getOverrideDefinitionTenantId());
        }
        if (instanceBeforeContext.getParentId() != null) {
            caseInstanceEntity.setParentId(instanceBeforeContext.getParentId());
        }
        if (instanceBeforeContext.getCallbackId() != null) {
            caseInstanceEntity.setCallbackId(instanceBeforeContext.getCallbackId());
        }
        if (instanceBeforeContext.getCallbackType() != null) {
            caseInstanceEntity.setCallbackType(instanceBeforeContext.getCallbackType());
        }
        if (instanceBeforeContext.getReferenceId() != null) {
            caseInstanceEntity.setReferenceId(instanceBeforeContext.getReferenceId());
        }
        if (instanceBeforeContext.getReferenceType() != null) {
            caseInstanceEntity.setReferenceType(instanceBeforeContext.getReferenceType());
        }
        if (cmmnEngineConfiguration.getIdentityLinkInterceptor() != null) {
            cmmnEngineConfiguration.getIdentityLinkInterceptor().handleCreateCaseInstance(caseInstanceEntity);
        }
        if (instanceBeforeContext.getInitiatorVariableName() != null) {
            caseInstanceEntity.setVariable(instanceBeforeContext.getInitiatorVariableName(), Authentication.getAuthenticatedUserId());
        }
        if ((variables = instanceBeforeContext.getVariables()) != null) {
            for (String string : variables.keySet()) {
                caseInstanceEntity.setVariable(string, variables.get(string));
            }
        }
        if ((transientVariables = instanceBeforeContext.getTransientVariables()) != null) {
            for (String variableName : transientVariables.keySet()) {
                caseInstanceEntity.setTransientVariable(variableName, transientVariables.get(variableName));
            }
            Object object = caseInstanceEntity.getTransientVariable("eventInstance");
            if (object instanceof EventInstance) {
                EventInstanceCmmnUtil.handleEventInstanceOutParameters(caseInstanceEntity, (BaseElement)caseModel, (EventInstance)object);
            }
        }
        if (caseInstanceBuilder.isStartWithForm() || caseInstanceBuilder.getOutcome() != null) {
            Map map = caseInstanceBuilder.getStartFormVariables();
            FormService formService = CommandContextUtil.getFormService(commandContext);
            CmmnModel cmmnModel = CaseDefinitionUtil.getCmmnModel(caseDefinition.getId());
            Case caze = cmmnModel.getCaseById(caseDefinition.getKey());
            Stage planModel = caze.getPlanModel();
            if (planModel != null && StringUtils.isNotEmpty((CharSequence)planModel.getFormKey())) {
                FormRepositoryService formRepositoryService = CommandContextUtil.getFormRepositoryService(commandContext);
                if (formRepositoryService != null) {
                    FormInfo formInfo = this.resolveFormInfo(planModel, caseDefinition, caseInstanceEntity.getTenantId(), formRepositoryService, cmmnEngineConfiguration);
                    if (formInfo != null) {
                        Map caseVariables;
                        FormFieldHandler formFieldHandler = cmmnEngineConfiguration.getFormFieldHandler();
                        if (this.isFormFieldValidationEnabled(cmmnEngineConfiguration, planModel)) {
                            formService.validateFormFields(null, "planModel", null, caseDefinition.getId(), "cmmn", formInfo, map);
                        }
                        if ((caseVariables = formService.getVariablesFromFormSubmission(null, "planModel", null, caseDefinition.getId(), "cmmn", formInfo, map, caseInstanceBuilder.getOutcome())) != null) {
                            for (String variableName : caseVariables.keySet()) {
                                caseInstanceEntity.setVariable(variableName, caseVariables.get(variableName));
                            }
                        }
                        formService.createFormInstanceWithScopeId(map, formInfo, null, caseInstanceEntity.getId(), "cmmn", caseInstanceEntity.getCaseDefinitionId(), caseInstanceEntity.getTenantId(), caseInstanceBuilder.getOutcome());
                        formFieldHandler.handleFormFieldsOnSubmit(formInfo, null, null, caseInstanceEntity.getId(), "cmmn", caseVariables, caseInstanceEntity.getTenantId());
                    }
                } else {
                    LOGGER.warn("Requesting form model {} without configured formRepositoryService", (Object)planModel.getFormKey());
                }
            }
        }
    }

    protected FormInfo resolveFormInfo(Stage planModel, CaseDefinition caseDefinition, String tenantId, FormRepositoryService formRepositoryService, CmmnEngineConfiguration cmmnEngineConfiguration) {
        FormInfo formInfo;
        String formKey = planModel.getFormKey();
        if (tenantId == null || "".equals(tenantId)) {
            if (planModel.isSameDeployment()) {
                String parentDeploymentId = CaseDefinitionUtil.getDefinitionDeploymentId(caseDefinition, cmmnEngineConfiguration);
                formInfo = formRepositoryService.getFormModelByKeyAndParentDeploymentId(formKey, parentDeploymentId);
            } else {
                formInfo = formRepositoryService.getFormModelByKey(formKey);
            }
        } else if (planModel.isSameDeployment()) {
            String parentDeploymentId = CaseDefinitionUtil.getDefinitionDeploymentId(caseDefinition, cmmnEngineConfiguration);
            formInfo = formRepositoryService.getFormModelByKeyAndParentDeploymentId(formKey, parentDeploymentId, tenantId, cmmnEngineConfiguration.isFallbackToDefaultTenant());
        } else {
            formInfo = formRepositoryService.getFormModelByKey(formKey, tenantId, cmmnEngineConfiguration.isFallbackToDefaultTenant());
        }
        return formInfo;
    }

    protected boolean isFormFieldValidationEnabled(CmmnEngineConfiguration cmmnEngineConfiguration, Stage stage) {
        if (cmmnEngineConfiguration.isFormFieldValidationEnabled()) {
            return TaskHelper.isFormFieldValidationEnabled((VariableContainer)NoExecutionVariableScope.getSharedInstance(), cmmnEngineConfiguration, stage.getValidateFormFields());
        }
        return false;
    }

    protected CaseInstanceEntity createCaseInstanceEntityFromDefinition(CommandContext commandContext, CaseDefinition caseDefinition, StartCaseInstanceBeforeContext instanceBeforeContext) {
        CaseInstanceEntityManager caseInstanceEntityManager = this.cmmnEngineConfiguration.getCaseInstanceEntityManager();
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)caseInstanceEntityManager.create();
        if (instanceBeforeContext.getPredefinedCaseInstanceId() != null) {
            caseInstanceEntity.setId(instanceBeforeContext.getPredefinedCaseInstanceId());
        }
        caseInstanceEntity.setCaseDefinitionId(caseDefinition.getId());
        caseInstanceEntity.setCaseDefinitionKey(caseDefinition.getKey());
        caseInstanceEntity.setCaseDefinitionName(caseDefinition.getName());
        caseInstanceEntity.setCaseDefinitionVersion(caseDefinition.getVersion());
        caseInstanceEntity.setCaseDefinitionDeploymentId(caseDefinition.getDeploymentId());
        caseInstanceEntity.setStartTime(this.cmmnEngineConfiguration.getClock().getCurrentTime());
        caseInstanceEntity.setState("active");
        caseInstanceEntity.setTenantId(caseDefinition.getTenantId());
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        caseInstanceEntity.setStartUserId(authenticatedUserId);
        caseInstanceEntityManager.insert(caseInstanceEntity);
        caseInstanceEntity.setSatisfiedSentryPartInstances(new ArrayList(1));
        if (StringUtils.isNotEmpty((CharSequence)instanceBeforeContext.getOwnerId())) {
            IdentityLinkUtil.createCaseInstanceIdentityLink(caseInstanceEntity, instanceBeforeContext.getOwnerId(), null, "owner", this.cmmnEngineConfiguration);
        }
        if (StringUtils.isNotEmpty((CharSequence)instanceBeforeContext.getAssigneeId())) {
            IdentityLinkUtil.createCaseInstanceIdentityLink(caseInstanceEntity, instanceBeforeContext.getAssigneeId(), null, "assignee", this.cmmnEngineConfiguration);
        }
        return caseInstanceEntity;
    }

    protected CaseInstanceEntity createCaseInstanceEntityFromHistoricCaseInstance(CommandContext commandContext, HistoricCaseInstance historicCaseInstance) {
        CaseInstanceEntityManager caseInstanceEntityManager = this.cmmnEngineConfiguration.getCaseInstanceEntityManager();
        Map<String, VariableInstanceEntity> variables = this.createCaseVariablesFromHistoricCaseInstance(historicCaseInstance);
        CaseInstanceEntity caseInstanceEntity = caseInstanceEntityManager.create(historicCaseInstance, variables);
        caseInstanceEntityManager.insert(caseInstanceEntity);
        caseInstanceEntity.setChildPlanItemInstances(this.createCasePlanItemsFromHistoricCaseInstance(historicCaseInstance, caseInstanceEntity));
        return caseInstanceEntity;
    }

    protected List<PlanItemInstanceEntity> createCasePlanItemsFromHistoricCaseInstance(HistoricCaseInstance historicCaseInstance, CaseInstanceEntity newCaseInstance) {
        HistoricPlanItemInstanceEntityManager planItemInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager();
        PlanItemInstanceEntityManager historicPlanItemInstanceEntityManager = this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager();
        List historicPlanItemInstances = planItemInstanceEntityManager.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(historicCaseInstance.getId()).list();
        ArrayList<PlanItemInstanceEntity> planItemInstances = new ArrayList<PlanItemInstanceEntity>(historicPlanItemInstances.size());
        for (HistoricPlanItemInstance historicPlanItemInstance : historicPlanItemInstances) {
            PlanItemInstanceEntity newPlanItemInstance = historicPlanItemInstanceEntityManager.create(historicPlanItemInstance);
            historicPlanItemInstanceEntityManager.insert(newPlanItemInstance);
            planItemInstances.add(newPlanItemInstance);
        }
        return planItemInstances;
    }

    protected Map<String, VariableInstanceEntity> createCaseVariablesFromHistoricCaseInstance(HistoricCaseInstance historicCaseInstance) {
        VariableService variableService = this.cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService();
        List variables = this.cmmnEngineConfiguration.getCmmnHistoryService().createHistoricVariableInstanceQuery().caseInstanceId(historicCaseInstance.getId()).list();
        if (variables != null) {
            HashMap<String, VariableInstanceEntity> newVars = new HashMap<String, VariableInstanceEntity>(variables.size());
            for (HistoricVariableInstance variable : variables) {
                if (variable.getSubScopeId() != null) continue;
                VariableInstanceEntity newVariable = variableService.createVariableInstance(variable.getVariableName());
                newVariable.setId(variable.getId());
                newVariable.setScopeId(historicCaseInstance.getId());
                newVariable.setScopeType(variable.getScopeType());
                variableService.insertVariableInstanceWithValue(newVariable, variable.getValue(), historicCaseInstance.getTenantId());
                newVars.put(newVariable.getName(), newVariable);
            }
            return newVars;
        }
        return Collections.emptyMap();
    }

    @Override
    public void callCaseInstanceStateChangeCallbacks(CallbackData callbackData) {
        Map<String, List<RuntimeInstanceStateChangeCallback>> caseInstanceCallbacks;
        String callbackId = callbackData.getCallbackId();
        String callbackType = callbackData.getCallbackType();
        if (callbackId != null && callbackType != null && (caseInstanceCallbacks = this.cmmnEngineConfiguration.getCaseInstanceStateChangeCallbacks()) != null && caseInstanceCallbacks.containsKey(callbackType)) {
            for (RuntimeInstanceStateChangeCallback caseInstanceCallback : caseInstanceCallbacks.get(callbackType)) {
                caseInstanceCallback.stateChanged(callbackData);
            }
        }
    }
}

