/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.variable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.delegate.PlanItemVariableAggregator;
import org.flowable.cmmn.api.delegate.PlanItemVariableAggregatorContext;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.delegate.BaseVariableAggregatorContext;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.DelegateExpressionUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.cmmn.model.VariableAggregationDefinition;
import org.flowable.cmmn.model.VariableAggregationDefinitions;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class CmmnAggregation {
    public static final String COUNTER_VAR_PREFIX = "__flowableCounter__";
    public static final String COUNTER_VAR_VALUE_SEPARATOR = "###";
    protected final String planItemInstanceId;

    public CmmnAggregation(String planItemInstanceId) {
        this.planItemInstanceId = planItemInstanceId;
    }

    public String getPlanItemInstanceId() {
        return this.planItemInstanceId;
    }

    public static VariableInstanceEntity aggregateComplete(DelegatePlanItemInstance planItemInstance, VariableAggregationDefinition aggregation, CmmnEngineConfiguration cmmnEngineConfiguration) {
        return CmmnAggregation.aggregate(planItemInstance, BaseVariableAggregatorContext.complete(aggregation), cmmnEngineConfiguration);
    }

    public static VariableInstanceEntity aggregate(DelegatePlanItemInstance planItemInstance, PlanItemVariableAggregatorContext aggregationContext, CmmnEngineConfiguration cmmnEngineConfiguration) {
        VariableAggregationDefinition aggregation = aggregationContext.getDefinition();
        PlanItemVariableAggregator aggregator = CmmnAggregation.resolveVariableAggregator(aggregation, planItemInstance);
        String targetVarName = CmmnAggregation.getAggregationTargetVarName(aggregation, (VariableScope)planItemInstance, cmmnEngineConfiguration);
        if (targetVarName != null) {
            return CmmnAggregation.aggregate(planItemInstance, aggregationContext, cmmnEngineConfiguration, aggregator, targetVarName);
        }
        return null;
    }

    public static VariableInstanceEntity aggregate(DelegatePlanItemInstance planItemInstance, PlanItemVariableAggregatorContext aggregationContext, CmmnEngineConfiguration cmmnEngineConfiguration, PlanItemVariableAggregator aggregator, String targetVarName) {
        VariableServiceConfiguration variableServiceConfiguration = cmmnEngineConfiguration.getVariableServiceConfiguration();
        Object aggregatedValue = aggregator.aggregateSingleVariable(planItemInstance, aggregationContext);
        String caseInstanceId = planItemInstance.getCaseInstanceId();
        String subScopeId = planItemInstance.getStageInstanceId();
        if (subScopeId == null) {
            subScopeId = caseInstanceId;
        }
        return CmmnAggregation.createScopedVariableAggregationVariableInstance(planItemInstance.getTenantId(), targetVarName, caseInstanceId, subScopeId, aggregatedValue, variableServiceConfiguration);
    }

    public static Object aggregateOverview(String parentScopeId, String targetVarName, CommandContext commandContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        PlanItemInstanceEntity parent = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(parentScopeId);
        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(parent);
        if (repetitionRule != null) {
            return CmmnAggregation.aggregateOverviewForRepetition(parent, repetitionRule, targetVarName, cmmnEngineConfiguration);
        }
        return null;
    }

    public static Object aggregateOverviewForRepetition(PlanItemInstanceEntity planItemInstance, RepetitionRule repetitionRule, String targetVarName, CmmnEngineConfiguration cmmnEngineConfiguration) {
        List<PlanItemInstanceEntity> repetitionPlanItems;
        VariableAggregationDefinitions aggregations = repetitionRule.getAggregations();
        if (aggregations == null) {
            return null;
        }
        String subScopeId = planItemInstance.getStageInstanceId();
        if (subScopeId == null) {
            subScopeId = planItemInstance.getCaseInstanceId();
            repetitionPlanItems = cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findByCaseInstanceIdAndPlanItemId(subScopeId, planItemInstance.getPlanItem().getId());
        } else {
            repetitionPlanItems = cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findByStageInstanceIdAndPlanItemId(subScopeId, planItemInstance.getPlanItem().getId());
        }
        VariableServiceConfiguration variableServiceConfiguration = cmmnEngineConfiguration.getVariableServiceConfiguration();
        VariableService variableService = variableServiceConfiguration.getVariableService();
        List instances = variableService.createInternalVariableInstanceQuery().subScopeId(subScopeId).scopeType("cmmnVariableAggregation").names(Arrays.asList(targetVarName, COUNTER_VAR_PREFIX + targetVarName)).list();
        String elementIndexVariable = repetitionRule.getRepetitionCounterVariableName();
        VariableScope parentVariableScope = planItemInstance.getParentVariableScope();
        Map<String, VariableAggregationDefinition> aggregationsByTarget = CmmnAggregation.groupAggregationsByTarget(parentVariableScope, aggregations.getOverviewAggregations(), cmmnEngineConfiguration);
        VariableAggregationDefinition aggregation = aggregationsByTarget.get(targetVarName);
        PlanItemVariableAggregator aggregator = CmmnAggregation.resolveVariableAggregator(aggregation, planItemInstance);
        PlanItemVariableAggregatorContext aggregationContext = BaseVariableAggregatorContext.overview(aggregation);
        for (PlanItemInstanceEntity repetitionPlanItem : repetitionPlanItems) {
            if (!PlanItemInstanceState.ACTIVE_STATES.contains(repetitionPlanItem.getState())) continue;
            VariableInstanceEntity aggregatedVarInstance = CmmnAggregation.aggregate(repetitionPlanItem, aggregationContext, cmmnEngineConfiguration, aggregator, targetVarName);
            aggregatedVarInstance.setId(repetitionPlanItem.getId() + targetVarName);
            instances.add(aggregatedVarInstance);
            Integer elementIndexValue = (Integer)repetitionPlanItem.getVariable(elementIndexVariable, Integer.class);
            if (elementIndexValue == null) {
                elementIndexValue = 0;
            }
            String counterValue = aggregatedVarInstance.getId() + COUNTER_VAR_VALUE_SEPARATOR + elementIndexValue;
            VariableInstanceEntity counterVarInstance = CmmnAggregation.createScopedVariableAggregationVariableInstance(repetitionPlanItem.getTenantId(), COUNTER_VAR_PREFIX + targetVarName, aggregatedVarInstance.getScopeId(), aggregatedVarInstance.getSubScopeId(), counterValue, variableServiceConfiguration);
            instances.add(counterVarInstance);
        }
        if (!instances.isEmpty()) {
            Map<String, List<VariableInstance>> instancesByName = CmmnAggregation.groupVariableInstancesByName(instances);
            List<VariableInstance> targetVariableInstances = instancesByName.get(targetVarName);
            List<VariableInstance> counterVariables = instancesByName.getOrDefault(COUNTER_VAR_PREFIX + targetVarName, Collections.emptyList());
            CmmnAggregation.sortVariablesByCounter(targetVariableInstances, counterVariables);
            return aggregator.aggregateMultiVariables((DelegatePlanItemInstance)planItemInstance, targetVariableInstances, aggregationContext);
        }
        return null;
    }

    public static VariableInstanceEntity createScopedVariableAggregationVariableInstance(String tenantId, String varName, String scopeId, String subScopeId, Object value, VariableServiceConfiguration variableServiceConfiguration) {
        VariableService variableService = variableServiceConfiguration.getVariableService();
        VariableInstanceEntity variableInstance = variableService.createVariableInstance(varName);
        variableInstance.setScopeId(scopeId);
        variableInstance.setSubScopeId(subScopeId);
        variableInstance.setScopeType("cmmnVariableAggregation");
        variableServiceConfiguration.getVariableInstanceValueModifier().setVariableValue((VariableInstance)variableInstance, value, tenantId);
        return variableInstance;
    }

    public static Map<String, List<VariableInstance>> groupVariableInstancesByName(List<? extends VariableInstance> instances) {
        return instances.stream().collect(Collectors.groupingBy(ValueFields::getName));
    }

    public static PlanItemVariableAggregator resolveVariableAggregator(VariableAggregationDefinition aggregation, DelegatePlanItemInstance planItemInstance) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
        if ("class".equalsIgnoreCase(aggregation.getImplementationType())) {
            return cmmnEngineConfiguration.getClassDelegateFactory().create(aggregation.getImplementation(), null);
        }
        if ("delegateExpression".equalsIgnoreCase(aggregation.getImplementationType())) {
            Object delegate = DelegateExpressionUtil.resolveDelegateExpression(cmmnEngineConfiguration.getExpressionManager().createExpression(aggregation.getImplementation()), (VariableContainer)planItemInstance, null);
            if (delegate instanceof PlanItemVariableAggregator) {
                return (PlanItemVariableAggregator)delegate;
            }
            throw new FlowableIllegalArgumentException("Delegate expression " + aggregation.getImplementation() + " did not resolve to an implementation of " + PlanItemVariableAggregator.class);
        }
        return cmmnEngineConfiguration.getVariableAggregator();
    }

    public static void sortVariablesByCounter(List<VariableInstance> variableInstances, List<VariableInstance> counterVariableInstances) {
        if (counterVariableInstances == null || counterVariableInstances.isEmpty()) {
            return;
        }
        HashMap<String, Integer> sortOrder = new HashMap<String, Integer>();
        for (VariableInstance counterVariable : counterVariableInstances) {
            Object value = counterVariable.getValue();
            String[] values = value.toString().split(COUNTER_VAR_VALUE_SEPARATOR);
            String variableInstanceId = values[0];
            int order = Integer.parseInt(values[1]);
            sortOrder.put(variableInstanceId, order);
        }
        variableInstances.sort(Comparator.comparingInt(o -> sortOrder.getOrDefault(o.getId(), 0)));
    }

    public static Map<String, VariableAggregationDefinition> groupAggregationsByTarget(VariableScope scope, Collection<VariableAggregationDefinition> aggregations, CmmnEngineConfiguration cmmnEngineConfiguration) {
        HashMap<String, VariableAggregationDefinition> aggregationsByTarget = new HashMap<String, VariableAggregationDefinition>();
        for (VariableAggregationDefinition aggregation : aggregations) {
            String targetVarName = CmmnAggregation.getAggregationTargetVarName(aggregation, scope, cmmnEngineConfiguration);
            aggregationsByTarget.put(targetVarName, aggregation);
        }
        return aggregationsByTarget;
    }

    public static String getAggregationTargetVarName(VariableAggregationDefinition aggregation, VariableScope parentScope, CmmnEngineConfiguration cmmnEngineConfiguration) {
        String targetVarName = null;
        if (StringUtils.isNotEmpty((CharSequence)aggregation.getTargetExpression())) {
            Object value = cmmnEngineConfiguration.getExpressionManager().createExpression(aggregation.getTargetExpression()).getValue((VariableContainer)parentScope);
            if (value != null) {
                targetVarName = value.toString();
            }
        } else if (StringUtils.isNotEmpty((CharSequence)aggregation.getTarget())) {
            targetVarName = aggregation.getTarget();
        }
        return targetVarName;
    }
}

