/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.test.impl;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnHistoryTestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnHistoryTestHelper.class);

    public static boolean isHistoryLevelAtLeast(HistoryLevel historyLevel, CmmnEngineConfiguration cmmnEngineConfiguration) {
        return CmmnHistoryTestHelper.isHistoryLevelAtLeast(historyLevel, cmmnEngineConfiguration, 20000L);
    }

    public static boolean isHistoryLevelAtLeast(HistoryLevel historyLevel, CmmnEngineConfiguration cmmnEngineConfiguration, long time) {
        if (cmmnEngineConfiguration.getHistoryLevel().isAtLeast(historyLevel)) {
            if (cmmnEngineConfiguration.isAsyncHistoryEnabled()) {
                LOGGER.debug("CMMN engine is configured to use asynchronous history. Processing async history jobs now, before continuing.");
                CmmnHistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(cmmnEngineConfiguration, cmmnEngineConfiguration.getCmmnManagementService(), time, 200L);
            }
            return true;
        }
        return false;
    }

    public static void waitForJobExecutorToProcessAllHistoryJobs(CmmnEngineConfiguration cmmnEngineConfiguration, CmmnManagementService managementService, long maxMillisToWait, long intervalMillis) {
        CmmnHistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(cmmnEngineConfiguration, managementService, maxMillisToWait, intervalMillis, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForJobExecutorToProcessAllHistoryJobs(CmmnEngineConfiguration cmmnEngineConfiguration, CmmnManagementService managementService, long maxMillisToWait, long intervalMillis, boolean shutdownExecutorWhenFinished) {
        if (cmmnEngineConfiguration.isAsyncHistoryEnabled()) {
            AsyncExecutor asyncHistoryExecutor = cmmnEngineConfiguration.getAsyncHistoryExecutor();
            if (!asyncHistoryExecutor.isActive()) {
                asyncHistoryExecutor.start();
            }
            try {
                Timer timer = new Timer();
                InterruptTask task = new InterruptTask(Thread.currentThread());
                timer.schedule((TimerTask)task, maxMillisToWait);
                boolean areJobsAvailable = true;
                try {
                    while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                        Thread.sleep(intervalMillis);
                        try {
                            areJobsAvailable = CmmnHistoryTestHelper.areHistoryJobsAvailable(managementService);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    timer.cancel();
                }
                if (areJobsAvailable) {
                    List historyJobs = managementService.createHistoryJobQuery().list();
                    String jobData = historyJobs.stream().map(job -> String.format("Job id=%s, handlerType=%s, retries=%d, exceptionMessage=%s, handlerConfiguration=%s, advancedJobHandlerConfiguration=%s", job.getId(), job.getJobHandlerType(), job.getRetries(), job.getExceptionMessage(), job.getJobHandlerConfiguration(), managementService.getHistoryJobHistoryJson(job.getId()))).collect(Collectors.joining("\n"));
                    throw new FlowableException("time limit of " + maxMillisToWait + " was exceeded. Remaining, unprocessed jobs:\n" + jobData);
                }
            }
            finally {
                if (shutdownExecutorWhenFinished) {
                    asyncHistoryExecutor.shutdown();
                }
            }
        }
    }

    public static boolean areHistoryJobsAvailable(CmmnManagementService managementService) {
        return !managementService.createHistoryJobQuery().list().isEmpty();
    }

    private static class InterruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded;
        protected Thread thread;

        public InterruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

