/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormDefinition;
import org.flowable.form.api.FormDefinitionQuery;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormRepositoryService;

public class GetFormDefinitionsForCaseDefinitionCmd
implements Command<List<FormDefinition>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected FormRepositoryService formRepositoryService;

    public GetFormDefinitionsForCaseDefinitionCmd(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public List<FormDefinition> execute(CommandContext commandContext) {
        CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(this.caseDefinitionId);
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find case definition for id: " + this.caseDefinitionId, CaseDefinition.class);
        }
        Case caseModel = CaseDefinitionUtil.getCase(this.caseDefinitionId);
        if (caseModel == null) {
            throw new FlowableObjectNotFoundException("Cannot find case definition for id: " + this.caseDefinitionId, Case.class);
        }
        this.formRepositoryService = CommandContextUtil.getFormEngineConfiguration(commandContext).getFormRepositoryService();
        if (this.formRepositoryService == null) {
            throw new FlowableException("Form repository service is not available");
        }
        List<FormDefinition> formDefinitions = this.getFormDefinitionsFromModel(caseModel, caseDefinition);
        return formDefinitions;
    }

    protected List<FormDefinition> getFormDefinitionsFromModel(Case caseModel, CaseDefinition caseDefinition) {
        HashSet<String> formKeys = new HashSet<String>();
        ArrayList<FormDefinition> formDefinitions = new ArrayList<FormDefinition>();
        List humanTasks = caseModel.getPlanModel().findPlanItemDefinitionsOfType(HumanTask.class, true);
        for (HumanTask humanTask : humanTasks) {
            if (!StringUtils.isNotEmpty((CharSequence)humanTask.getFormKey())) continue;
            formKeys.add(humanTask.getFormKey());
        }
        for (String formKey : formKeys) {
            this.addFormDefinitionToCollection(formDefinitions, formKey, caseDefinition);
        }
        return formDefinitions;
    }

    protected void addFormDefinitionToCollection(List<FormDefinition> formDefinitions, String formKey, CaseDefinition caseDefinition) {
        FormDefinitionQuery formDefinitionQuery = this.formRepositoryService.createFormDefinitionQuery().formDefinitionKey(formKey);
        CmmnDeployment deployment = (CmmnDeployment)CommandContextUtil.getCmmnDeploymentEntityManager().findById(caseDefinition.getDeploymentId());
        if (deployment.getParentDeploymentId() != null) {
            List formDeployments = this.formRepositoryService.createDeploymentQuery().parentDeploymentId(deployment.getParentDeploymentId()).list();
            if (formDeployments != null && formDeployments.size() > 0) {
                formDefinitionQuery.deploymentId(((FormDeployment)formDeployments.get(0)).getId());
            } else {
                formDefinitionQuery.latestVersion();
            }
        } else {
            formDefinitionQuery.latestVersion();
        }
        FormDefinition formDefinition = (FormDefinition)formDefinitionQuery.singleResult();
        if (formDefinition != null) {
            formDefinitions.add(formDefinition);
        }
    }
}

