/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.job;

import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.job.AbstractCaseInstanceMigrationJobHandler;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class CaseInstanceMigrationStatusJobHandler
extends AbstractCaseInstanceMigrationJobHandler {
    public static final String TYPE = "case-migration-status";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        String batchId = CaseInstanceMigrationStatusJobHandler.getBatchIdFromHandlerCfg(configuration);
        Batch batch = batchService.getBatch(batchId);
        List batchParts = batchService.findBatchPartsByBatchId(batchId);
        int completedBatchParts = 0;
        for (BatchPart batchPart : batchParts) {
            if (batchPart.getCompleteTime() == null) continue;
            ++completedBatchParts;
        }
        if (completedBatchParts == batchParts.size()) {
            batchService.completeBatch(batch.getId(), "completed");
            job.setRepeat(null);
        } else if (batchParts.size() == 0) {
            this.updateBatchStatus(batch, batchService);
            job.setRepeat(null);
        } else {
            this.updateBatchStatus(batch, batchService);
        }
    }

    protected void updateBatchStatus(Batch batch, BatchService batchService) {
        ((BatchEntity)batch).setStatus("completed");
        batchService.updateBatch(batch);
    }
}

