/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.common.engine.api.FlowableException;

public class CaseInstanceUtil {
    public static List<PlanItemInstanceEntity> findChildPlanItemInstances(CaseInstanceEntity caseInstanceEntity, PlanItem planItem) {
        return CaseInstanceUtil.getAllChildPlanItemInstances(caseInstanceEntity).stream().filter(planItemInstance -> planItem.getId().equals(planItemInstance.getPlanItem().getId())).collect(Collectors.toList());
    }

    public static List<PlanItemInstanceEntity> findNonTerminalChildPlanItemInstances(CaseInstanceEntity caseInstanceEntity, PlanItem planItem) {
        List<PlanItemInstanceEntity> childPlanItemInstances = CaseInstanceUtil.getAllChildPlanItemInstances(caseInstanceEntity);
        return childPlanItemInstances.stream().filter(planItemInstance -> planItem.getId().equals(planItemInstance.getPlanItem().getId()) && !PlanItemInstanceState.isInTerminalState((PlanItemInstance)planItemInstance)).collect(Collectors.toList());
    }

    public static List<PlanItemInstanceEntity> findChildPlanItemInstances(CaseInstanceEntity caseInstanceEntity, List<PlanItem> planItems) {
        List planItemIds = planItems.stream().map(BaseElement::getId).collect(Collectors.toList());
        List<PlanItemInstanceEntity> childPlanItemInstances = CaseInstanceUtil.getAllChildPlanItemInstances(caseInstanceEntity);
        return childPlanItemInstances.stream().filter(planItemInstance -> planItemIds.contains(planItemInstance.getPlanItem().getId())).collect(Collectors.toList());
    }

    public static Map<String, List<PlanItemInstanceEntity>> findChildPlanItemInstancesMap(CaseInstanceEntity caseInstanceEntity, List<PlanItem> planItems) {
        HashMap<String, List<PlanItemInstanceEntity>> result = new HashMap<String, List<PlanItemInstanceEntity>>();
        List planItemIds = planItems.stream().map(BaseElement::getId).collect(Collectors.toList());
        List<PlanItemInstanceEntity> childPlanItemInstances = CaseInstanceUtil.getAllChildPlanItemInstances(caseInstanceEntity);
        for (PlanItemInstanceEntity childPlanItemInstance : childPlanItemInstances) {
            PlanItem childPlanItem = childPlanItemInstance.getPlanItem();
            if (childPlanItem == null || !planItemIds.contains(childPlanItem.getId())) continue;
            if (!result.containsKey(childPlanItem.getId())) {
                result.put(childPlanItem.getId(), new ArrayList());
            }
            ((List)result.get(childPlanItem.getId())).add(childPlanItemInstance);
        }
        return result;
    }

    public static List<PlanItemInstanceEntity> getAllChildPlanItemInstances(CaseInstanceEntity caseInstanceEntity) {
        if (caseInstanceEntity == null) {
            throw new FlowableException("Programmatic error: case instance entity is null");
        }
        ArrayList<PlanItemInstanceEntity> planItemInstances = new ArrayList<PlanItemInstanceEntity>();
        CaseInstanceUtil.internalCollectPlanItemInstances(caseInstanceEntity, planItemInstances);
        return planItemInstances;
    }

    protected static void internalCollectPlanItemInstances(PlanItemInstanceContainer planItemInstanceContainer, List<PlanItemInstanceEntity> planItemInstances) {
        List<PlanItemInstanceEntity> childPlanItemInstances = planItemInstanceContainer.getChildPlanItemInstances();
        if (childPlanItemInstances != null && !childPlanItemInstances.isEmpty()) {
            for (PlanItemInstanceEntity childPlanItemInstanceEntity : childPlanItemInstances) {
                planItemInstances.add(childPlanItemInstanceEntity);
                CaseInstanceUtil.internalCollectPlanItemInstances(childPlanItemInstanceEntity, planItemInstances);
            }
        }
    }
}

