/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.agenda.operation.ActivateAsyncPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ActivatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.AsyncLeaveActivePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ChangePlanItemInstanceToAvailableOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CmmnOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CompleteCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CompletePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CreatePlanItemInstanceForRepetitionOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CreatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CreatePlanItemInstanceWithoutEvaluationOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CreateRepeatedPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.DisablePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.DismissPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.EnablePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.EvaluateCriteriaOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.EvaluateToActivatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.EvaluateVariableEventListenersOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ExitPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.InitPlanModelInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.InitStageInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.InitiatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.OccurPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ReactivateCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ReactivatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ReactivatePlanModelInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.StartPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.TerminateCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.TerminatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.TriggerPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.behavior.impl.ChildTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.criteria.PlanItemLifeCycleEvent;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.interceptor.MigrationContext;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.common.engine.impl.agenda.AbstractAgenda;
import org.flowable.common.engine.impl.agenda.AgendaFutureMaxWaitTimeoutProvider;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCmmnEngineAgenda
extends AbstractAgenda
implements CmmnEngineAgenda {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCmmnEngineAgenda.class);
    protected final LinkedList<EvaluateCriteriaOperation> evaluateCriteriaOperations = new LinkedList();

    public DefaultCmmnEngineAgenda(CommandContext commandContext) {
        super(commandContext);
    }

    public boolean isEmpty() {
        return super.isEmpty() && this.evaluateCriteriaOperations.isEmpty();
    }

    public Runnable getNextOperation() {
        if (this.operations.isEmpty() && !this.evaluateCriteriaOperations.isEmpty()) {
            return this.evaluateCriteriaOperations.poll();
        }
        return super.getNextOperation();
    }

    public void addOperation(CmmnOperation operation) {
        operation.onPlanned();
        if (operation instanceof EvaluateCriteriaOperation) {
            EvaluateCriteriaOperation evaluateCriteriaOperation = (EvaluateCriteriaOperation)operation;
            this.evaluateCriteriaOperations.addLast(evaluateCriteriaOperation);
        } else {
            this.operations.addLast(operation);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Planned {}", (Object)operation);
        }
    }

    protected AgendaFutureMaxWaitTimeoutProvider getAgendaFutureMaxWaitTimeoutProvider() {
        return CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getAgendaFutureMaxWaitTimeoutProvider();
    }

    @Override
    public void planInitPlanModelOperation(CaseInstanceEntity caseInstanceEntity) {
        this.addOperation(new InitPlanModelInstanceOperation(this.commandContext, caseInstanceEntity));
    }

    @Override
    public void planReactivateCaseInstanceOperation(CaseInstanceEntity caseInstanceEntity) {
        this.addOperation(new ReactivateCaseInstanceOperation(this.commandContext, caseInstanceEntity));
    }

    @Override
    public void planReactivatePlanModelOperation(CaseInstanceEntity caseInstanceEntity, List<PlanItem> directlyReactivatedPlanItems) {
        this.addOperation(new ReactivatePlanModelInstanceOperation(this.commandContext, caseInstanceEntity, directlyReactivatedPlanItems));
    }

    @Override
    public void planInitStageOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new InitStageInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planEvaluateCriteriaOperation(String caseInstanceEntityId) {
        this.internalPlanEvaluateCriteria(caseInstanceEntityId, null, false);
    }

    @Override
    public void planEvaluateCriteriaOperation(String caseInstanceEntityId, boolean evaluateCaseInstanceCompleted) {
        this.internalPlanEvaluateCriteria(caseInstanceEntityId, null, evaluateCaseInstanceCompleted);
    }

    @Override
    public void planEvaluateCriteriaOperation(String caseInstanceEntityId, PlanItemLifeCycleEvent lifeCycleEvent) {
        this.internalPlanEvaluateCriteria(caseInstanceEntityId, lifeCycleEvent, false);
    }

    @Override
    public void planEvaluateCriteriaOperation(String caseInstanceEntityId, MigrationContext migrationContext) {
        EvaluateCriteriaOperation evaluateCriteriaOperation = new EvaluateCriteriaOperation(this.commandContext, caseInstanceEntityId, null);
        evaluateCriteriaOperation.setEvaluateStagesAndCaseInstanceCompletion(false);
        evaluateCriteriaOperation.setMigrationContext(migrationContext);
        this.addOperation(evaluateCriteriaOperation);
    }

    protected void internalPlanEvaluateCriteria(String caseInstanceEntityId, PlanItemLifeCycleEvent planItemLifeCycleEvent, boolean evaluateCaseInstanceCompleted) {
        EvaluateCriteriaOperation evaluateCriteriaOperation = new EvaluateCriteriaOperation(this.commandContext, caseInstanceEntityId, planItemLifeCycleEvent);
        evaluateCriteriaOperation.setEvaluateStagesAndCaseInstanceCompletion(evaluateCaseInstanceCompleted);
        this.addOperation(evaluateCriteriaOperation);
    }

    @Override
    public void planCreatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new CreatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planCreatePlanItemInstanceWithoutEvaluationOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new CreatePlanItemInstanceWithoutEvaluationOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planCreateRepeatedPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new CreateRepeatedPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planReactivatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new ReactivatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planCreatePlanItemInstanceForRepetitionOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new CreatePlanItemInstanceForRepetitionOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planInitiatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new InitiatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planDismissPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new DismissPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planActivatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        this.addOperation(new ActivatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId));
    }

    @Override
    public void planEvaluateToActivatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new EvaluateToActivatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planStartPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        this.addOperation(new StartPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId));
    }

    @Override
    public void planStartPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId, ChildTaskActivityBehavior.VariableInfo childTaskVariableInfo) {
        this.addOperation(new StartPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId, childTaskVariableInfo));
    }

    @Override
    public void planStartPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId, MigrationContext migrationContext) {
        this.addOperation(new StartPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId, migrationContext));
    }

    @Override
    public void planEnablePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        this.addOperation(new EnablePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId));
    }

    @Override
    public void planActivateAsyncPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        this.addOperation(new ActivateAsyncPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId));
    }

    @Override
    public void planAsyncLeaveActivePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String transition, Map<String, String> transitionMetadata) {
        this.addOperation(new AsyncLeaveActivePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, transition, transitionMetadata));
    }

    @Override
    public void planDisablePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new DisablePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planCompletePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new CompletePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planOccurPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new OccurPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planExitPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String exitCriterionId, String exitType, String exitEventType) {
        this.addOperation(new ExitPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, exitCriterionId, exitType, exitEventType));
    }

    @Override
    public void planTerminatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String exitType, String exitEventType) {
        this.addOperation(new TerminatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, exitType, exitEventType));
    }

    @Override
    public void planChangePlanItemInstanceToAvailableOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new ChangePlanItemInstanceToAvailableOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planTriggerPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new TriggerPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity));
    }

    @Override
    public void planCompleteCaseInstanceOperation(CaseInstanceEntity caseInstanceEntity) {
        this.addOperation(new CompleteCaseInstanceOperation(this.commandContext, caseInstanceEntity));
    }

    @Override
    public void planManualTerminateCaseInstanceOperation(String caseInstanceEntityId) {
        this.addOperation(new TerminateCaseInstanceOperation(this.commandContext, caseInstanceEntityId, true, null, null, null));
    }

    @Override
    public void planTerminateCaseInstanceOperation(String caseInstanceEntityId, String exitCriterionId, String exitType, String exitEventType) {
        this.addOperation(new TerminateCaseInstanceOperation(this.commandContext, caseInstanceEntityId, false, exitCriterionId, exitType, exitEventType));
    }

    @Override
    public void planEvaluateVariableEventListenersOperation(String caseInstanceEntityId) {
        this.addOperation(new EvaluateVariableEventListenersOperation(this.commandContext, caseInstanceEntityId));
    }
}

