/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.converter.util.CriterionUtil;
import org.flowable.cmmn.converter.util.PlanItemUtil;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.PlanItemEvaluationResult;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.criteria.PlanItemLifeCycleEvent;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CountingPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.EntityWithSentryPartInstances;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntityManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CaseInstanceUtil;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.CompletionEvaluationResult;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceContainerUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceUtil;
import org.flowable.cmmn.engine.interceptor.MigrationContext;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.ParentCompletionRule;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryIfPart;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEvaluationCriteriaOperation
extends AbstractCaseInstanceOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEvaluationCriteriaOperation.class);
    protected PlanItemLifeCycleEvent planItemLifeCycleEvent;
    protected boolean evaluateStagesAndCaseInstanceCompletion;

    public AbstractEvaluationCriteriaOperation(CommandContext commandContext, String caseInstanceId, CaseInstanceEntity caseInstanceEntity, PlanItemLifeCycleEvent planItemLifeCycleEvent) {
        super(commandContext, caseInstanceId, caseInstanceEntity);
        this.planItemLifeCycleEvent = planItemLifeCycleEvent;
    }

    public void evaluateForActivation(PlanItemInstanceEntity planItemInstanceEntity, PlanItemInstanceContainer planItemInstanceContainer, PlanItemEvaluationResult evaluationResult) {
        PlanItem planItem = planItemInstanceEntity.getPlanItem();
        Criterion satisfiedEntryCriterion = this.evaluateEntryCriteria(planItemInstanceEntity, planItem);
        if (planItem != null && planItem.getEntryCriteria().isEmpty() || satisfiedEntryCriterion != null) {
            boolean activatePlanItemInstance = PlanItemInstanceUtil.evaluateRepetitionRule(planItemInstanceEntity, satisfiedEntryCriterion, planItemInstanceContainer, evaluationResult, this.commandContext);
            if (planItem.getPlanItemDefinition() instanceof EventListener) {
                activatePlanItemInstance = false;
            }
            if (activatePlanItemInstance) {
                planItemInstanceEntity.setPlannedForActivationInMigration(true);
                evaluationResult.markCriteriaChanged();
                CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(planItemInstanceEntity, satisfiedEntryCriterion != null ? satisfiedEntryCriterion.getId() : null);
            }
        }
    }

    public boolean evaluateForCompletion(PlanItemInstanceEntity planItemInstanceEntity, PlanItemEvaluationResult evaluationResult) {
        PlanItem planItem = planItemInstanceEntity.getPlanItem();
        if (planItem == null) {
            return false;
        }
        String state = planItemInstanceEntity.getState();
        Criterion satisfiedExitCriterion = this.evaluateExitCriteria(planItemInstanceEntity, (HasExitCriteria)planItem);
        if (satisfiedExitCriterion != null) {
            evaluationResult.markCriteriaChanged();
            CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(planItemInstanceEntity, satisfiedExitCriterion.getId(), satisfiedExitCriterion.getExitType(), satisfiedExitCriterion.getExitEventType());
        } else if (planItem.getPlanItemDefinition() instanceof Stage) {
            if ("active".equals(state)) {
                if (!planItemInstanceEntity.isStateChangeUnprocessed()) {
                    boolean criteriaChangeOrActiveChildrenForStage = this.evaluatePlanItemsCriteria(planItemInstanceEntity, null);
                    if (criteriaChangeOrActiveChildrenForStage) {
                        evaluationResult.markCriteriaChanged();
                        planItemInstanceEntity.setCompletable(false);
                    } else {
                        Stage stage = (Stage)planItem.getPlanItemDefinition();
                        if (this.isStageCompletable(planItemInstanceEntity, stage)) {
                            evaluationResult.markCriteriaChanged();
                            CommandContextUtil.getAgenda(this.commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
                        }
                    }
                } else {
                    planItemInstanceEntity.setCompletable(false);
                }
            }
        } else if ("active".equals(state)) {
            if (planItem.getItemControl() != null && planItem.getItemControl().getParentCompletionRule() != null) {
                ParentCompletionRule parentCompletionRule = planItem.getItemControl().getParentCompletionRule();
                if ("ignore".equals(parentCompletionRule.getType())) {
                    return true;
                }
                if ("ignoreAfterFirstCompletion".equals(parentCompletionRule.getType()) && evaluationResult.hasCompletedPlanItemInstance(planItemInstanceEntity)) {
                    return true;
                }
            }
            evaluationResult.increaseActiveChildren();
        } else if (PlanItemInstanceState.ACTIVE_STATES.contains(state)) {
            evaluationResult.increaseActiveChildren();
        }
        return false;
    }

    protected boolean evaluatePlanItemsCriteria(PlanItemInstanceContainer planItemInstanceContainer, MigrationContext migrationContext) {
        List<PlanItemInstanceEntity> planItemInstances = planItemInstanceContainer.getChildPlanItemInstances();
        if ((planItemInstances == null || migrationContext != null && migrationContext.isFetchPlanItemInstances()) && planItemInstanceContainer instanceof CaseInstanceEntity) {
            PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(this.commandContext);
            CaseInstanceEntity caseInstance = (CaseInstanceEntity)planItemInstanceContainer;
            planItemInstances = planItemInstanceEntityManager.findByCaseInstanceId(caseInstance.getId());
            planItemInstanceContainer.setChildPlanItemInstances(planItemInstances);
            if (migrationContext != null && migrationContext.isFetchPlanItemInstances()) {
                migrationContext.setFetchPlanItemInstances(false);
            }
        }
        PlanItemEvaluationResult evaluationResult = new PlanItemEvaluationResult(planItemInstances);
        for (int planItemInstanceIndex = 0; planItemInstanceIndex < planItemInstances.size(); ++planItemInstanceIndex) {
            PlanItemInstanceEntity planItemInstanceEntity = planItemInstances.get(planItemInstanceIndex);
            String state = planItemInstanceEntity.getState();
            if (PlanItemInstanceState.EVALUATE_ENTRY_CRITERIA_STATES.contains(state) && !planItemInstanceEntity.isPlannedForActivationInMigration()) {
                this.evaluateForActivation(planItemInstanceEntity, planItemInstanceContainer, evaluationResult);
            }
            if (!PlanItemInstanceState.END_STATES.contains(state) && this.evaluateForCompletion(planItemInstanceEntity, evaluationResult) || planItemInstanceEntity.getState() != null) continue;
            evaluationResult.markCriteriaChanged();
        }
        if (this.evaluatePlanItemsWithAvailableCondition(planItemInstanceContainer)) {
            evaluationResult.markCriteriaChanged();
        }
        this.evaluateDependentPlanItems();
        if (evaluationResult.hasNewChildPlanItemInstances()) {
            for (PlanItemInstanceEntity newChildPlanItemInstance : evaluationResult.getNewChildPlanItemInstances()) {
                planItemInstanceContainer.getChildPlanItemInstances().add(newChildPlanItemInstance);
            }
        }
        return evaluationResult.criteriaChangedOrNewActiveChildren();
    }

    protected void evaluateDependentPlanItems() {
        if (this.planItemLifeCycleEvent == null) {
            return;
        }
        List entryDependentPlanItems = this.planItemLifeCycleEvent.getPlanItem().getEntryDependentPlanItems();
        for (PlanItem entryDependentPlanItem : entryDependentPlanItems) {
            Criterion satisfiedCriterion;
            if (this.planItemsShareDirectParentStage(entryDependentPlanItem, this.planItemLifeCycleEvent.getPlanItem()) || !CriterionUtil.planItemHasOneEntryCriterionDependingOnPlanItem((PlanItem)entryDependentPlanItem, (PlanItem)this.planItemLifeCycleEvent.getPlanItem(), (String)this.planItemLifeCycleEvent.getTransition())) continue;
            PlanItemInstanceEntityManager planItemInstanceEntityManager = CommandContextUtil.getPlanItemInstanceEntityManager(this.commandContext);
            List<PlanItemInstanceEntity> childPlanItemInstances = CaseInstanceUtil.findChildPlanItemInstances(this.caseInstanceEntity, entryDependentPlanItem);
            List<PlanItemInstanceEntity> potentialTerminatedPlanItemInstances = planItemInstanceEntityManager.findByCaseInstanceIdAndPlanItemId(this.caseInstanceEntity.getId(), entryDependentPlanItem.getId());
            if (!childPlanItemInstances.isEmpty() || !potentialTerminatedPlanItemInstances.isEmpty() && (!ExpressionUtil.hasRepetitionRule(entryDependentPlanItem) || !ExpressionUtil.evaluateRepetitionRule(this.commandContext, (VariableContainer)this.caseInstanceEntity, entryDependentPlanItem.getItemControl().getRepetitionRule().getCondition())) || (satisfiedCriterion = this.evaluateDependentPlanItemEntryCriteria(entryDependentPlanItem)) == null) continue;
            List parentPlanItems = PlanItemUtil.getAllParentPlanItems((PlanItem)entryDependentPlanItem);
            Map<String, List<PlanItemInstanceEntity>> existingPlanItemInstancesMap = CaseInstanceUtil.findChildPlanItemInstancesMap(this.caseInstanceEntity, parentPlanItems);
            ArrayList<PlanItemInstanceEntity> parentPlanItemInstancesToActivate = new ArrayList<PlanItemInstanceEntity>();
            Object previousParentPlanItemInstance = null;
            for (int i = parentPlanItems.size() - 1; i >= 0; --i) {
                PlanItem parentPlanItem = (PlanItem)parentPlanItems.get(i);
                List<PlanItemInstanceEntity> parentPlanItemInstances = existingPlanItemInstancesMap.get(parentPlanItem.getId());
                if (parentPlanItemInstances == null || parentPlanItemInstances.isEmpty()) {
                    PlanItemInstanceEntity parentPlanItemInstance = planItemInstanceEntityManager.createPlanItemInstanceEntityBuilder().planItem(parentPlanItem).caseDefinitionId(this.caseInstanceEntity.getCaseDefinitionId()).caseInstanceId(this.caseInstanceEntity.getId()).stagePlanItemInstance((PlanItemInstance)previousParentPlanItemInstance).tenantId(this.caseInstanceEntity.getTenantId()).addToParent(true).create();
                    parentPlanItemInstancesToActivate.add(parentPlanItemInstance);
                    previousParentPlanItemInstance = parentPlanItemInstance;
                    continue;
                }
                for (PlanItemInstanceEntity parentPlanItemInstance : parentPlanItemInstances) {
                    if ("active".equals(parentPlanItemInstance.getState())) continue;
                    parentPlanItemInstancesToActivate.add(parentPlanItemInstance);
                }
                previousParentPlanItemInstance = (PlanItemInstance)parentPlanItemInstances.get(0);
            }
            PlanItemInstanceEntity entryDependentPlanItemInstance = planItemInstanceEntityManager.createPlanItemInstanceEntityBuilder().planItem(entryDependentPlanItem).caseDefinitionId(this.caseInstanceEntity.getCaseDefinitionId()).caseInstanceId(this.caseInstanceEntity.getId()).stagePlanItemInstance((PlanItemInstance)previousParentPlanItemInstance).tenantId(this.caseInstanceEntity.getTenantId()).addToParent(true).create();
            CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceOperation(entryDependentPlanItemInstance);
            if (!entryDependentPlanItem.getEntryCriteria().isEmpty() && ExpressionUtil.hasRepetitionRule(entryDependentPlanItemInstance) && ExpressionUtil.evaluateRepetitionRule(this.commandContext, entryDependentPlanItemInstance, (PlanItemInstanceContainer)null)) {
                PlanItemInstanceUtil.createPlanItemInstanceDuplicateForRepetition(entryDependentPlanItemInstance, this.commandContext);
            }
            CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(entryDependentPlanItemInstance, satisfiedCriterion.getId());
            for (int i = parentPlanItemInstancesToActivate.size() - 1; i >= 0; --i) {
                PlanItemInstanceEntity parentPlanItemInstance = (PlanItemInstanceEntity)parentPlanItemInstancesToActivate.get(i);
                if (parentPlanItemInstance.getState() == null) {
                    CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceOperation(parentPlanItemInstance);
                }
                CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(parentPlanItemInstance, null);
            }
        }
    }

    protected boolean isStageCompletable(PlanItemInstanceEntity stagePlanItemInstanceEntity, Stage stage) {
        boolean autoComplete = ExpressionUtil.evaluateAutoComplete(this.commandContext, (VariableContainer)stagePlanItemInstanceEntity, stage);
        if (!autoComplete || this.evaluateStagesAndCaseInstanceCompletion) {
            CompletionEvaluationResult completionEvaluationResult = PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(this.commandContext, stagePlanItemInstanceEntity, autoComplete);
            if (completionEvaluationResult.isCompletable()) {
                stagePlanItemInstanceEntity.setCompletable(true);
            }
            return completionEvaluationResult.shouldBeCompleted();
        }
        return false;
    }

    protected boolean evaluatePlanModelComplete() {
        boolean planItemInstancesChanged;
        boolean isAutoComplete = ExpressionUtil.evaluateAutoComplete(this.commandContext, (VariableContainer)this.caseInstanceEntity, CaseDefinitionUtil.getCase(this.caseInstanceEntity.getCaseDefinitionId()).getPlanModel());
        CompletionEvaluationResult completionEvaluationResult = PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(this.commandContext, this.caseInstanceEntity, isAutoComplete);
        boolean previousCompletableState = this.caseInstanceEntity.isCompletable();
        this.caseInstanceEntity.setCompletable(completionEvaluationResult.isCompletable());
        if (previousCompletableState != this.caseInstanceEntity.isCompletable() && (planItemInstancesChanged = this.evaluatePlanItemsWithAvailableCondition(this.caseInstanceEntity)) && (completionEvaluationResult = PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(this.commandContext, this.caseInstanceEntity, isAutoComplete)).isCompletable() != this.caseInstanceEntity.isCompletable()) {
            this.caseInstanceEntity.setCompletable(completionEvaluationResult.isCompletable());
        }
        return completionEvaluationResult.shouldBeCompleted();
    }

    protected boolean evaluatePlanItemsWithAvailableCondition(PlanItemInstanceContainer planItemInstanceContainer) {
        if (!planItemInstanceContainer.getPlanItems().isEmpty()) {
            List<PlanItemInstanceEntity> planItemInstanceToInitiate = this.findChangedEventListenerInstances(planItemInstanceContainer, "unavailable", true);
            if (!planItemInstanceToInitiate.isEmpty()) {
                for (PlanItemInstanceEntity planItemInstanceEntity : planItemInstanceToInitiate) {
                    CommandContextUtil.getAgenda(this.commandContext).planInitiatePlanItemInstanceOperation(planItemInstanceEntity);
                }
                return true;
            }
            List<PlanItemInstanceEntity> planItemInstanceToDismiss = this.findChangedEventListenerInstances(planItemInstanceContainer, "available", false);
            if (!planItemInstanceToDismiss.isEmpty()) {
                for (PlanItemInstanceEntity planItemInstanceEntity : planItemInstanceToDismiss) {
                    CommandContextUtil.getAgenda(this.commandContext).planDismissPlanItemInstanceOperation(planItemInstanceEntity);
                }
                return true;
            }
        }
        return false;
    }

    protected Criterion evaluateEntryCriteria(PlanItemInstanceEntity planItemInstanceEntity, PlanItem planItem) {
        List criteria;
        if (planItem != null && (criteria = planItem.getEntryCriteria()) != null && !criteria.isEmpty()) {
            return this.evaluateCriteria(planItemInstanceEntity, criteria);
        }
        return null;
    }

    protected Criterion evaluateExitCriteria(EntityWithSentryPartInstances entityWithSentryPartInstances, HasExitCriteria hasExitCriteria) {
        List criteria;
        if (hasExitCriteria != null && (criteria = hasExitCriteria.getExitCriteria()) != null && !criteria.isEmpty()) {
            return this.evaluateCriteria(entityWithSentryPartInstances, criteria);
        }
        return null;
    }

    protected Criterion evaluateCriteria(EntityWithSentryPartInstances entityWithSentryPartInstances, List<Criterion> criteria) {
        for (Criterion criterion : criteria) {
            Sentry sentry = criterion.getSentry();
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
            if (sentry.getOnParts().size() == 1 && sentry.getSentryIfPart() == null) {
                SentryOnPart sentryOnPart;
                if (this.planItemLifeCycleEvent == null || !this.sentryOnPartMatchesCurrentLifeCycleEvent(entityWithSentryPartInstances, sentryOnPart = (SentryOnPart)sentry.getOnParts().get(0))) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}: single onPart matches life cycle event: [{}]", (Object)criterion, (Object)this.planItemLifeCycleEvent);
                }
                if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                    CmmnLoggingSessionUtil.addEvaluateSentryLoggingData(sentry.getOnParts(), entityWithSentryPartInstances, cmmnEngineConfiguration.getObjectMapper());
                }
                return criterion;
            }
            if (sentry.getOnParts().isEmpty() && sentry.getSentryIfPart() != null) {
                if (!this.evaluateSentryIfPart(entityWithSentryPartInstances, sentry, (VariableContainer)entityWithSentryPartInstances)) continue;
                if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                    CmmnLoggingSessionUtil.addEvaluateSentryLoggingData(sentry.getSentryIfPart(), entityWithSentryPartInstances, cmmnEngineConfiguration.getObjectMapper());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}: single ifPart has evaluated to true", (Object)criterion);
                }
                return criterion;
            }
            boolean isDefaultTriggerMode = sentry.isDefaultTriggerMode();
            boolean sentryIfPartSatisfied = false;
            HashSet<String> satisfiedSentryOnPartIds = new HashSet<String>(1);
            for (SentryPartInstanceEntity sentryPartInstanceEntity : entityWithSentryPartInstances.getSatisfiedSentryPartInstances()) {
                if (sentryPartInstanceEntity.getOnPartId() != null) {
                    satisfiedSentryOnPartIds.add(sentryPartInstanceEntity.getOnPartId());
                    continue;
                }
                if (sentryPartInstanceEntity.getIfPartId() == null || !sentryPartInstanceEntity.getIfPartId().equals(sentry.getSentryIfPart().getId())) continue;
                sentryIfPartSatisfied = true;
            }
            for (SentryOnPart sentryOnPart : sentry.getOnParts()) {
                if (satisfiedSentryOnPartIds.contains(sentryOnPart.getId()) || this.planItemLifeCycleEvent == null || !this.sentryOnPartMatchesCurrentLifeCycleEvent(entityWithSentryPartInstances, sentryOnPart)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{}: onPart matches life cycle event [{}]", (Object)criterion, (Object)this.planItemLifeCycleEvent);
                }
                this.createSentryPartInstanceEntity(entityWithSentryPartInstances, sentry, sentryOnPart, null);
                satisfiedSentryOnPartIds.add(sentryOnPart.getId());
            }
            boolean allOnPartsSatisfied = this.allOnPartsSatisfied(satisfiedSentryOnPartIds, sentry.getOnParts());
            if (allOnPartsSatisfied && LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}: all onParts have been satisfied", (Object)criterion);
            }
            if (sentry.getSentryIfPart() != null && !sentryIfPartSatisfied && (isDefaultTriggerMode || sentry.isOnEventTriggerMode() && allOnPartsSatisfied)) {
                if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                    CmmnLoggingSessionUtil.addEvaluateSentryLoggingData(sentry.getOnParts(), sentry.getSentryIfPart(), entityWithSentryPartInstances, cmmnEngineConfiguration.getObjectMapper());
                }
                if (this.evaluateSentryIfPart(entityWithSentryPartInstances, sentry, (VariableContainer)entityWithSentryPartInstances)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("{}: ifPart evaluates to true", (Object)criterion);
                    }
                    this.createSentryPartInstanceEntity(entityWithSentryPartInstances, sentry, null, sentry.getSentryIfPart());
                    sentryIfPartSatisfied = true;
                }
            }
            if (!allOnPartsSatisfied || !sentryIfPartSatisfied && sentry.getSentryIfPart() != null) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}: all onParts and ifParts are satisfied", (Object)criterion);
            }
            return criterion;
        }
        return null;
    }

    protected boolean evaluateAvailableCondition(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        EventListener eventListener;
        PlanItem planItem = planItemInstanceEntity.getPlanItem();
        if (this.isEventListenerWithAvailableCondition(planItem) && StringUtils.isNotEmpty((CharSequence)(eventListener = (EventListener)planItem.getPlanItemDefinition()).getAvailableConditionExpression())) {
            Expression expression = CommandContextUtil.getExpressionManager(commandContext).createExpression(eventListener.getAvailableConditionExpression());
            Object result = expression.getValue((VariableContainer)planItemInstanceEntity);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Evaluation of available condition {} results in '{}'", (Object)eventListener.getAvailableConditionExpression(), result);
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return false;
        }
        return true;
    }

    protected boolean allOnPartsSatisfied(Set<String> satisfiedSentryOnPartIds, List<SentryOnPart> sentryOnParts) {
        if (satisfiedSentryOnPartIds.size() == 0 && sentryOnParts.size() > 0) {
            return false;
        }
        for (SentryOnPart sentryOnPart : sentryOnParts) {
            if (satisfiedSentryOnPartIds.contains(sentryOnPart.getId())) continue;
            return false;
        }
        return true;
    }

    public boolean sentryOnPartMatchesCurrentLifeCycleEvent(EntityWithSentryPartInstances entityWithSentryPartInstances, SentryOnPart sentryOnPart) {
        boolean parentMatches = true;
        if (this.hasSameParentInModel(entityWithSentryPartInstances, sentryOnPart)) {
            parentMatches = Objects.equals(this.planItemLifeCycleEvent.getPlanItemInstanceEntity().getStageInstanceId(), ((PlanItemInstanceEntity)entityWithSentryPartInstances).getStageInstanceId());
        }
        return parentMatches && this.planItemLifeCycleEvent.getPlanItem().getId().equals(sentryOnPart.getSourceRef()) && this.planItemLifeCycleEvent.getTransition().equals(sentryOnPart.getStandardEvent());
    }

    protected boolean hasSameParentInModel(EntityWithSentryPartInstances entityWithSentryPartInstances, SentryOnPart sentryOnPart) {
        PlanItem evaluatedPlanItem;
        if (entityWithSentryPartInstances instanceof PlanItemInstanceEntity && (evaluatedPlanItem = ((PlanItemInstanceEntity)entityWithSentryPartInstances).getPlanItem()) != null) {
            Stage sentrySourcePlanItemParenStage;
            Stage evaluatedPlanItemParenStage = evaluatedPlanItem.getParentStage();
            PlanItem sentrySourcePlanItem = sentryOnPart.getSource();
            if (sentrySourcePlanItem != null && (sentrySourcePlanItemParenStage = sentrySourcePlanItem.getParentStage()) != null && evaluatedPlanItemParenStage != null) {
                return Objects.equals(sentrySourcePlanItemParenStage.getId(), evaluatedPlanItemParenStage.getId());
            }
        }
        return false;
    }

    protected List<PlanItemInstanceEntity> findChangedEventListenerInstances(PlanItemInstanceContainer planItemInstanceContainer, String state, boolean conditionValueToChange) {
        return planItemInstanceContainer.getChildPlanItemInstances().stream().filter(planItemInstance -> state.equals(planItemInstance.getState()) && this.isEventListenerWithAvailableCondition(planItemInstance.getPlanItem()) && conditionValueToChange == this.evaluateAvailableCondition(this.commandContext, (PlanItemInstanceEntity)planItemInstance)).collect(Collectors.toList());
    }

    protected SentryPartInstanceEntity createSentryPartInstanceEntity(EntityWithSentryPartInstances entityWithSentryPartInstances, Sentry sentry, SentryOnPart sentryOnPart, SentryIfPart sentryIfPart) {
        SentryPartInstanceEntityManager sentryPartInstanceEntityManager = CommandContextUtil.getSentryPartInstanceEntityManager(this.commandContext);
        SentryPartInstanceEntity sentryPartInstanceEntity = (SentryPartInstanceEntity)sentryPartInstanceEntityManager.create();
        sentryPartInstanceEntity.setTimeStamp(CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getClock().getCurrentTime());
        if (sentryOnPart != null) {
            sentryPartInstanceEntity.setOnPartId(sentryOnPart.getId());
        } else if (sentryIfPart != null) {
            sentryPartInstanceEntity.setIfPartId(sentryIfPart.getId());
        }
        if (entityWithSentryPartInstances instanceof CaseInstanceEntity) {
            sentryPartInstanceEntity.setCaseInstanceId(((CaseInstanceEntity)entityWithSentryPartInstances).getId());
            sentryPartInstanceEntity.setCaseDefinitionId(((CaseInstanceEntity)entityWithSentryPartInstances).getCaseDefinitionId());
        } else if (entityWithSentryPartInstances instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)entityWithSentryPartInstances;
            sentryPartInstanceEntity.setCaseInstanceId(planItemInstanceEntity.getCaseInstanceId());
            sentryPartInstanceEntity.setCaseDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
            sentryPartInstanceEntity.setPlanItemInstanceId(planItemInstanceEntity.getId());
            if (sentry.isDefaultTriggerMode() && entityWithSentryPartInstances instanceof CountingPlanItemInstanceEntity) {
                CountingPlanItemInstanceEntity countingPlanItemInstanceEntity = (CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity);
                countingPlanItemInstanceEntity.setSentryPartInstanceCount(countingPlanItemInstanceEntity.getSentryPartInstanceCount() + 1);
            }
        }
        if (sentry.isDefaultTriggerMode()) {
            sentryPartInstanceEntityManager.insert(sentryPartInstanceEntity);
        }
        entityWithSentryPartInstances.getSatisfiedSentryPartInstances().add(sentryPartInstanceEntity);
        return sentryPartInstanceEntity;
    }

    protected boolean evaluateSentryIfPart(EntityWithSentryPartInstances entityWithSentryPartInstances, Sentry sentry, VariableContainer variableContainer) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
        try {
            Expression conditionExpression = cmmnEngineConfiguration.getExpressionManager().createExpression(sentry.getSentryIfPart().getCondition());
            Object result = conditionExpression.getValue(variableContainer);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Evaluation of sentry if condition {} for {} results in '{}'", new Object[]{sentry.getSentryIfPart().getCondition(), entityWithSentryPartInstances, result});
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (RuntimeException e) {
            if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                CmmnLoggingSessionUtil.addEvaluateSentryFailedLoggingData(sentry.getSentryIfPart(), e, entityWithSentryPartInstances, cmmnEngineConfiguration.getObjectMapper());
            }
            throw e;
        }
        return false;
    }

    protected Criterion evaluateDependentPlanItemEntryCriteria(PlanItem entryDependentPlanItem) {
        List<Criterion> matchingCriteria;
        List entryCriteria = entryDependentPlanItem.getEntryCriteria();
        if (!entryCriteria.isEmpty() && !(matchingCriteria = entryCriteria.stream().filter(criterion -> CriterionUtil.criterionHasOnPartDependingOnPlanItem((Criterion)criterion, (PlanItem)this.planItemLifeCycleEvent.getPlanItem(), (String)this.planItemLifeCycleEvent.getTransition())).collect(Collectors.toList())).isEmpty()) {
            return this.evaluateCriteria(this.caseInstanceEntity, matchingCriteria);
        }
        return null;
    }

    protected boolean planItemsShareDirectParentStage(PlanItem planItemOne, PlanItem planItemTwo) {
        Stage parentStage = planItemOne.getParentStage();
        return parentStage.findPlanItemInPlanFragmentOrDownwards(planItemTwo.getId()) != null;
    }

    public PlanItemLifeCycleEvent getPlanItemLifeCycleEvent() {
        return this.planItemLifeCycleEvent;
    }

    public void setPlanItemLifeCycleEvent(PlanItemLifeCycleEvent planItemLifeCycleEvent) {
        this.planItemLifeCycleEvent = planItemLifeCycleEvent;
    }

    public boolean isEvaluateCaseInstanceCompleted() {
        return this.evaluateStagesAndCaseInstanceCompletion;
    }

    public void setEvaluateStagesAndCaseInstanceCompletion(boolean evaluateStagesAndCaseInstanceCompletion) {
        this.evaluateStagesAndCaseInstanceCompletion = evaluateStagesAndCaseInstanceCompletion;
    }
}

