/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.OnParentEndDependantActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.cmmn.engine.interceptor.CreateCasePageTaskAfterContext;
import org.flowable.cmmn.engine.interceptor.CreateCasePageTaskBeforeContext;
import org.flowable.cmmn.model.CasePageTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.assignment.CandidateUtil;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CasePageTaskActivityBehaviour
extends TaskActivityBehavior
implements PlanItemActivityBehavior,
OnParentEndDependantActivityBehavior {
    protected CasePageTask casePageTask;

    public CasePageTaskActivityBehaviour(CasePageTask casePageTask) {
        super(true, null);
        this.casePageTask = casePageTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        Collection<String> candidateValues;
        CreateCasePageTaskBeforeContext beforeContext = new CreateCasePageTaskBeforeContext(this.casePageTask, planItemInstanceEntity, this.casePageTask.getFormKey(), this.casePageTask.getAssignee(), this.casePageTask.getOwner(), this.casePageTask.getCandidateUsers(), this.casePageTask.getCandidateGroups());
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        if (cmmnEngineConfiguration.getCreateCasePageTaskInterceptor() != null) {
            cmmnEngineConfiguration.getCreateCasePageTaskInterceptor().beforeCreateCasePageTask(beforeContext);
        }
        ExpressionManager expressionManager = cmmnEngineConfiguration.getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getFormKey())) {
            planItemInstanceEntity.setFormKey(this.getExpressionValue(beforeContext.getFormKey(), planItemInstanceEntity, expressionManager));
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getAssignee())) {
            IdentityLinkUtil.createPlanItemInstanceIdentityLink((PlanItemInstance)planItemInstanceEntity, this.getExpressionValue(beforeContext.getAssignee(), planItemInstanceEntity, expressionManager), null, "assignee", cmmnEngineConfiguration);
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeContext.getOwner())) {
            IdentityLinkUtil.createPlanItemInstanceIdentityLink((PlanItemInstance)planItemInstanceEntity, this.getExpressionValue(beforeContext.getOwner(), planItemInstanceEntity, expressionManager), null, "owner", cmmnEngineConfiguration);
        }
        if (beforeContext.getCandidateUsers() != null && !beforeContext.getCandidateUsers().isEmpty()) {
            for (String candidateUser : beforeContext.getCandidateUsers()) {
                candidateValues = this.getExpressionListValue(candidateUser, planItemInstanceEntity, expressionManager);
                for (String candidate : candidateValues) {
                    IdentityLinkUtil.createPlanItemInstanceIdentityLink((PlanItemInstance)planItemInstanceEntity, candidate, null, "candidate", cmmnEngineConfiguration);
                }
            }
        }
        if (beforeContext.getCandidateGroups() != null && !beforeContext.getCandidateGroups().isEmpty()) {
            for (String candidateGroup : beforeContext.getCandidateGroups()) {
                candidateValues = this.getExpressionListValue(candidateGroup, planItemInstanceEntity, expressionManager);
                for (String candidate : candidateValues) {
                    IdentityLinkUtil.createPlanItemInstanceIdentityLink((PlanItemInstance)planItemInstanceEntity, null, candidate, "candidate", cmmnEngineConfiguration);
                }
            }
        }
        if (cmmnEngineConfiguration.getCreateCasePageTaskInterceptor() != null) {
            CreateCasePageTaskAfterContext afterContext = new CreateCasePageTaskAfterContext(this.casePageTask, planItemInstanceEntity);
            cmmnEngineConfiguration.getCreateCasePageTaskInterceptor().afterCreateCasePageTask(afterContext);
        }
        cmmnEngineConfiguration.getCmmnHistoryManager().recordPlanItemInstanceUpdated(planItemInstanceEntity);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
    }

    @Override
    public void onParentEnd(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String parentEndTransition, String exitEventType) {
        if ("complete".equals(parentEndTransition) || "complete".equals(exitEventType) || "forceComplete".equals(exitEventType)) {
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        } else {
            CommandContextUtil.getAgenda(commandContext).planTerminatePlanItemInstanceOperation(planItemInstanceEntity, null, null);
        }
    }

    protected String getExpressionValue(String value, PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager) {
        Object expressionValue = expressionManager.createExpression(value).getValue((VariableContainer)planItemInstanceEntity);
        if (expressionValue != null) {
            return expressionValue.toString();
        }
        throw new FlowableException("Unable to resolve expression value for " + value + " in " + String.valueOf(planItemInstanceEntity));
    }

    protected Collection<String> getExpressionListValue(String value, PlanItemInstanceEntity planItemInstanceEntity, ExpressionManager expressionManager) {
        Object expressionValue = expressionManager.createExpression(value).getValue((VariableContainer)planItemInstanceEntity);
        Collection candidates = CandidateUtil.extractCandidates((Object)expressionValue);
        return candidates;
    }
}

