/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.ChildTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.process.ProcessInstanceService;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.EntityLinkUtil;
import org.flowable.cmmn.model.ChildTask;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.cmmn.model.Process;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTaskActivityBehavior
extends ChildTaskActivityBehavior
implements PlanItemActivityBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTaskActivityBehavior.class);
    protected Process process;
    protected Expression processRefExpression;
    protected String processRef;
    protected Boolean fallbackToDefaultTenant;
    protected boolean sameDeployment;
    protected ProcessTask processTask;

    public ProcessTaskActivityBehavior(Process process, Expression processRefExpression, ProcessTask processTask) {
        super(processTask.isBlocking(), processTask.getBlockingExpression(), processTask.getInParameters(), processTask.getOutParameters());
        this.process = process;
        this.processRefExpression = processRefExpression;
        this.processRef = processTask.getProcessRef();
        this.fallbackToDefaultTenant = processTask.getFallbackToDefaultTenant();
        this.sameDeployment = processTask.isSameDeployment();
        this.processTask = processTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, ChildTaskActivityBehavior.VariableInfo variableInfo) {
        Expression expression;
        String idVariableName;
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        ProcessInstanceService processInstanceService = cmmnEngineConfiguration.getProcessInstanceService();
        if (processInstanceService == null) {
            throw new FlowableException("Could not start process instance: no " + String.valueOf(ProcessInstanceService.class) + " implementation found for " + String.valueOf(planItemInstanceEntity));
        }
        String externalRef = null;
        if (this.process != null) {
            externalRef = this.process.getExternalRef();
        } else if (this.processRefExpression != null) {
            externalRef = this.processRefExpression.getValue((VariableContainer)planItemInstanceEntity).toString();
        } else if (this.processRef != null) {
            externalRef = this.processRef;
        }
        if (StringUtils.isEmpty((CharSequence)externalRef)) {
            throw new FlowableException("Could not start process instance: no externalRef defined for " + String.valueOf(planItemInstanceEntity));
        }
        HashMap<String, Object> inParametersMap = new HashMap<String, Object>();
        this.handleInParameters(planItemInstanceEntity, cmmnEngineConfiguration, inParametersMap, cmmnEngineConfiguration.getExpressionManager());
        FormInfo variableFormInfo = null;
        Map<String, Object> variableFormVariables = null;
        String variableFormOutcome = null;
        if (variableInfo != null) {
            variableFormInfo = variableInfo.formInfo;
            variableFormVariables = variableInfo.formVariables;
            variableFormOutcome = variableInfo.formOutcome;
            if (variableInfo.variables != null && !variableInfo.variables.isEmpty()) {
                inParametersMap.putAll(variableInfo.variables);
            }
        }
        String processInstanceId = processInstanceService.generateNewProcessInstanceId();
        if (StringUtils.isNotEmpty((CharSequence)this.processTask.getProcessInstanceIdVariableName()) && StringUtils.isNotEmpty((CharSequence)(idVariableName = (String)(expression = cmmnEngineConfiguration.getExpressionManager().createExpression(this.processTask.getProcessInstanceIdVariableName())).getValue((VariableContainer)planItemInstanceEntity)))) {
            planItemInstanceEntity.setVariable(idVariableName, processInstanceId);
        }
        planItemInstanceEntity.setReferenceType("cmmn-1.1-to-bpmn-2.0-child-process");
        planItemInstanceEntity.setReferenceId(processInstanceId);
        String businessKey = this.getBusinessKey(cmmnEngineConfiguration, planItemInstanceEntity, (ChildTask)this.processTask);
        boolean blocking = this.evaluateIsBlocking(planItemInstanceEntity);
        String parentDeploymentId = this.getParentDeploymentIfSameDeployment(cmmnEngineConfiguration, planItemInstanceEntity);
        if (blocking) {
            if (CommandContextUtil.getCmmnEngineConfiguration(commandContext).isEnableEntityLinks()) {
                EntityLinkUtil.createEntityLinks(planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getId(), planItemInstanceEntity.getPlanItemDefinitionId(), processInstanceId, "bpmn", cmmnEngineConfiguration);
            }
            processInstanceService.startProcessInstanceByKey(externalRef, processInstanceId, planItemInstanceEntity.getId(), planItemInstanceEntity.getStageInstanceId(), planItemInstanceEntity.getTenantId(), this.fallbackToDefaultTenant, parentDeploymentId, inParametersMap, businessKey, variableFormVariables, variableFormInfo, variableFormOutcome);
        } else {
            processInstanceService.startProcessInstanceByKey(externalRef, processInstanceId, planItemInstanceEntity.getStageInstanceId(), planItemInstanceEntity.getTenantId(), this.fallbackToDefaultTenant, parentDeploymentId, inParametersMap, businessKey, variableFormVariables, variableFormInfo, variableFormOutcome);
        }
        if (!blocking) {
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        if (!"active".equals(planItemInstance.getState())) {
            throw new FlowableIllegalStateException("Can only trigger a plan item that is in the ACTIVE state");
        }
        if (planItemInstance.getReferenceId() == null) {
            throw new FlowableIllegalStateException("Cannot trigger process task plan item instance : no reference id set");
        }
        if (!"cmmn-1.1-to-bpmn-2.0-child-process".equals(planItemInstance.getReferenceType())) {
            throw new FlowableException("Cannot trigger process task plan item instance : reference type '" + planItemInstance.getReferenceType() + "' not supported for " + String.valueOf(planItemInstance));
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CaseInstanceEntity caseInstance = (CaseInstanceEntity)cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(planItemInstance.getCaseInstanceId());
        this.handleOutParameters(planItemInstance, caseInstance, cmmnEngineConfiguration.getProcessInstanceService());
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstance);
        this.deleteProcessInstance(commandContext, planItemInstance);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("active".equals(planItemInstance.getState()) && ("terminate".equals(transition) || "exit".equals(transition))) {
            this.deleteProcessInstance(commandContext, planItemInstance);
        }
    }

    protected void deleteProcessInstance(CommandContext commandContext, DelegatePlanItemInstance planItemInstance) {
        ProcessInstanceService processInstanceService = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getProcessInstanceService();
        processInstanceService.deleteProcessInstance(planItemInstance.getReferenceId());
    }

    @Override
    public void deleteChildEntity(CommandContext commandContext, DelegatePlanItemInstance delegatePlanItemInstance, boolean cascade) {
        if (!"cmmn-1.1-to-bpmn-2.0-child-process".equals(delegatePlanItemInstance.getReferenceType())) {
            throw new FlowableException("Can only delete a child entity for a plan item with reference type cmmn-1.1-to-bpmn-2.0-child-process for " + String.valueOf(delegatePlanItemInstance));
        }
        delegatePlanItemInstance.setState("terminated");
        this.deleteProcessInstance(commandContext, delegatePlanItemInstance);
    }

    protected void handleOutParameters(DelegatePlanItemInstance planItemInstance, CaseInstanceEntity caseInstance, ProcessInstanceService processInstanceService) {
        if (this.outParameters == null) {
            return;
        }
        for (IOParameter outParameter : this.outParameters) {
            String variableName = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getTarget())) {
                variableName = outParameter.getTarget();
            } else if (StringUtils.isNotEmpty((CharSequence)outParameter.getTargetExpression())) {
                Object variableNameValue = processInstanceService.resolveExpression(planItemInstance.getReferenceId(), outParameter.getTargetExpression());
                if (variableNameValue != null) {
                    variableName = variableNameValue.toString();
                } else {
                    LOGGER.warn("Out parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)outParameter.getTargetExpression());
                }
            }
            Object variableValue = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getSourceExpression())) {
                variableValue = processInstanceService.resolveExpression(planItemInstance.getReferenceId(), outParameter.getSourceExpression());
            } else if (StringUtils.isNotEmpty((CharSequence)outParameter.getSource())) {
                variableValue = processInstanceService.getVariable(planItemInstance.getReferenceId(), outParameter.getSource());
            }
            planItemInstance.setVariable(variableName, variableValue);
        }
    }

    protected String getParentDeploymentIfSameDeployment(CmmnEngineConfiguration cmmnEngineConfiguration, PlanItemInstanceEntity planItemInstanceEntity) {
        if (!this.sameDeployment) {
            return null;
        }
        return CaseDefinitionUtil.getDefinitionDeploymentId(planItemInstanceEntity.getCaseDefinitionId(), cmmnEngineConfiguration);
    }
}

