/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.cmmn.engine.impl.behavior.impl.TaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.IOParameterUtil;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;
import org.flowable.common.engine.impl.variable.MapDelegateVariableContainer;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    protected ScriptServiceTask scriptTask;

    public ScriptTaskActivityBehavior(ScriptServiceTask scriptTask) {
        super(scriptTask.isBlocking(), scriptTask.getBlockingExpression());
        this.scriptTask = scriptTask;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        ScriptingEngines scriptingEngines = CommandContextUtil.getCmmnEngineConfiguration().getScriptingEngines();
        if (scriptingEngines == null) {
            throw new FlowableException("Could not execute script task instance: no scripting engines found. For " + String.valueOf(planItemInstanceEntity));
        }
        String scriptFormat = this.scriptTask.getScriptFormat() != null ? this.scriptTask.getScriptFormat() : "juel";
        try {
            List inParameters;
            ScriptEngineRequest.Builder request = ScriptEngineRequest.builder().language(scriptFormat).script(this.scriptTask.getScript()).scopeContainer((VariableContainer)planItemInstanceEntity).traceEnhancer(trace -> trace.addTraceTag("type", "scriptTask"));
            if (this.scriptTask.isAutoStoreVariables()) {
                request.storeScriptVariables();
            }
            if ((inParameters = this.scriptTask.getInParameters()) != null && !inParameters.isEmpty()) {
                MapDelegateVariableContainer inputVariableContainer = new MapDelegateVariableContainer();
                IOParameterUtil.processInParameters((List<IOParameter>)inParameters, (VariableContainer)planItemInstanceEntity, (VariableContainer)inputVariableContainer, CommandContextUtil.getExpressionManager(commandContext));
                request.inputVariableContainer((VariableContainer)inputVariableContainer);
            } else if (this.scriptTask.isDoNotIncludeVariables()) {
                request.inputVariableContainer(VariableContainer.empty());
            }
            Object result = scriptingEngines.evaluate(request.build()).getResult();
            String resultVariableName = this.scriptTask.getResultVariableName();
            if (StringUtils.isNotBlank((CharSequence)this.scriptTask.getResultVariableName())) {
                planItemInstanceEntity.setVariable(resultVariableName.trim(), result);
            }
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
        catch (FlowableException e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof FlowableException) {
                throw (FlowableException)rootCause;
            }
            throw e;
        }
    }
}

