/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.impl.cmd.UnlockExclusiveJobCmd;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityManager;

public abstract class AbstractExternalWorkerJobCmd
implements Command<Void> {
    protected final String externalJobId;
    protected final String workerId;

    protected AbstractExternalWorkerJobCmd(String externalJobId, String workerId) {
        this.externalJobId = externalJobId;
        this.workerId = workerId;
    }

    public final Void execute(CommandContext commandContext) {
        ExternalWorkerJobEntity externalWorkerJob = this.resolveJob(commandContext);
        if (!"cmmn".equals(externalWorkerJob.getScopeType())) {
            throw new FlowableException(String.valueOf(externalWorkerJob) + " is not cmmn scoped. This command can only handle cmmn scoped external worker jobs");
        }
        this.runJobLogic(externalWorkerJob, commandContext);
        if (externalWorkerJob.isExclusive()) {
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            new UnlockExclusiveJobCmd((Job)externalWorkerJob, cmmnEngineConfiguration.getJobServiceConfiguration()).execute(commandContext);
        }
        return null;
    }

    protected abstract void runJobLogic(ExternalWorkerJobEntity var1, CommandContext var2);

    protected void moveExternalWorkerJobToExecutableJob(ExternalWorkerJobEntity externalWorkerJob, CommandContext commandContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        cmmnEngineConfiguration.getJobServiceConfiguration().getJobManager().moveExternalWorkerJobToExecutableJob(externalWorkerJob);
        cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().deleteIdentityLinksByScopeIdAndType(externalWorkerJob.getCorrelationId(), "externalWorker");
    }

    protected ExternalWorkerJobEntity resolveJob(CommandContext commandContext) {
        if (StringUtils.isEmpty((CharSequence)this.externalJobId)) {
            throw new FlowableIllegalArgumentException("externalJobId must not be empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.workerId)) {
            throw new FlowableIllegalArgumentException("workerId must not be empty");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        ExternalWorkerJobEntityManager externalWorkerJobEntityManager = cmmnEngineConfiguration.getJobServiceConfiguration().getExternalWorkerJobEntityManager();
        ExternalWorkerJobEntity job = (ExternalWorkerJobEntity)externalWorkerJobEntityManager.findById(this.externalJobId);
        if (job == null) {
            throw new FlowableObjectNotFoundException("No External Worker job found for id: " + this.externalJobId, ExternalWorkerJobEntity.class);
        }
        if (!Objects.equals(this.workerId, job.getLockOwner())) {
            throw new FlowableIllegalArgumentException(this.workerId + " does not hold a lock on the requested job");
        }
        return job;
    }
}

