/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Map;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.AbstractSetVariableAsyncCmd;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetVariablesAsyncCmd
extends AbstractSetVariableAsyncCmd
implements Command<Void> {
    protected String caseInstanceId;
    protected Map<String, Object> variables;

    public SetVariablesAsyncCmd(String caseInstanceId, Map<String, Object> variables) {
        this.caseInstanceId = caseInstanceId;
        this.variables = variables;
    }

    public Void execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("caseInstanceId is null");
        }
        if (this.variables == null) {
            throw new FlowableIllegalArgumentException("variables is null");
        }
        if (this.variables.isEmpty()) {
            throw new FlowableIllegalArgumentException("variables is empty");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(this.caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        for (String variableName : this.variables.keySet()) {
            this.addVariable(false, this.caseInstanceId, null, variableName, this.variables.get(variableName), caseInstanceEntity.getTenantId(), cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService());
        }
        this.createSetAsyncVariablesJob(caseInstanceEntity, cmmnEngineConfiguration);
        return null;
    }
}

