/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.el;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class PlanItemInstancesWrapper {
    protected VariableContainer variableContainer;
    protected CaseInstanceEntity caseInstanceEntity;
    protected List<PlanItemInstanceEntity> planItemInstances;

    public PlanItemInstancesWrapper(VariableContainer variableContainer) {
        this.variableContainer = variableContainer;
        if (variableContainer instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)variableContainer;
            this.caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager().findById(planItemInstanceEntity.getCaseInstanceId());
        } else if (variableContainer instanceof CaseInstanceEntity) {
            this.caseInstanceEntity = (CaseInstanceEntity)variableContainer;
        }
    }

    public PlanItemInstancesWrapper(VariableContainer variableContainer, CaseInstanceEntity caseInstanceEntity, List<PlanItemInstanceEntity> planItemInstances) {
        this.variableContainer = variableContainer;
        this.caseInstanceEntity = caseInstanceEntity;
        this.planItemInstances = planItemInstances;
    }

    public int count() {
        this.ensurePlanItemInstanceInitialized();
        return this.planItemInstances.size();
    }

    public boolean exists() {
        return this.count() > 0;
    }

    protected void ensurePlanItemInstanceInitialized() {
        if (this.planItemInstances == null) {
            this.planItemInstances = this.collectAllChildPlanItemInstances(this.caseInstanceEntity);
        }
    }

    public PlanItemInstancesWrapper definitionId(String ... ids) {
        return this.definitionIds(ids);
    }

    public PlanItemInstancesWrapper definitionIds(String ... ids) {
        this.ensurePlanItemInstanceInitialized();
        List<String> list = Arrays.asList(ids);
        List<PlanItemInstanceEntity> filteredPlanItemInstances = this.planItemInstances.stream().filter(planItemInstanceEntity -> planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null && list.contains(planItemInstanceEntity.getPlanItem().getPlanItemDefinition().getId())).collect(Collectors.toList());
        return new PlanItemInstancesWrapper(this.variableContainer, this.caseInstanceEntity, filteredPlanItemInstances);
    }

    public List<String> getDefinitionId() {
        return this.getDefinitionIds();
    }

    public List<String> getDefinitionIds() {
        this.ensurePlanItemInstanceInitialized();
        return this.planItemInstances.stream().map(planItemInstanceEntity -> planItemInstanceEntity.getPlanItem().getPlanItemDefinition().getId()).collect(Collectors.toList());
    }

    public PlanItemInstancesWrapper name(String ... names) {
        return this.names(names);
    }

    public PlanItemInstancesWrapper names(String ... names) {
        this.ensurePlanItemInstanceInitialized();
        List<String> list = Arrays.asList(names);
        List<PlanItemInstanceEntity> filteredPlanItemInstances = this.planItemInstances.stream().filter(planItemInstanceEntity -> planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null && list.contains(planItemInstanceEntity.getPlanItem().getPlanItemDefinition().getName())).collect(Collectors.toList());
        return new PlanItemInstancesWrapper(this.variableContainer, this.caseInstanceEntity, filteredPlanItemInstances);
    }

    public List<String> getDefinitionName() {
        return this.getDefinitionNames();
    }

    public List<String> getDefinitionNames() {
        this.ensurePlanItemInstanceInitialized();
        return this.planItemInstances.stream().map(planItemInstanceEntity -> planItemInstanceEntity.getPlanItem().getPlanItemDefinition().getName()).collect(Collectors.toList());
    }

    public PlanItemInstancesWrapper currentStage() {
        PlanItemInstanceContainer stageContainer = null;
        if (this.variableContainer instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)this.variableContainer;
            PlanItemInstanceEntity stagePlanItemInstanceEntity = planItemInstanceEntity.getStagePlanItemInstanceEntity();
            stageContainer = stagePlanItemInstanceEntity != null ? stagePlanItemInstanceEntity : (PlanItemInstanceContainer)CommandContextUtil.getCaseInstanceEntityManager().findById(planItemInstanceEntity.getCaseInstanceId());
        } else if (this.variableContainer instanceof CaseInstanceEntity) {
            stageContainer = (CaseInstanceEntity)this.variableContainer;
        }
        List<PlanItemInstanceEntity> childPlanItemInstances = this.collectAllChildPlanItemInstances(stageContainer);
        return new PlanItemInstancesWrapper(this.variableContainer, this.caseInstanceEntity, childPlanItemInstances);
    }

    public PlanItemInstancesWrapper active() {
        return this.getPlanItemInstancesWithState("active");
    }

    public PlanItemInstancesWrapper available() {
        return this.getPlanItemInstancesWithState("available");
    }

    public PlanItemInstancesWrapper enabled() {
        return this.getPlanItemInstancesWithState("enabled");
    }

    public PlanItemInstancesWrapper disabled() {
        return this.getPlanItemInstancesWithState("disabled");
    }

    public PlanItemInstancesWrapper completed() {
        return this.getPlanItemInstancesWithState("completed");
    }

    public PlanItemInstancesWrapper failed() {
        return this.getPlanItemInstancesWithState("failed");
    }

    public PlanItemInstancesWrapper suspended() {
        return this.getPlanItemInstancesWithState("suspended");
    }

    public PlanItemInstancesWrapper terminated() {
        return this.getPlanItemInstancesWithState("terminated");
    }

    public PlanItemInstancesWrapper unavailable() {
        return this.getPlanItemInstancesWithState("unavailable");
    }

    public PlanItemInstancesWrapper waitingForRepetition() {
        return this.getPlanItemInstancesWithState("wait_repetition");
    }

    public PlanItemInstancesWrapper asyncActive() {
        return this.getPlanItemInstancesWithState("async-active");
    }

    public PlanItemInstancesWrapper asyncActiveLeave() {
        return this.getPlanItemInstancesWithState("async-active-leave");
    }

    public PlanItemInstancesWrapper onlyTerminal() {
        this.ensurePlanItemInstanceInitialized();
        List<PlanItemInstanceEntity> filteredPlanItemInstances = this.planItemInstances.stream().filter(planItemInstanceEntity -> planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null && PlanItemInstanceState.isInTerminalState((PlanItemInstance)planItemInstanceEntity)).collect(Collectors.toList());
        return new PlanItemInstancesWrapper(this.variableContainer, this.caseInstanceEntity, filteredPlanItemInstances);
    }

    public PlanItemInstancesWrapper onlyNonTerminal() {
        this.ensurePlanItemInstanceInitialized();
        List<PlanItemInstanceEntity> filteredPlanItemInstances = this.planItemInstances.stream().filter(planItemInstanceEntity -> planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null && !PlanItemInstanceState.isInTerminalState((PlanItemInstance)planItemInstanceEntity)).collect(Collectors.toList());
        return new PlanItemInstancesWrapper(this.variableContainer, this.caseInstanceEntity, filteredPlanItemInstances);
    }

    public List<PlanItemInstanceEntity> getList() {
        this.ensurePlanItemInstanceInitialized();
        return this.planItemInstances;
    }

    protected PlanItemInstancesWrapper getPlanItemInstancesWithState(String state) {
        this.ensurePlanItemInstanceInitialized();
        List<PlanItemInstanceEntity> filteredPlanItemInstances = this.planItemInstances.stream().filter(planItemInstanceEntity -> Objects.equals(state, planItemInstanceEntity.getState())).collect(Collectors.toList());
        return new PlanItemInstancesWrapper(this.variableContainer, this.caseInstanceEntity, filteredPlanItemInstances);
    }

    protected List<PlanItemInstanceEntity> collectAllChildPlanItemInstances(PlanItemInstanceContainer planItemInstanceContainer) {
        ArrayList<PlanItemInstanceEntity> childPlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
        this.collectAllChildPlanItemInstances(CommandContextUtil.getCommandContext(), planItemInstanceContainer, childPlanItemInstances);
        return childPlanItemInstances;
    }

    protected void collectAllChildPlanItemInstances(CommandContext commandContext, PlanItemInstanceContainer planItemInstanceContainer, List<PlanItemInstanceEntity> childPlanItemInstances) {
        List<PlanItemInstanceEntity> planItemInstances = null;
        if (planItemInstanceContainer instanceof CaseInstance) {
            planItemInstances = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findByCaseInstanceId(((CaseInstance)planItemInstanceContainer).getId());
        } else if (planItemInstanceContainer instanceof PlanItemInstance) {
            planItemInstances = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findByStagePlanItemInstanceId(((PlanItemInstance)planItemInstanceContainer).getId());
        } else {
            throw new FlowableException("Programmatic error: unknown variable container type: " + String.valueOf(this.variableContainer));
        }
        for (PlanItemInstanceEntity childPlanItemInstance : planItemInstances) {
            if (!this.contains(childPlanItemInstances, childPlanItemInstance)) {
                childPlanItemInstances.add(childPlanItemInstance);
            }
            if (childPlanItemInstance.getPlanItem() == null || !(childPlanItemInstance.getPlanItem().getPlanItemDefinition() instanceof Stage)) continue;
            this.collectAllChildPlanItemInstances(commandContext, childPlanItemInstance, childPlanItemInstances);
        }
    }

    protected boolean contains(List<PlanItemInstanceEntity> planItemInstances, PlanItemInstanceEntity planItemInstanceEntity) {
        return planItemInstances.stream().anyMatch(p -> Objects.equals(p.getId(), planItemInstanceEntity.getId()));
    }
}

