/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.parser;

import java.util.ArrayList;
import java.util.List;
import org.flowable.cmmn.converter.CmmnXMLException;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.engine.impl.parser.CmmnActivityBehaviorFactory;
import org.flowable.cmmn.engine.impl.parser.CmmnParseContext;
import org.flowable.cmmn.engine.impl.parser.CmmnParseHandlers;
import org.flowable.cmmn.engine.impl.parser.CmmnParseResult;
import org.flowable.cmmn.engine.impl.parser.CmmnParser;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.validation.CaseValidator;
import org.flowable.cmmn.validation.validator.ValidationEntry;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.util.io.BytesStreamSource;
import org.flowable.common.engine.impl.util.io.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnParserImpl
implements CmmnParser {
    private static final Logger logger = LoggerFactory.getLogger(CmmnParserImpl.class);
    protected CmmnParseHandlers cmmnParseHandlers;
    protected CmmnActivityBehaviorFactory activityBehaviorFactory;
    protected ExpressionManager expressionManager;

    @Override
    public CmmnParseResult parse(CmmnParseContext context) {
        EngineResource resourceEntity = context.resource();
        CmmnParseResult cmmnParseResult = this.parse(context, (StreamSource)new BytesStreamSource(resourceEntity.getBytes()));
        this.processDI(cmmnParseResult.getCmmnModel(), cmmnParseResult.getAllCaseDefinitions());
        return cmmnParseResult;
    }

    public CmmnParseResult parse(CmmnParseContext context, StreamSource cmmnSource) {
        try {
            CmmnParseResult cmmnParseResult = new CmmnParseResult();
            cmmnParseResult.setResourceEntity(context.resource());
            CmmnModel cmmnModel = this.convertToCmmnModel(context, cmmnSource);
            cmmnParseResult.setCmmnModel(cmmnModel);
            if (context.validateCmmnModel()) {
                this.validateCmmnModel(context.caseValidator(), cmmnModel);
            }
            this.processCmmnElements(cmmnModel, cmmnParseResult);
            return cmmnParseResult;
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)((Object)e);
            }
            if (e instanceof CmmnXMLException) {
                throw (CmmnXMLException)e;
            }
            throw new FlowableException("Error parsing XML", (Throwable)e);
        }
    }

    protected CmmnModel convertToCmmnModel(CmmnParseContext context, StreamSource cmmnSource) {
        boolean enableSafeBpmnXml = context.enableSafeXml();
        String encoding = context.xmlEncoding();
        boolean validateCmmnXml = context.validateXml();
        return new CmmnXmlConverter().convertToCmmnModel((InputStreamProvider)cmmnSource, validateCmmnXml, enableSafeBpmnXml, encoding);
    }

    protected void validateCmmnModel(CaseValidator caseValidator, CmmnModel cmmnModel) {
        if (caseValidator == null) {
            logger.warn("Case should be validated, but no case validator is configured on the case engine configuration!");
        } else {
            List validationEntries = caseValidator.validate(cmmnModel);
            if (validationEntries != null && !validationEntries.isEmpty()) {
                StringBuilder warningBuilder = new StringBuilder();
                StringBuilder errorBuilder = new StringBuilder();
                for (ValidationEntry entry : validationEntries) {
                    if (entry.getLevel() == ValidationEntry.Level.Warning) {
                        warningBuilder.append(entry).append("\n");
                        continue;
                    }
                    errorBuilder.append(entry).append("\n");
                }
                if (errorBuilder.length() > 0) {
                    throw new FlowableException("Errors while parsing:\n" + String.valueOf(errorBuilder));
                }
                if (warningBuilder.length() > 0) {
                    logger.warn("Following warnings encountered during case validation: {}", (Object)warningBuilder);
                }
            }
        }
    }

    public void processCmmnElements(CmmnModel cmmnModel, CmmnParseResult parseResult) {
        for (Case caze : cmmnModel.getCases()) {
            this.cmmnParseHandlers.parseElement(this, parseResult, (BaseElement)caze);
        }
    }

    public void processDI(CmmnModel cmmnModel, List<CaseDefinitionEntity> caseDefinitions) {
        if (caseDefinitions.isEmpty()) {
            return;
        }
        if (!cmmnModel.getLocationMap().isEmpty()) {
            ArrayList<String> planModelIds = new ArrayList<String>();
            for (Case caseObject : cmmnModel.getCases()) {
                planModelIds.add(caseObject.getPlanModel().getId());
            }
            for (String cmmnReference : cmmnModel.getLocationMap().keySet()) {
                if (planModelIds.contains(cmmnReference) || cmmnModel.findPlanItem(cmmnReference) != null || cmmnModel.getCriterion(cmmnReference) != null || cmmnModel.findTextAnnotation(cmmnReference) != null) continue;
                logger.warn("Invalid reference in diagram interchange definition: could not find {}", (Object)cmmnReference);
            }
            for (Case caseObject : cmmnModel.getCases()) {
                CaseDefinitionEntity caseDefinition = this.getCaseDefinition(caseObject.getId(), caseDefinitions);
                if (caseDefinition == null) continue;
                caseDefinition.setHasGraphicalNotation(true);
            }
        }
    }

    public CaseDefinitionEntity getCaseDefinition(String caseDefinitionKey, List<CaseDefinitionEntity> caseDefinitions) {
        for (CaseDefinitionEntity caseDefinition : caseDefinitions) {
            if (!caseDefinition.getKey().equals(caseDefinitionKey)) continue;
            return caseDefinition;
        }
        return null;
    }

    public CmmnParseHandlers getCmmnParseHandlers() {
        return this.cmmnParseHandlers;
    }

    public void setCmmnParseHandlers(CmmnParseHandlers cmmnParseHandlers) {
        this.cmmnParseHandlers = cmmnParseHandlers;
    }

    public CmmnActivityBehaviorFactory getActivityBehaviorFactory() {
        return this.activityBehaviorFactory;
    }

    public void setActivityBehaviorFactory(CmmnActivityBehaviorFactory activityBehaviorFactory) {
        this.activityBehaviorFactory = activityBehaviorFactory;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

