/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.parser.handler;

import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.parser.CmmnActivityBehaviorFactory;
import org.flowable.cmmn.engine.impl.parser.CmmnParseResult;
import org.flowable.cmmn.engine.impl.parser.CmmnParserImpl;
import org.flowable.cmmn.engine.impl.parser.handler.AbstractPlanItemParseHandler;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.SendEventServiceTask;
import org.flowable.cmmn.model.ServiceTask;

public abstract class AbstractServiceTaskParseHandler<T extends ServiceTask>
extends AbstractPlanItemParseHandler<T> {
    @Override
    protected void executePlanItemParse(CmmnParserImpl cmmnParser, CmmnParseResult cmmnParseResult, PlanItem planItem, ServiceTask serviceTask) {
        CmmnActivityBehaviorFactory activityBehaviorFactory = cmmnParser.getActivityBehaviorFactory();
        switch (serviceTask.getType()) {
            case "http": {
                planItem.setBehavior((Object)activityBehaviorFactory.createHttpActivityBehavior(planItem, serviceTask));
                break;
            }
            case "mail": {
                planItem.setBehavior((Object)activityBehaviorFactory.createEmailActivityBehavior(planItem, serviceTask));
                break;
            }
            case "send-event": {
                planItem.setBehavior((Object)activityBehaviorFactory.createSendEventActivityBehavior(planItem, (SendEventServiceTask)serviceTask));
                break;
            }
            default: {
                if (!StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) break;
                if ("class".equals(serviceTask.getImplementationType())) {
                    planItem.setBehavior((Object)activityBehaviorFactory.createCmmnClassDelegate(planItem, serviceTask));
                    break;
                }
                if ("expression".equals(serviceTask.getImplementationType())) {
                    planItem.setBehavior((Object)activityBehaviorFactory.createPlanItemExpressionActivityBehavior(planItem, serviceTask));
                    break;
                }
                if (!"delegateExpression".equals(serviceTask.getImplementationType())) break;
                planItem.setBehavior((Object)activityBehaviorFactory.createPlanItemDelegateExpressionActivityBehavior(planItem, serviceTask));
            }
        }
    }
}

