/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.ReadOnlyDelegatePlanItemInstance;
import org.flowable.cmmn.api.history.HistoricPlanItemInstance;
import org.flowable.cmmn.api.listener.PlanItemInstanceLifecycleListener;
import org.flowable.cmmn.engine.impl.delegate.ReadOnlyDelegatePlanItemInstanceImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.AbstractCmmnEngineVariableScopeEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CountingPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInitializingList;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableScopeImpl;

public class PlanItemInstanceEntityImpl
extends AbstractCmmnEngineVariableScopeEntity
implements PlanItemInstanceEntity,
CountingPlanItemInstanceEntity {
    protected String caseDefinitionId;
    protected String derivedCaseDefinitionId;
    protected String caseInstanceId;
    protected String stageInstanceId;
    protected boolean isStage;
    protected String elementId;
    protected String planItemDefinitionId;
    protected String planItemDefinitionType;
    protected String name;
    protected String state;
    protected Date createTime;
    protected Date lastAvailableTime;
    protected Date lastUnavailableTime;
    protected Date lastEnabledTime;
    protected Date lastDisabledTime;
    protected Date lastStartedTime;
    protected Date lastSuspendedTime;
    protected Date completedTime;
    protected Date occurredTime;
    protected Date terminatedTime;
    protected Date exitTime;
    protected Date endedTime;
    protected String startUserId;
    protected String assignee;
    protected String completedBy;
    protected String referenceId;
    protected String referenceType;
    protected boolean completable;
    protected String entryCriterionId;
    protected String exitCriterionId;
    protected String extraValue;
    protected String tenantId = "";
    protected List<VariableInstanceEntity> queryVariables;
    protected boolean countEnabled;
    protected int variableCount;
    protected int sentryPartInstanceCount;
    protected PlanItem planItem;
    protected List<PlanItemInstanceEntity> childPlanItemInstances;
    protected PlanItemInstanceEntity stagePlanItemInstance;
    protected List<SentryPartInstanceEntity> satisfiedSentryPartInstances;
    protected String localizedName;
    protected PlanItemInstanceLifecycleListener currentLifecycleListener;
    protected FlowableListener currentFlowableListener;
    protected boolean plannedForActivationInMigration;
    protected boolean stateChangeUnprocessed;

    public PlanItemInstanceEntityImpl() {
    }

    public PlanItemInstanceEntityImpl(HistoricPlanItemInstance historicPlanItemInstance) {
        this.setId(historicPlanItemInstance.getId());
        this.setName(historicPlanItemInstance.getName());
        this.setState(historicPlanItemInstance.getState());
        this.setCaseDefinitionId(historicPlanItemInstance.getCaseDefinitionId());
        this.setDerivedCaseDefinitionId(historicPlanItemInstance.getDerivedCaseDefinitionId());
        this.setCaseInstanceId(historicPlanItemInstance.getCaseInstanceId());
        this.setStageInstanceId(historicPlanItemInstance.getStageInstanceId());
        this.setStage(historicPlanItemInstance.isStage());
        this.setElementId(historicPlanItemInstance.getElementId());
        this.setPlanItemDefinitionId(historicPlanItemInstance.getPlanItemDefinitionId());
        this.setPlanItemDefinitionType(historicPlanItemInstance.getPlanItemDefinitionType());
        this.setCreateTime(historicPlanItemInstance.getCreateTime());
        this.setLastAvailableTime(historicPlanItemInstance.getLastAvailableTime());
        this.setLastUnavailableTime(historicPlanItemInstance.getLastUnavailableTime());
        this.setLastEnabledTime(historicPlanItemInstance.getLastEnabledTime());
        this.setLastDisabledTime(historicPlanItemInstance.getLastDisabledTime());
        this.setLastStartedTime(historicPlanItemInstance.getLastStartedTime());
        this.setLastSuspendedTime(historicPlanItemInstance.getLastSuspendedTime());
        this.setCompletedTime(historicPlanItemInstance.getCompletedTime());
        this.setOccurredTime(historicPlanItemInstance.getOccurredTime());
        this.setTerminatedTime(historicPlanItemInstance.getTerminatedTime());
        this.setExitTime(historicPlanItemInstance.getExitTime());
        this.setEndedTime(historicPlanItemInstance.getEndedTime());
        this.setStartUserId(historicPlanItemInstance.getStartUserId());
        this.setAssignee(historicPlanItemInstance.getAssignee());
        this.setCompletedBy(historicPlanItemInstance.getCompletedBy());
        this.setReferenceId(historicPlanItemInstance.getReferenceId());
        this.setReferenceType(historicPlanItemInstance.getReferenceType());
        this.setEntryCriterionId(historicPlanItemInstance.getEntryCriterionId());
        this.setExitCriterionId(historicPlanItemInstance.getExitCriterionId());
        this.setFormKey(historicPlanItemInstance.getFormKey());
        this.setExtraValue(historicPlanItemInstance.getExtraValue());
        this.setTenantId(historicPlanItemInstance.getTenantId());
    }

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("caseDefinitionId", this.caseDefinitionId);
        persistentState.put("derivedCaseDefinitionId", this.derivedCaseDefinitionId);
        persistentState.put("caseInstanceId", this.caseInstanceId);
        persistentState.put("stageInstanceId", this.stageInstanceId);
        persistentState.put("isStage", this.isStage);
        persistentState.put("elementId", this.elementId);
        persistentState.put("planItemDefinitionId", this.planItemDefinitionId);
        persistentState.put("planItemDefinitionType", this.planItemDefinitionType);
        persistentState.put("name", this.name);
        persistentState.put("state", this.state);
        persistentState.put("createTime", this.createTime);
        persistentState.put("lastAvailableTime", this.lastAvailableTime);
        persistentState.put("lastUnavailableTime", this.lastUnavailableTime);
        persistentState.put("lastEnabledTime", this.lastEnabledTime);
        persistentState.put("lastDisabledTime", this.lastDisabledTime);
        persistentState.put("lastStartedTime", this.lastStartedTime);
        persistentState.put("lastSuspendedTime", this.lastSuspendedTime);
        persistentState.put("completedTime", this.completedTime);
        persistentState.put("occurredTime", this.occurredTime);
        persistentState.put("terminatedTime", this.terminatedTime);
        persistentState.put("exitTime", this.exitTime);
        persistentState.put("endedTime", this.endedTime);
        persistentState.put("startUserId", this.startUserId);
        persistentState.put("assignee", this.assignee);
        persistentState.put("completedBy", this.completedBy);
        persistentState.put("referenceId", this.referenceId);
        persistentState.put("referenceType", this.referenceType);
        persistentState.put("completable", this.completable);
        persistentState.put("entryCriterionId", this.entryCriterionId);
        persistentState.put("exitCriterionId", this.exitCriterionId);
        persistentState.put("extraValue", this.extraValue);
        persistentState.put("countEnabled", this.countEnabled);
        persistentState.put("variableCount", this.variableCount);
        persistentState.put("sentryPartInstanceCount", this.sentryPartInstanceCount);
        persistentState.put("tenantId", this.tenantId);
        return persistentState;
    }

    public ReadOnlyDelegatePlanItemInstance snapshotReadOnly() {
        return new ReadOnlyDelegatePlanItemInstanceImpl(this);
    }

    public PlanItem getPlanItem() {
        if (this.planItem == null) {
            Case caze = this.derivedCaseDefinitionId != null ? CaseDefinitionUtil.getCase(this.derivedCaseDefinitionId) : CaseDefinitionUtil.getCase(this.caseDefinitionId);
            this.planItem = (PlanItem)caze.getAllCaseElements().get(this.elementId);
        }
        return this.planItem;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public String getDerivedCaseDefinitionId() {
        return this.derivedCaseDefinitionId;
    }

    public void setDerivedCaseDefinitionId(String derivedCaseDefinitionId) {
        this.derivedCaseDefinitionId = derivedCaseDefinitionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public String getStageInstanceId() {
        return this.stageInstanceId;
    }

    public void setStageInstanceId(String stageInstanceId) {
        this.stageInstanceId = stageInstanceId;
    }

    public boolean isStage() {
        return this.isStage;
    }

    public void setStage(boolean isStage) {
        this.isStage = isStage;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getPlanItemDefinitionId() {
        return this.planItemDefinitionId;
    }

    public void setPlanItemDefinitionId(String planItemDefinitionId) {
        this.planItemDefinitionId = planItemDefinitionId;
    }

    public String getPlanItemDefinitionType() {
        return this.planItemDefinitionType;
    }

    public void setPlanItemDefinitionType(String planItemDefinitionType) {
        this.planItemDefinitionType = planItemDefinitionType;
    }

    public String getName() {
        if (StringUtils.isNotBlank((CharSequence)this.localizedName)) {
            return this.localizedName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getStartTime() {
        return this.getCreateTime();
    }

    public void setStartTime(Date startTime) {
        this.setCreateTime(startTime);
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastAvailableTime() {
        return this.lastAvailableTime;
    }

    public void setLastAvailableTime(Date lastAvailableTime) {
        this.lastAvailableTime = lastAvailableTime;
    }

    public Date getLastUnavailableTime() {
        return this.lastUnavailableTime;
    }

    public void setLastUnavailableTime(Date lastUnavailableTime) {
        this.lastUnavailableTime = lastUnavailableTime;
    }

    public Date getLastEnabledTime() {
        return this.lastEnabledTime;
    }

    public void setLastEnabledTime(Date lastEnabledTime) {
        this.lastEnabledTime = lastEnabledTime;
    }

    public Date getLastDisabledTime() {
        return this.lastDisabledTime;
    }

    public void setLastDisabledTime(Date lastDisabledTime) {
        this.lastDisabledTime = lastDisabledTime;
    }

    public Date getLastStartedTime() {
        return this.lastStartedTime;
    }

    public void setLastStartedTime(Date lastStartedTime) {
        this.lastStartedTime = lastStartedTime;
    }

    public Date getLastSuspendedTime() {
        return this.lastSuspendedTime;
    }

    public void setLastSuspendedTime(Date lastSuspendedTime) {
        this.lastSuspendedTime = lastSuspendedTime;
    }

    public Date getCompletedTime() {
        return this.completedTime;
    }

    public void setCompletedTime(Date completedTime) {
        this.completedTime = completedTime;
    }

    public Date getOccurredTime() {
        return this.occurredTime;
    }

    public void setOccurredTime(Date occurredTime) {
        this.occurredTime = occurredTime;
    }

    public Date getTerminatedTime() {
        return this.terminatedTime;
    }

    public void setTerminatedTime(Date terminatedTime) {
        this.terminatedTime = terminatedTime;
    }

    public Date getExitTime() {
        return this.exitTime;
    }

    public void setExitTime(Date exitTime) {
        this.exitTime = exitTime;
    }

    public Date getEndedTime() {
        return this.endedTime;
    }

    public void setEndedTime(Date endedTime) {
        this.endedTime = endedTime;
    }

    public void setPlanItem(PlanItem planItem) {
        this.planItem = planItem;
    }

    public PlanItemInstanceEntity getStagePlanItemInstance() {
        return this.stagePlanItemInstance;
    }

    public void setStagePlanItemInstance(PlanItemInstanceEntity stagePlanItemInstance) {
        this.stagePlanItemInstance = stagePlanItemInstance;
    }

    public String getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    public String getCompletedBy() {
        return this.completedBy;
    }

    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    public boolean isCompletable() {
        return this.completable;
    }

    public void setCompletable(boolean completable) {
        this.completable = completable;
    }

    public String getEntryCriterionId() {
        return this.entryCriterionId;
    }

    public void setEntryCriterionId(String entryCriterionId) {
        this.entryCriterionId = entryCriterionId;
    }

    public String getExitCriterionId() {
        return this.exitCriterionId;
    }

    public void setExitCriterionId(String exitCriterionId) {
        this.exitCriterionId = exitCriterionId;
    }

    public String getFormKey() {
        return this.extraValue;
    }

    public void setFormKey(String formKey) {
        this.extraValue = formKey;
    }

    public String getExtraValue() {
        return this.extraValue;
    }

    public void setExtraValue(String extraValue) {
        this.extraValue = extraValue;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public void setChildPlanItemInstances(List<PlanItemInstanceEntity> childPlanItemInstances) {
        this.childPlanItemInstances = childPlanItemInstances;
    }

    @Override
    public List<PlanItem> getPlanItems() {
        PlanItem planItem = this.getPlanItem();
        if (planItem != null && planItem.getPlanItemDefinition() instanceof PlanFragment) {
            return ((PlanFragment)planItem.getPlanItemDefinition()).getPlanItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<PlanItemInstanceEntity> getChildPlanItemInstances() {
        if (this.childPlanItemInstances == null && this.id != null) {
            this.childPlanItemInstances = CommandContextUtil.getPlanItemInstanceEntityManager().findByStagePlanItemInstanceId(this.id);
        }
        return this.childPlanItemInstances;
    }

    @Override
    public PlanItemInstanceEntity getStagePlanItemInstanceEntity() {
        if (this.stagePlanItemInstance == null && this.stageInstanceId != null) {
            this.stagePlanItemInstance = (PlanItemInstanceEntity)CommandContextUtil.getPlanItemInstanceEntityManager().findById(this.stageInstanceId);
        }
        return this.stagePlanItemInstance;
    }

    @Override
    public List<SentryPartInstanceEntity> getSatisfiedSentryPartInstances() {
        if (this.satisfiedSentryPartInstances == null) {
            this.satisfiedSentryPartInstances = this.sentryPartInstanceCount == 0 ? new ArrayList<SentryPartInstanceEntity>(1) : CommandContextUtil.getSentryPartInstanceEntityManager().findSentryPartInstancesByPlanItemInstanceId(this.id);
        }
        return this.satisfiedSentryPartInstances;
    }

    @Override
    public void setSatisfiedSentryPartInstances(List<SentryPartInstanceEntity> satisfiedSentryPartInstances) {
        this.satisfiedSentryPartInstances = satisfiedSentryPartInstances;
    }

    protected Collection<VariableInstanceEntity> loadVariableInstances() {
        return this.getVariableServiceConfiguration().getVariableService().findVariableInstanceBySubScopeIdAndScopeType(this.id, "cmmn");
    }

    public VariableScopeImpl getParentVariableScope() {
        PlanItemInstanceEntity stagePlanItem = this.getStagePlanItemInstanceEntity();
        if (stagePlanItem != null) {
            return (VariableScopeImpl)stagePlanItem;
        }
        if (this.caseInstanceId != null) {
            return (VariableScopeImpl)CommandContextUtil.getCaseInstanceEntityManager().findById(this.caseInstanceId);
        }
        return null;
    }

    protected void initializeVariableInstanceBackPointer(VariableInstance variableInstance) {
        variableInstance.setScopeId(this.caseInstanceId);
        variableInstance.setSubScopeId(this.id);
        variableInstance.setScopeType("cmmn");
        variableInstance.setScopeDefinitionId(this.caseDefinitionId);
    }

    protected boolean storeVariableLocal(String variableName) {
        if (super.storeVariableLocal(variableName)) {
            return true;
        }
        RepetitionRule repetitionRule = ExpressionUtil.getRepetitionRule(this);
        return repetitionRule != null && repetitionRule.getAggregations() != null;
    }

    protected void addLoggingSessionInfo(ObjectNode loggingNode) {
    }

    protected void createVariableLocal(String variableName, Object value) {
        super.createVariableLocal(variableName, value);
        this.setVariableCount(this.variableCount + 1);
    }

    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        return this.getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().subScopeId(this.id).scopeType("cmmn").name(variableName).singleResult();
    }

    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        return this.getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().subScopeId(this.id).scopeType("cmmn").names(variableNames).list();
    }

    protected boolean isPropagateToHistoricVariable() {
        return true;
    }

    protected VariableServiceConfiguration getVariableServiceConfiguration() {
        return CommandContextUtil.getCmmnEngineConfiguration().getVariableServiceConfiguration();
    }

    @Override
    public boolean isCountEnabled() {
        return this.countEnabled;
    }

    @Override
    public void setCountEnabled(boolean countEnabled) {
        this.countEnabled = countEnabled;
    }

    @Override
    public int getVariableCount() {
        return this.variableCount;
    }

    @Override
    public void setVariableCount(int variableCount) {
        this.variableCount = variableCount;
    }

    @Override
    public int getSentryPartInstanceCount() {
        return this.sentryPartInstanceCount;
    }

    @Override
    public void setSentryPartInstanceCount(int sentryPartInstanceCount) {
        this.sentryPartInstanceCount = sentryPartInstanceCount;
    }

    public FlowableListener getCurrentFlowableListener() {
        return this.currentFlowableListener;
    }

    public PlanItemInstanceLifecycleListener getCurrentLifecycleListener() {
        return this.currentLifecycleListener;
    }

    public void setCurrentLifecycleListener(PlanItemInstanceLifecycleListener lifecycleListener, FlowableListener flowableListener) {
        this.currentLifecycleListener = lifecycleListener;
        this.currentFlowableListener = flowableListener;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    @Override
    public boolean isPlannedForActivationInMigration() {
        return this.plannedForActivationInMigration;
    }

    @Override
    public void setPlannedForActivationInMigration(boolean plannedForActivationInMigration) {
        this.plannedForActivationInMigration = plannedForActivationInMigration;
    }

    @Override
    public boolean isStateChangeUnprocessed() {
        return this.stateChangeUnprocessed;
    }

    @Override
    public void setStateChangeUnprocessed(boolean stateChangeUnprocessed) {
        this.stateChangeUnprocessed = stateChangeUnprocessed;
    }

    public Map<String, Object> getPlanItemInstanceLocalVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstance variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getSubScopeId() == null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public List<VariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new VariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PlanItemInstance with id: ").append(this.id);
        if (this.getName() != null) {
            stringBuilder.append(", name: ").append(this.getName());
        }
        stringBuilder.append(", definitionId: ").append(this.planItemDefinitionId).append(", state: ").append(this.state);
        if (this.elementId != null) {
            stringBuilder.append(", elementId: ").append(this.elementId);
        }
        stringBuilder.append(", caseInstanceId: ").append(this.caseInstanceId).append(", caseDefinitionId: ").append(this.caseDefinitionId);
        if (StringUtils.isNotEmpty((CharSequence)this.tenantId)) {
            stringBuilder.append(", tenantId=").append(this.tenantId);
        }
        return stringBuilder.toString();
    }
}

