/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.test;

import java.util.Optional;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.CmmnEngines;
import org.flowable.cmmn.engine.impl.test.InternalFlowableCmmnExtension;
import org.flowable.cmmn.engine.test.CmmnConfigurationResource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class PluggableFlowableCmmnExtension
extends InternalFlowableCmmnExtension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{PluggableFlowableCmmnExtension.class});

    @Override
    protected CmmnEngine getCmmnEngine(ExtensionContext context) {
        String configurationResource = this.getConfigurationResource(context);
        return (CmmnEngine)this.getStore(context).getOrComputeIfAbsent((Object)configurationResource, this::initializeCmmnEngine, CmmnEngine.class);
    }

    protected CmmnEngine initializeCmmnEngine(String configurationResource) {
        CmmnEngine previousEngine;
        this.logger.info("No cached cmmn engine found for test. Retrieving engine from {}.", (Object)configurationResource);
        CmmnEngineConfiguration engineConfiguration = CmmnEngineConfiguration.createCmmnEngineConfigurationFromResource(configurationResource);
        if (CmmnEngines.isInitialized() && (previousEngine = CmmnEngines.getCmmnEngine(engineConfiguration.getEngineName())) != null) {
            CmmnEngines.unregister(previousEngine);
            previousEngine.close();
        }
        CmmnEngine cmmnEngine = (CmmnEngine)engineConfiguration.buildEngine();
        CmmnEngines.setInitialized(true);
        return cmmnEngine;
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), CmmnConfigurationResource.class).map(CmmnConfigurationResource::value).orElse("flowable.cmmn.cfg.xml");
    }

    @Override
    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

