/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.constants.CmmnStencilConstants;
import org.flowable.cmmn.editor.constants.EditorJsonConstants;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.CriterionJsonConverter;
import org.flowable.cmmn.editor.json.converter.util.CollectionUtils;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.CompletionNeutralRule;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.ManualActivationRule;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.cmmn.model.RequiredRule;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCmmnJsonConverter
implements EditorJsonConstants,
CmmnStencilConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseCmmnJsonConverter.class);
    public static final String NAMESPACE = "http://flowable.org/modeler";
    protected ObjectMapper objectMapper = new ObjectMapper();

    public void convertToJson(BaseElement baseElement, ActivityProcessor processor, CmmnModel model, PlanFragment planFragment, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        if (!(baseElement instanceof PlanItem)) {
            return;
        }
        PlanItem planItem = (PlanItem)baseElement;
        PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
        GraphicInfo graphicInfo = model.getGraphicInfo(planItem.getId());
        String stencilId = this.getStencilId(baseElement);
        ObjectNode planItemNode = CmmnJsonConverterUtil.createChildShape(baseElement.getId(), stencilId, graphicInfo.getX() - subProcessX + graphicInfo.getWidth(), graphicInfo.getY() - subProcessY + graphicInfo.getHeight(), graphicInfo.getX() - subProcessX, graphicInfo.getY() - subProcessY);
        shapesArrayNode.add((JsonNode)planItemNode);
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", planItemDefinition.getId());
        if (StringUtils.isNotEmpty((CharSequence)planItemDefinition.getName())) {
            propertiesNode.put("name", planItemDefinition.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)planItemDefinition.getDocumentation())) {
            propertiesNode.put("documentation", planItemDefinition.getDocumentation());
        }
        if (planItemDefinition instanceof Task) {
            Task task = (Task)planItemDefinition;
            if (task.isAsync()) {
                propertiesNode.put("isasync", task.isAsync());
            }
            if (task.isExclusive()) {
                propertiesNode.put("isexclusive", task.isExclusive());
            }
        } else if (planItemDefinition instanceof Stage) {
            Stage stage = (Stage)planItemDefinition;
            if (stage.isAutoComplete()) {
                propertiesNode.put("autocompleteenabled", stage.isAutoComplete());
            }
            if (StringUtils.isNotEmpty((CharSequence)stage.getAutoCompleteCondition())) {
                propertiesNode.put("autocompletecondition", stage.getAutoCompleteCondition());
            }
        }
        if (planItem.getItemControl() != null) {
            this.convertPlanItemControlToJson(planItem, propertiesNode);
        }
        this.convertElementToJson(planItemNode, propertiesNode, processor, baseElement, model);
        planItemNode.set("properties", (JsonNode)propertiesNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        if (CollectionUtils.isNotEmpty(planItem.getEntryCriteria())) {
            this.convertCriteria(planItem.getEntryCriteria(), model, processor, shapesArrayNode, outgoingArrayNode, subProcessX, subProcessY);
        }
        if (CollectionUtils.isNotEmpty(planItem.getExitCriteria())) {
            this.convertCriteria(planItem.getExitCriteria(), model, processor, shapesArrayNode, outgoingArrayNode, subProcessX, subProcessY);
        }
        if (CollectionUtils.isNotEmpty(planItem.getOutgoingAssociations())) {
            for (Association association : planItem.getOutgoingAssociations()) {
                outgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(association.getId()));
            }
        }
        planItemNode.set("outgoing", (JsonNode)outgoingArrayNode);
    }

    protected void convertPlanItemControlToJson(PlanItem planItem, ObjectNode propertiesNode) {
        CompletionNeutralRule completionNeutralRule;
        RequiredRule requiredRule;
        ManualActivationRule manualActivationRule;
        RepetitionRule repetitionRule = planItem.getItemControl().getRepetitionRule();
        if (repetitionRule != null) {
            propertiesNode.put("repetitionenabled", true);
            if (StringUtils.isNotEmpty((CharSequence)repetitionRule.getCondition())) {
                propertiesNode.put("repetitionrulecondition", repetitionRule.getCondition());
            }
            if (!RepetitionRule.DEFAULT_REPETITION_COUNTER_VARIABLE_NAME.equals(repetitionRule.getRepetitionCounterVariableName())) {
                propertiesNode.put("repetitioncountervariablename", repetitionRule.getRepetitionCounterVariableName());
            }
        }
        if ((manualActivationRule = planItem.getItemControl().getManualActivationRule()) != null) {
            propertiesNode.put("manualactivationenabled", true);
            if (StringUtils.isNotEmpty((CharSequence)manualActivationRule.getCondition())) {
                propertiesNode.put("manualactivationrulecondition", manualActivationRule.getCondition());
            }
        }
        if ((requiredRule = planItem.getItemControl().getRequiredRule()) != null) {
            propertiesNode.put("requiredenabled", true);
            if (StringUtils.isNotEmpty((CharSequence)requiredRule.getCondition())) {
                propertiesNode.put("requiredrulecondition", requiredRule.getCondition());
            }
        }
        if ((completionNeutralRule = planItem.getItemControl().getCompletionNeutralRule()) != null) {
            propertiesNode.put("completionneutralenabled", true);
            if (StringUtils.isNotEmpty((CharSequence)completionNeutralRule.getCondition())) {
                propertiesNode.put("completionneutralrulecondition", completionNeutralRule.getCondition());
            }
        }
    }

    public void convertToCmmnModel(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        BaseElement baseElement = this.convertJsonToElement(elementNode, modelNode, processor, parentElement, shapeMap, cmmnModel, cmmnModelIdHelper);
        baseElement.setId(CmmnJsonConverterUtil.getElementId(elementNode));
        if (baseElement instanceof PlanItemDefinition) {
            PlanItemDefinition planItemDefinition = (PlanItemDefinition)baseElement;
            planItemDefinition.setName(CmmnJsonConverterUtil.getPropertyValueAsString("name", elementNode));
            planItemDefinition.setDocumentation(CmmnJsonConverterUtil.getPropertyValueAsString("documentation", elementNode));
            if (planItemDefinition instanceof Task) {
                this.handleTaskProperties(elementNode, planItemDefinition);
            }
            Stage stage = (Stage)parentElement;
            stage.addPlanItemDefinition(planItemDefinition);
            PlanItem planItem = new PlanItem();
            planItem.setId("planItem" + cmmnModelIdHelper.nextPlanItemId());
            planItem.setName(planItemDefinition.getName());
            planItem.setPlanItemDefinition(planItemDefinition);
            planItem.setDefinitionRef(planItemDefinition.getId());
            ArrayNode outgoingNode = (ArrayNode)elementNode.get("outgoing");
            if (outgoingNode != null && outgoingNode.size() > 0) {
                for (JsonNode outgoingChildNode : outgoingNode) {
                    JsonNode resourceNode = outgoingChildNode.get("resourceId");
                    if (resourceNode == null) continue;
                    String criterionRefId = resourceNode.asText();
                    planItem.addCriteriaRef(criterionRefId);
                }
            }
            this.handleRequiredRule(elementNode, planItem);
            this.handleRepetitionRule(elementNode, planItem);
            this.handleManualActivationRule(elementNode, planItem);
            this.handleCompletionNeutralRule(elementNode, planItem);
            planItemDefinition.setPlanItemRef(planItem.getId());
            stage.addPlanItem(planItem);
            planItem.setParent((PlanFragment)stage);
        }
    }

    protected void handleTaskProperties(JsonNode elementNode, PlanItemDefinition planItemDefinition) {
        Task task = (Task)planItemDefinition;
        task.setBlocking(CmmnJsonConverterUtil.getPropertyValueAsBoolean("isblocking", elementNode));
        task.setBlockingExpression(CmmnJsonConverterUtil.getPropertyValueAsString("isblockingexpression", elementNode));
        task.setAsync(CmmnJsonConverterUtil.getPropertyValueAsBoolean("isasync", elementNode));
        task.setExclusive(CmmnJsonConverterUtil.getPropertyValueAsBoolean("isexclusive", elementNode));
    }

    protected void handleRequiredRule(JsonNode elementNode, PlanItem planItem) {
        boolean isRequired = CmmnJsonConverterUtil.getPropertyValueAsBoolean("requiredenabled", elementNode);
        String requiredCondition = CmmnJsonConverterUtil.getPropertyValueAsString("requiredrulecondition", elementNode);
        if (isRequired || StringUtils.isNotEmpty((CharSequence)requiredCondition)) {
            RequiredRule requiredRule = new RequiredRule();
            if (StringUtils.isNotEmpty((CharSequence)requiredCondition)) {
                requiredRule.setCondition(requiredCondition);
            }
            if (planItem.getItemControl() == null) {
                planItem.setItemControl(new PlanItemControl());
            }
            planItem.getItemControl().setRequiredRule(requiredRule);
        }
    }

    protected void handleRepetitionRule(JsonNode elementNode, PlanItem planItem) {
        boolean repetitionEnabled = CmmnJsonConverterUtil.getPropertyValueAsBoolean("repetitionenabled", elementNode);
        String repetitionCondition = CmmnJsonConverterUtil.getPropertyValueAsString("repetitionrulecondition", elementNode);
        if (repetitionEnabled || StringUtils.isNotEmpty((CharSequence)repetitionCondition)) {
            String repetitionCounterVariableName;
            RepetitionRule repetitionRule = new RepetitionRule();
            if (StringUtils.isNotEmpty((CharSequence)repetitionCondition)) {
                repetitionRule.setCondition(repetitionCondition);
            }
            if (StringUtils.isNotEmpty((CharSequence)(repetitionCounterVariableName = CmmnJsonConverterUtil.getPropertyValueAsString("repetitioncountervariablename", elementNode)))) {
                repetitionRule.setRepetitionCounterVariableName(repetitionCounterVariableName);
            }
            if (planItem.getItemControl() == null) {
                planItem.setItemControl(new PlanItemControl());
            }
            planItem.getItemControl().setRepetitionRule(repetitionRule);
        }
    }

    protected void handleManualActivationRule(JsonNode elementNode, PlanItem planItem) {
        boolean manualActivationEnabled = CmmnJsonConverterUtil.getPropertyValueAsBoolean("manualactivationenabled", elementNode);
        String manualActivationCondition = CmmnJsonConverterUtil.getPropertyValueAsString("manualactivationrulecondition", elementNode);
        if (manualActivationEnabled || StringUtils.isNotEmpty((CharSequence)manualActivationCondition)) {
            ManualActivationRule manualActivationRule = new ManualActivationRule();
            if (StringUtils.isNotEmpty((CharSequence)manualActivationCondition)) {
                manualActivationRule.setCondition(manualActivationCondition);
            }
            if (planItem.getItemControl() == null) {
                planItem.setItemControl(new PlanItemControl());
            }
            planItem.getItemControl().setManualActivationRule(manualActivationRule);
        }
    }

    protected void handleCompletionNeutralRule(JsonNode elementNode, PlanItem planItem) {
        boolean completionNeutralEnabled = CmmnJsonConverterUtil.getPropertyValueAsBoolean("completionneutralenabled", elementNode);
        String completionNeutralCondition = CmmnJsonConverterUtil.getPropertyValueAsString("completionneutralrulecondition", elementNode);
        if (completionNeutralEnabled || StringUtils.isNotEmpty((CharSequence)completionNeutralCondition)) {
            CompletionNeutralRule completionNeutralRule = new CompletionNeutralRule();
            if (StringUtils.isNotEmpty((CharSequence)completionNeutralCondition)) {
                completionNeutralRule.setCondition(completionNeutralCondition);
            }
            if (planItem.getItemControl() == null) {
                planItem.setItemControl(new PlanItemControl());
            }
            planItem.getItemControl().setCompletionNeutralRule(completionNeutralRule);
        }
    }

    protected abstract void convertElementToJson(ObjectNode var1, ObjectNode var2, ActivityProcessor var3, BaseElement var4, CmmnModel var5);

    protected abstract BaseElement convertJsonToElement(JsonNode var1, JsonNode var2, ActivityProcessor var3, BaseElement var4, Map<String, JsonNode> var5, CmmnModel var6, CmmnJsonConverter.CmmnModelIdHelper var7);

    protected abstract String getStencilId(BaseElement var1);

    protected void convertCriteria(List<Criterion> criteria, CmmnModel model, ActivityProcessor processor, ArrayNode shapesArrayNode, ArrayNode outgoingArrayNode, double subProcessX, double subProcessY) {
        for (Criterion criterion : criteria) {
            GraphicInfo criterionGraphicInfo = model.getGraphicInfo(criterion.getId());
            ObjectNode criterionNode = CmmnJsonConverterUtil.createChildShape(criterion.getId(), criterion.isEntryCriterion() ? STENCIL_ENTRY_CRITERION : STENCIL_EXIT_CRITERION, criterionGraphicInfo.getX() - subProcessX + criterionGraphicInfo.getWidth(), criterionGraphicInfo.getY() - subProcessY + criterionGraphicInfo.getHeight(), criterionGraphicInfo.getX() - subProcessX, criterionGraphicInfo.getY() - subProcessY);
            shapesArrayNode.add((JsonNode)criterionNode);
            ObjectNode criterionPropertiesNode = this.objectMapper.createObjectNode();
            criterionPropertiesNode.put("overrideid", criterion.getId());
            new CriterionJsonConverter().convertElementToJson(criterionNode, criterionPropertiesNode, processor, (BaseElement)criterion, model);
            criterionNode.set("properties", (JsonNode)criterionPropertiesNode);
            if (CollectionUtils.isNotEmpty(criterion.getOutgoingAssociations())) {
                ArrayNode criterionOutgoingArrayNode = this.objectMapper.createArrayNode();
                for (Association association : criterion.getOutgoingAssociations()) {
                    criterionOutgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(association.getId()));
                }
                criterionNode.set("outgoing", (JsonNode)criterionOutgoingArrayNode);
            }
            outgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(criterion.getId()));
        }
    }

    protected void addFieldExtensions(List<FieldExtension> extensions, ObjectNode propertiesNode) {
        ObjectNode fieldExtensionsNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (FieldExtension extension : extensions) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("name", extension.getFieldName());
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                propertyItemNode.put("stringValue", extension.getStringValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)extension.getExpression())) {
                propertyItemNode.put("expression", extension.getExpression());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        fieldExtensionsNode.set("fields", (JsonNode)itemsNode);
        propertiesNode.set("servicetaskfields", (JsonNode)fieldExtensionsNode);
    }

    protected void addField(String name, String propertyName, JsonNode elementNode, ServiceTask task) {
        this.addField(name, propertyName, null, elementNode, task);
    }

    protected void addField(String name, String propertyName, String defaultValue, JsonNode elementNode, ServiceTask task) {
        FieldExtension field = new FieldExtension();
        field.setFieldName(name);
        String value = CmmnJsonConverterUtil.getPropertyValueAsString(propertyName, elementNode);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            field.setStringValue(value);
            task.getFieldExtensions().add(field);
        } else if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            field.setStringValue(defaultValue);
            task.getFieldExtensions().add(field);
        }
    }

    protected void setPropertyValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            propertiesNode.put(name, value);
        }
    }

    protected String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    protected boolean getValueAsBoolean(String name, JsonNode objectNode) {
        boolean propertyValue = false;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asBoolean();
        }
        return propertyValue;
    }

    protected List<String> getValueAsList(String name, JsonNode objectNode) {
        ArrayList<String> resultList = new ArrayList<String>();
        JsonNode valuesNode = objectNode.get(name);
        if (valuesNode != null) {
            for (JsonNode valueNode : valuesNode) {
                if (valueNode.get("value") == null || valueNode.get("value").isNull()) continue;
                resultList.add(valueNode.get("value").asText());
            }
        }
        return resultList;
    }

    protected String convertListToCommaSeparatedString(List<String> stringList) {
        String resultString = null;
        if (stringList != null && stringList.size() > 0) {
            StringBuilder expressionBuilder = new StringBuilder();
            for (String singleItem : stringList) {
                if (expressionBuilder.length() > 0) {
                    expressionBuilder.append(",");
                }
                expressionBuilder.append(singleItem);
            }
            resultString = expressionBuilder.toString();
        }
        return resultString;
    }
}

