/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.constants.CmmnStencilConstants;
import org.flowable.cmmn.editor.constants.EditorJsonConstants;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.AssociationJsonConverter;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CaseModelAwareConverter;
import org.flowable.cmmn.editor.json.converter.CaseTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.CriterionJsonConverter;
import org.flowable.cmmn.editor.json.converter.DecisionTableAwareConverter;
import org.flowable.cmmn.editor.json.converter.DecisionTableKeyAwareConverter;
import org.flowable.cmmn.editor.json.converter.DecisionTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.FormAwareConverter;
import org.flowable.cmmn.editor.json.converter.FormKeyAwareConverter;
import org.flowable.cmmn.editor.json.converter.HttpTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.HumanTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.MilestoneJsonConverter;
import org.flowable.cmmn.editor.json.converter.ProcessModelAwareConverter;
import org.flowable.cmmn.editor.json.converter.ProcessTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.ScriptTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.ServiceTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.StageJsonConverter;
import org.flowable.cmmn.editor.json.converter.TaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.TimerEventListenerJsonConverter;
import org.flowable.cmmn.editor.json.converter.UserEventListenerJsonConverter;
import org.flowable.cmmn.editor.json.converter.util.CollectionUtils;
import org.flowable.cmmn.editor.json.model.CmmnModelInfo;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.HasEntryCriteria;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.TimerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnJsonConverter
implements EditorJsonConstants,
CmmnStencilConstants,
ActivityProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CmmnJsonConverter.class);
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected static Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap = new HashMap<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>>();
    protected static Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap = new HashMap<String, Class<? extends BaseCmmnJsonConverter>>();
    public static final String MODELER_NAMESPACE = "http://flowable.org/modeler";
    protected static final DateFormat defaultFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected static final DateFormat entFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final List<String> DI_RECTANGLES;
    private static final List<String> DI_CIRCLES;
    private static final List<String> DI_SENTRY;
    protected double lineWidth = 0.05;

    public ObjectNode convertToJson(CmmnModel model) {
        return this.convertToJson(model, null, null);
    }

    public ObjectNode convertToJson(CmmnModel model, Map<String, CmmnModelInfo> formKeyMap, Map<String, CmmnModelInfo> decisionTableKeyMap) {
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        double maxX = 0.0;
        double maxY = 0.0;
        for (GraphicInfo flowInfo : model.getLocationMap().values()) {
            if (flowInfo.getX() + flowInfo.getWidth() > maxX) {
                maxX = flowInfo.getX() + flowInfo.getWidth();
            }
            if (!(flowInfo.getY() + flowInfo.getHeight() > maxY)) continue;
            maxY = flowInfo.getY() + flowInfo.getHeight();
        }
        maxX += 50.0;
        maxY += 50.0;
        if (maxX < 1485.0) {
            maxX = 1485.0;
        }
        if (maxY < 700.0) {
            maxY = 700.0;
        }
        modelNode.set("bounds", (JsonNode)CmmnJsonConverterUtil.createBoundsNode(maxX, maxY, 0.0, 0.0));
        ObjectNode stencilNode = this.objectMapper.createObjectNode();
        stencilNode.put("id", "CMMNDiagram");
        modelNode.set("stencil", (JsonNode)stencilNode);
        ObjectNode stencilsetNode = this.objectMapper.createObjectNode();
        stencilsetNode.put("namespace", "http://b3mn.org/stencilset/cmmn1.1#");
        stencilsetNode.put("url", "../editor/stencilsets/cmmn1.1/cmmn1.1.json");
        modelNode.set("stencilset", (JsonNode)stencilsetNode);
        ArrayNode shapesArrayNode = this.objectMapper.createArrayNode();
        Case caseModel = model.getPrimaryCase();
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getId())) {
            propertiesNode.put("case_id", caseModel.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getName())) {
            propertiesNode.put("name", caseModel.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getDocumentation())) {
            propertiesNode.put("documentation", caseModel.getDocumentation());
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getInitiatorVariableName())) {
            propertiesNode.put("case_initiatorvariablename", caseModel.getInitiatorVariableName());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{model.getTargetNamespace()})) {
            propertiesNode.put("case_namespace", model.getTargetNamespace());
        }
        modelNode.set("properties", (JsonNode)propertiesNode);
        Stage planModelStage = caseModel.getPlanModel();
        GraphicInfo planModelGraphicInfo = model.getGraphicInfo(planModelStage.getId());
        ObjectNode planModelNode = CmmnJsonConverterUtil.createChildShape(planModelStage.getId(), "CasePlanModel", planModelGraphicInfo.getX() + planModelGraphicInfo.getWidth(), planModelGraphicInfo.getY() + planModelGraphicInfo.getHeight(), planModelGraphicInfo.getX(), planModelGraphicInfo.getY());
        ObjectNode planModelPropertiesNode = this.objectMapper.createObjectNode();
        if (StringUtils.isNotEmpty((CharSequence)planModelStage.getName())) {
            planModelPropertiesNode.put("name", planModelStage.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)planModelStage.getDocumentation())) {
            planModelPropertiesNode.put("documentation", planModelStage.getDocumentation());
        }
        if (planModelStage.isAutoComplete()) {
            planModelPropertiesNode.put("autocompleteenabled", planModelStage.isAutoComplete());
        }
        if (StringUtils.isNotEmpty((CharSequence)planModelStage.getAutoCompleteCondition())) {
            planModelPropertiesNode.put("autocompletecondition", planModelStage.getAutoCompleteCondition());
        }
        if (StringUtils.isNotEmpty((CharSequence)planModelStage.getFormKey())) {
            planModelPropertiesNode.put("formkeydefinition", planModelStage.getFormKey());
        }
        planModelNode.set("properties", (JsonNode)planModelPropertiesNode);
        planModelNode.putArray("outgoing");
        shapesArrayNode.add((JsonNode)planModelNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        for (Criterion criterion : planModelStage.getExitCriteria()) {
            GraphicInfo criterionGraphicInfo = model.getGraphicInfo(criterion.getId());
            ObjectNode criterionNode = CmmnJsonConverterUtil.createChildShape(criterion.getId(), "ExitCriterion", criterionGraphicInfo.getX() + criterionGraphicInfo.getWidth(), criterionGraphicInfo.getY() + criterionGraphicInfo.getHeight(), criterionGraphicInfo.getX(), criterionGraphicInfo.getY());
            shapesArrayNode.add((JsonNode)criterionNode);
            ObjectNode criterionPropertiesNode = this.objectMapper.createObjectNode();
            criterionPropertiesNode.put("overrideid", criterion.getId());
            new CriterionJsonConverter().convertElementToJson(criterionNode, criterionPropertiesNode, this, (BaseElement)criterion, model);
            criterionNode.set("properties", (JsonNode)criterionPropertiesNode);
            if (CollectionUtils.isNotEmpty(criterion.getOutgoingAssociations())) {
                ArrayNode criterionOutgoingArrayNode = this.objectMapper.createArrayNode();
                for (Association association : criterion.getOutgoingAssociations()) {
                    criterionOutgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(association.getId()));
                }
                criterionNode.set("outgoing", (JsonNode)criterionOutgoingArrayNode);
            }
            outgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(criterion.getId()));
        }
        planModelNode.set("outgoing", (JsonNode)outgoingArrayNode);
        ArrayNode planModelShapesArrayNode = this.objectMapper.createArrayNode();
        planModelNode.set("childShapes", (JsonNode)planModelShapesArrayNode);
        this.processPlanItems(caseModel.getPlanModel(), model, planModelShapesArrayNode, formKeyMap, decisionTableKeyMap, planModelGraphicInfo.getX(), planModelGraphicInfo.getY());
        for (Association association : model.getAssociations()) {
            AssociationJsonConverter associationJsonConverter = new AssociationJsonConverter();
            associationJsonConverter.convertToJson((BaseElement)association, model, shapesArrayNode);
        }
        modelNode.set("childShapes", (JsonNode)shapesArrayNode);
        return modelNode;
    }

    @Override
    public void processPlanItems(Stage stage, CmmnModel model, ArrayNode shapesArrayNode, Map<String, CmmnModelInfo> formKeyMap, Map<String, CmmnModelInfo> decisionTableKeyMap, double subProcessX, double subProcessY) {
        for (PlanItem planItem : stage.getPlanItems()) {
            this.processPlanItem(planItem, stage, model, shapesArrayNode, formKeyMap, decisionTableKeyMap, subProcessX, subProcessY);
        }
    }

    protected void processPlanItem(PlanItem planItem, Stage stage, CmmnModel model, ArrayNode shapesArrayNode, Map<String, CmmnModelInfo> formKeyMap, Map<String, CmmnModelInfo> decisionTableKeyMap, double containerX, double containerY) {
        PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
        Class<? extends BaseCmmnJsonConverter> converter = convertersToJsonMap.get(planItemDefinition.getClass());
        if (converter != null) {
            try {
                BaseCmmnJsonConverter converterInstance = converter.newInstance();
                if (converterInstance instanceof FormKeyAwareConverter) {
                    ((FormKeyAwareConverter)((Object)converterInstance)).setFormKeyMap(formKeyMap);
                }
                if (converterInstance instanceof DecisionTableKeyAwareConverter) {
                    ((DecisionTableKeyAwareConverter)((Object)converterInstance)).setDecisionTableKeyMap(decisionTableKeyMap);
                }
                converterInstance.convertToJson((BaseElement)planItem, this, model, (PlanFragment)stage, shapesArrayNode, containerX, containerY);
            }
            catch (Exception e) {
                LOGGER.error("Error converting {}", (Object)planItemDefinition, (Object)e);
            }
        }
    }

    public CmmnModel convertToCmmnModel(JsonNode modelNode) {
        return this.convertToCmmnModel(modelNode, null, null, null, null);
    }

    public CmmnModel convertToCmmnModel(JsonNode modelNode, Map<String, String> formKeyMap, Map<String, String> decisionTableKeyMap, Map<String, String> caseModelKeyMap, Map<String, String> processModelKeyMap) {
        String namespace;
        CmmnModel cmmnModel = new CmmnModel();
        CmmnModelIdHelper cmmnModelIdHelper = new CmmnModelIdHelper();
        cmmnModel.setTargetNamespace("http://flowable.org/cmmn");
        HashMap<String, JsonNode> shapeMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> sourceRefMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> edgeMap = new HashMap<String, JsonNode>();
        HashMap<String, List<JsonNode>> sourceAndTargetMap = new HashMap<String, List<JsonNode>>();
        this.readShapeInfo(modelNode, shapeMap, sourceRefMap);
        this.filterAllEdges(modelNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
        ArrayNode shapesArrayNode = (ArrayNode)modelNode.get("childShapes");
        if (shapesArrayNode == null || shapesArrayNode.size() == 0) {
            return cmmnModel;
        }
        Case caseModel = new Case();
        cmmnModel.getCases().add(caseModel);
        caseModel.setId(CmmnJsonConverterUtil.getPropertyValueAsString("case_id", modelNode));
        caseModel.setName(CmmnJsonConverterUtil.getPropertyValueAsString("name", modelNode));
        caseModel.setInitiatorVariableName(CmmnJsonConverterUtil.getPropertyValueAsString("case_initiatorvariablename", modelNode));
        if (StringUtils.isEmpty((CharSequence)caseModel.getInitiatorVariableName())) {
            caseModel.setInitiatorVariableName("initiator");
        }
        if (StringUtils.isNotEmpty((CharSequence)(namespace = CmmnJsonConverterUtil.getPropertyValueAsString("case_namespace", modelNode)))) {
            cmmnModel.setTargetNamespace(namespace);
        }
        caseModel.setDocumentation(CmmnJsonConverterUtil.getPropertyValueAsString("documentation", modelNode));
        JsonNode planModelShape = shapesArrayNode.get(0);
        JsonNode planModelShapesArray = planModelShape.get("childShapes");
        Stage planModelStage = new Stage();
        planModelStage.setId(CmmnJsonConverterUtil.getElementId(planModelShape));
        planModelStage.setName(CmmnJsonConverterUtil.getPropertyValueAsString("name", planModelShape));
        planModelStage.setDocumentation(CmmnJsonConverterUtil.getPropertyValueAsString("documentation", planModelShape));
        planModelStage.setAutoComplete(CmmnJsonConverterUtil.getPropertyValueAsBoolean("autocompleteenabled", planModelShape));
        String autocompleteCondition = CmmnJsonConverterUtil.getPropertyValueAsString("autocompletecondition", planModelShape);
        if (StringUtils.isNotEmpty((CharSequence)autocompleteCondition)) {
            planModelStage.setAutoCompleteCondition(autocompleteCondition);
        }
        planModelStage.setFormKey(CmmnJsonConverterUtil.getPropertyFormKey(planModelShape, formKeyMap));
        planModelStage.setPlanModel(true);
        caseModel.setPlanModel(planModelStage);
        this.processJsonElements(planModelShapesArray, modelNode, (BaseElement)planModelStage, shapeMap, formKeyMap, decisionTableKeyMap, caseModelKeyMap, processModelKeyMap, cmmnModel, cmmnModelIdHelper);
        ArrayList<String> planModelExitCriteriaRefs = new ArrayList<String>();
        for (JsonNode shapeNode : shapesArrayNode) {
            JsonNode resourceNode;
            if ("Association".equalsIgnoreCase(CmmnJsonConverterUtil.getStencilId(shapeNode))) {
                AssociationJsonConverter associationConverter = new AssociationJsonConverter();
                Association association = associationConverter.convertJsonToElement(shapeNode, modelNode, (ActivityProcessor)this, (BaseElement)planModelStage, shapeMap, cmmnModel, cmmnModelIdHelper);
                cmmnModel.addAssociation(association);
                continue;
            }
            if (!"ExitCriterion".equalsIgnoreCase(CmmnJsonConverterUtil.getStencilId(shapeNode)) || (resourceNode = shapeNode.get("resourceId")) == null) continue;
            planModelExitCriteriaRefs.add(resourceNode.asText());
            CriterionJsonConverter criterionJsonConverter = new CriterionJsonConverter();
            criterionJsonConverter.convertJsonToElement(shapeNode, modelNode, (ActivityProcessor)this, (BaseElement)planModelStage, shapeMap, cmmnModel, cmmnModelIdHelper);
        }
        this.readShapeDI(modelNode, 0.0, 0.0, cmmnModel);
        this.readEdgeDI(edgeMap, sourceAndTargetMap, cmmnModel);
        Map<String, List<Association>> associationMap = this.postProcessAssociations(cmmnModel);
        this.postProcessElements(planModelStage, planModelStage.getPlanItems(), edgeMap, associationMap, cmmnModel, cmmnModelIdHelper);
        this.createSentryParts(planModelExitCriteriaRefs, planModelStage, associationMap, cmmnModel, cmmnModelIdHelper, null, (HasExitCriteria)planModelStage);
        return cmmnModel;
    }

    @Override
    public void processJsonElements(JsonNode shapesArrayNode, JsonNode modelNode, BaseElement parentElement, Map<String, JsonNode> shapeMap, Map<String, String> formMap, Map<String, String> decisionTableMap, Map<String, String> caseModelKeyMap, Map<String, String> processModelKeyMap, CmmnModel cmmnModel, CmmnModelIdHelper cmmnModelIdHelper) {
        for (JsonNode shapeNode : shapesArrayNode) {
            String stencilId = CmmnJsonConverterUtil.getStencilId(shapeNode);
            Class<? extends BaseCmmnJsonConverter> converter = convertersToCmmnMap.get(stencilId);
            try {
                BaseCmmnJsonConverter converterInstance = converter.newInstance();
                if (converterInstance instanceof DecisionTableAwareConverter) {
                    ((DecisionTableAwareConverter)((Object)converterInstance)).setDecisionTableMap(decisionTableMap);
                }
                if (converterInstance instanceof FormAwareConverter) {
                    ((FormAwareConverter)((Object)converterInstance)).setFormMap(formMap);
                }
                if (converterInstance instanceof CaseModelAwareConverter) {
                    ((CaseModelAwareConverter)((Object)converterInstance)).setCaseModelMap(caseModelKeyMap);
                }
                if (converterInstance instanceof ProcessModelAwareConverter) {
                    ((ProcessModelAwareConverter)((Object)converterInstance)).setProcessModelMap(processModelKeyMap);
                }
                converterInstance.convertToCmmnModel(shapeNode, modelNode, this, parentElement, shapeMap, cmmnModel, cmmnModelIdHelper);
            }
            catch (Exception e) {
                LOGGER.error("Error converting {}", (Object)CmmnJsonConverterUtil.getStencilId(shapeNode));
            }
        }
    }

    protected Map<String, List<Association>> postProcessAssociations(CmmnModel cmmnModel) {
        HashMap<String, List<Association>> associationMap = new HashMap<String, List<Association>>();
        for (Association association : cmmnModel.getAssociations()) {
            PlanItemDefinition planItemDefinition;
            if (association.getSourceRef() == null || association.getTargetRef() == null) continue;
            boolean sourceIsCriterion = true;
            Criterion criterion = cmmnModel.getCriterion(association.getSourceRef());
            if (criterion != null) {
                planItemDefinition = cmmnModel.findPlanItemDefinition(association.getTargetRef());
            } else {
                criterion = cmmnModel.getCriterion(association.getTargetRef());
                if (criterion == null) continue;
                sourceIsCriterion = false;
                planItemDefinition = cmmnModel.findPlanItemDefinition(association.getSourceRef());
                if (planItemDefinition == null) {
                    planItemDefinition = cmmnModel.findPlanItemDefinition(association.getTargetRef());
                }
            }
            if (planItemDefinition == null) continue;
            PlanItem planItem = cmmnModel.findPlanItem(planItemDefinition.getPlanItemRef());
            if (sourceIsCriterion) {
                association.setSourceElement((BaseElement)criterion);
                criterion.addOutgoingAssociation(association);
                association.setTargetElement((BaseElement)planItem);
                association.setTargetRef(planItem.getId());
                planItem.addIncomingAssociation(association);
            } else {
                association.setTargetElement((BaseElement)criterion);
                criterion.addIncomingAssociation(association);
                association.setSourceElement((BaseElement)planItem);
                association.setSourceRef(planItem.getId());
                planItem.addOutgoingAssociation(association);
            }
            if (!associationMap.containsKey(criterion.getId())) {
                associationMap.put(criterion.getId(), new ArrayList());
            }
            ((List)associationMap.get(criterion.getId())).add(association);
        }
        return associationMap;
    }

    protected void postProcessElements(Stage parentStage, List<PlanItem> planItems, Map<String, JsonNode> edgeMap, Map<String, List<Association>> associationMap, CmmnModel cmmnModel, CmmnModelIdHelper cmmnModelIdHelper) {
        for (PlanItem planItem : planItems) {
            TimerEventListener timerEventListener;
            String startTriggerSourceRef;
            PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
            if (planItemDefinition instanceof Stage) {
                Stage stage = (Stage)planItemDefinition;
                this.postProcessElements(stage, stage.getPlanItems(), edgeMap, associationMap, cmmnModel, cmmnModelIdHelper);
            } else if (planItemDefinition instanceof TimerEventListener && StringUtils.isNotEmpty((CharSequence)(startTriggerSourceRef = (timerEventListener = (TimerEventListener)planItemDefinition).getTimerStartTriggerSourceRef()))) {
                PlanItemDefinition referencedPlanItemDefinition = parentStage.findPlanItemDefinition(startTriggerSourceRef);
                timerEventListener.setTimerStartTriggerSourceRef(referencedPlanItemDefinition.getPlanItemRef());
            }
            if (!CollectionUtils.isNotEmpty(planItem.getCriteriaRefs())) continue;
            this.createSentryParts(planItem.getCriteriaRefs(), parentStage, associationMap, cmmnModel, cmmnModelIdHelper, (HasEntryCriteria)planItem, (HasExitCriteria)planItem);
        }
    }

    protected void createSentryParts(List<String> criteriaRefs, Stage parentStage, Map<String, List<Association>> associationMap, CmmnModel cmmnModel, CmmnModelIdHelper cmmnModelIdHelper, HasEntryCriteria hasEntryCriteriaElement, HasExitCriteria hasExitCriteriaElement) {
        for (String criterionRef : criteriaRefs) {
            Criterion criterion;
            String criterionId = cmmnModel.getCriterionId(criterionRef);
            if (criterionId == null || (criterion = cmmnModel.getCriterion(criterionId)) == null) continue;
            PlanItemDefinition planItemDefinition = cmmnModel.findPlanItemDefinition(criterion.getAttachedToRefId());
            criterion.setAttachedToRefId(planItemDefinition.getPlanItemRef());
            parentStage.addSentry(criterion.getSentry());
            boolean associationsFound = associationMap.containsKey(criterion.getId());
            if (!associationsFound && criterion.getSentry() == null) continue;
            if (criterion.isEntryCriterion()) {
                hasEntryCriteriaElement.addEntryCriterion(criterion);
            } else if (criterion.isExitCriterion()) {
                hasExitCriteriaElement.addExitCriterion(criterion);
            }
            if (!associationsFound) continue;
            List<Association> associations = associationMap.get(criterion.getId());
            for (Association association : associations) {
                PlanItem criterionPlanItem = null;
                criterionPlanItem = association.getSourceRef().equals(criterion.getId()) ? (PlanItem)association.getTargetElement() : (PlanItem)association.getSourceElement();
                SentryOnPart sentryOnPart = new SentryOnPart();
                sentryOnPart.setId("sentryOnPart" + cmmnModelIdHelper.nextSentryOnPartId());
                sentryOnPart.setSourceRef(criterionPlanItem.getId());
                sentryOnPart.setSource(criterionPlanItem);
                if (StringUtils.isNotEmpty((CharSequence)association.getTransitionEvent())) {
                    sentryOnPart.setStandardEvent(association.getTransitionEvent());
                } else {
                    sentryOnPart.setStandardEvent("complete");
                }
                criterion.getSentry().addSentryOnPart(sentryOnPart);
            }
        }
    }

    protected void readShapeInfo(JsonNode objectNode, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                String stencilId = CmmnJsonConverterUtil.getStencilId(jsonChildNode);
                if ("Association".equals(stencilId)) continue;
                String childShapeId = jsonChildNode.get("resourceId").asText();
                shapeMap.put(childShapeId, jsonChildNode);
                ArrayNode outgoingNode = (ArrayNode)jsonChildNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null) continue;
                        sourceRefMap.put(resourceNode.asText(), jsonChildNode);
                    }
                }
                this.readShapeInfo(jsonChildNode, shapeMap, sourceRefMap);
            }
        }
    }

    protected void readShapeDI(JsonNode objectNode, double parentX, double parentY, CmmnModel cmmnModel) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                String stencilId = CmmnJsonConverterUtil.getStencilId(jsonChildNode);
                if ("Association".equals(stencilId)) continue;
                GraphicInfo graphicInfo = new GraphicInfo();
                JsonNode boundsNode = jsonChildNode.get("bounds");
                ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
                ObjectNode lowerRightNode = (ObjectNode)boundsNode.get("lowerRight");
                graphicInfo.setX(upperLeftNode.get("x").asDouble() + parentX);
                graphicInfo.setY(upperLeftNode.get("y").asDouble() + parentY);
                graphicInfo.setWidth(lowerRightNode.get("x").asDouble() - graphicInfo.getX() + parentX);
                graphicInfo.setHeight(lowerRightNode.get("y").asDouble() - graphicInfo.getY() + parentY);
                String elementId = CmmnJsonConverterUtil.getElementId(jsonChildNode);
                if ("EntryCriterion".equals(stencilId) || "ExitCriterion".equals(stencilId)) {
                    cmmnModel.addGraphicInfo(elementId, graphicInfo);
                } else {
                    PlanItemDefinition planItemDefinition = cmmnModel.findPlanItemDefinition(elementId);
                    if (!(planItemDefinition instanceof Stage) || !((Stage)planItemDefinition).isPlanModel()) {
                        PlanItem planItem = cmmnModel.findPlanItem(planItemDefinition.getPlanItemRef());
                        cmmnModel.addGraphicInfo(planItem.getId(), graphicInfo);
                    } else {
                        cmmnModel.addGraphicInfo(planItemDefinition.getId(), graphicInfo);
                    }
                }
                this.readShapeDI(jsonChildNode, graphicInfo.getX(), graphicInfo.getY(), cmmnModel);
            }
        }
    }

    protected void filterAllEdges(JsonNode objectNode, Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                ObjectNode childNode = (ObjectNode)jsonChildNode;
                String stencilId = CmmnJsonConverterUtil.getStencilId((JsonNode)childNode);
                if ("CasePlanModel".equals(stencilId) || "Stage".equals(stencilId)) {
                    this.filterAllEdges((JsonNode)childNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
                    continue;
                }
                if (!"Association".equals(stencilId)) continue;
                String childEdgeId = CmmnJsonConverterUtil.getElementId((JsonNode)childNode);
                JsonNode targetNode = childNode.get("target");
                if (targetNode != null && !targetNode.isNull()) {
                    String targetRefId = targetNode.get("resourceId").asText();
                    ArrayList<JsonNode> sourceAndTargetList = new ArrayList<JsonNode>();
                    sourceAndTargetList.add(sourceRefMap.get(childNode.get("resourceId").asText()));
                    sourceAndTargetList.add(shapeMap.get(targetRefId));
                    sourceAndTargetMap.put(childEdgeId, sourceAndTargetList);
                }
                edgeMap.put(childEdgeId, (JsonNode)childNode);
            }
        }
    }

    protected void readEdgeDI(Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, CmmnModel cmmnModel) {
        for (String edgeId : edgeMap.keySet()) {
            JsonNode edgeNode = edgeMap.get(edgeId);
            List<JsonNode> sourceAndTargetList = sourceAndTargetMap.get(edgeId);
            JsonNode sourceRefNode = null;
            JsonNode targetRefNode = null;
            if (sourceAndTargetList != null && sourceAndTargetList.size() > 1) {
                sourceRefNode = sourceAndTargetList.get(0);
                targetRefNode = sourceAndTargetList.get(1);
            }
            if (sourceRefNode == null) {
                LOGGER.info("Skipping edge {} because source ref is null", (Object)edgeId);
                continue;
            }
            if (targetRefNode == null) {
                LOGGER.info("Skipping edge {} because target ref is null", (Object)edgeId);
                continue;
            }
            JsonNode dockersNode = edgeNode.get("dockers");
            double sourceDockersX = dockersNode.get(0).get("x").asDouble();
            double sourceDockersY = dockersNode.get(0).get("y").asDouble();
            String stencilId = CmmnJsonConverterUtil.getStencilId(sourceRefNode);
            String sourceId = null;
            if ("EntryCriterion".equals(stencilId) || "ExitCriterion".equals(stencilId)) {
                sourceId = CmmnJsonConverterUtil.getElementId(sourceRefNode);
            } else {
                String elementId = CmmnJsonConverterUtil.getElementId(sourceRefNode);
                PlanItemDefinition planItemDefinition = cmmnModel.findPlanItemDefinition(elementId);
                PlanItem planItem = cmmnModel.findPlanItem(planItemDefinition.getPlanItemRef());
                sourceId = planItem.getId();
            }
            GraphicInfo sourceInfo = cmmnModel.getGraphicInfo(sourceId);
            stencilId = CmmnJsonConverterUtil.getStencilId(targetRefNode);
            String targetId = null;
            if ("EntryCriterion".equals(stencilId) || "ExitCriterion".equals(stencilId)) {
                targetId = CmmnJsonConverterUtil.getElementId(targetRefNode);
            } else {
                String elementId = CmmnJsonConverterUtil.getElementId(targetRefNode);
                PlanItemDefinition planItemDefinition = cmmnModel.findPlanItemDefinition(elementId);
                PlanItem planItem = cmmnModel.findPlanItem(planItemDefinition.getPlanItemRef());
                targetId = planItem.getId();
            }
            GraphicInfo targetInfo = cmmnModel.getGraphicInfo(targetId);
            double sourceRefLineX = sourceInfo.getX() + sourceDockersX;
            double sourceRefLineY = sourceInfo.getY() + sourceDockersY;
            double nextPointInLineX = dockersNode.get(1).get("x").asDouble();
            double nextPointInLineY = dockersNode.get(1).get("y").asDouble();
            if (dockersNode.size() == 2) {
                nextPointInLineX += targetInfo.getX();
                nextPointInLineY += targetInfo.getY();
            }
            Line2D.Double firstLine = new Line2D.Double(sourceRefLineX, sourceRefLineY, nextPointInLineX, nextPointInLineY);
            String sourceRefStencilId = CmmnJsonConverterUtil.getStencilId(sourceRefNode);
            String targetRefStencilId = CmmnJsonConverterUtil.getStencilId(targetRefNode);
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            Area source2D = null;
            if (DI_CIRCLES.contains(sourceRefStencilId)) {
                source2D = this.createEllipse(sourceInfo, sourceDockersX, sourceDockersY);
            } else if (DI_RECTANGLES.contains(sourceRefStencilId)) {
                source2D = this.createRectangle(sourceInfo);
            } else if (DI_SENTRY.contains(sourceRefStencilId)) {
                source2D = this.createGateway(sourceInfo);
            }
            if (source2D != null) {
                Collection<Point2D> intersections = this.getIntersections(firstLine, source2D);
                if (intersections != null && intersections.size() > 0) {
                    Point2D intersection = intersections.iterator().next();
                    graphicInfoList.add(this.createGraphicInfo(intersection.getX(), intersection.getY()));
                } else {
                    graphicInfoList.add(this.createGraphicInfo(sourceRefLineX, sourceRefLineY));
                }
            }
            Line2D.Double lastLine = null;
            if (dockersNode.size() > 2) {
                for (int i = 1; i < dockersNode.size() - 1; ++i) {
                    double x = dockersNode.get(i).get("x").asDouble();
                    double y = dockersNode.get(i).get("y").asDouble();
                    graphicInfoList.add(this.createGraphicInfo(x, y));
                }
                double startLastLineX = dockersNode.get(dockersNode.size() - 2).get("x").asDouble();
                double startLastLineY = dockersNode.get(dockersNode.size() - 2).get("y").asDouble();
                double endLastLineX = dockersNode.get(dockersNode.size() - 1).get("x").asDouble();
                double endLastLineY = dockersNode.get(dockersNode.size() - 1).get("y").asDouble();
                lastLine = new Line2D.Double(startLastLineX, startLastLineY, endLastLineX += targetInfo.getX(), endLastLineY += targetInfo.getY());
            } else {
                lastLine = firstLine;
            }
            Area target2D = null;
            if (DI_CIRCLES.contains(targetRefStencilId)) {
                double targetDockersX = dockersNode.get(dockersNode.size() - 1).get("x").asDouble();
                double targetDockersY = dockersNode.get(dockersNode.size() - 1).get("y").asDouble();
                target2D = this.createEllipse(targetInfo, targetDockersX, targetDockersY);
            }
            if (DI_RECTANGLES.contains(targetRefStencilId)) {
                target2D = this.createRectangle(targetInfo);
            } else if (DI_SENTRY.contains(targetRefStencilId)) {
                target2D = this.createGateway(targetInfo);
            }
            if (target2D != null) {
                Collection<Point2D> intersections = this.getIntersections(lastLine, target2D);
                if (intersections != null && intersections.size() > 0) {
                    Point2D intersection = intersections.iterator().next();
                    graphicInfoList.add(this.createGraphicInfo(intersection.getX(), intersection.getY()));
                } else {
                    graphicInfoList.add(this.createGraphicInfo(((Line2D)lastLine).getX2(), ((Line2D)lastLine).getY2()));
                }
            }
            cmmnModel.addFlowGraphicInfoList(edgeId, graphicInfoList);
        }
    }

    protected Area createEllipse(GraphicInfo sourceInfo, double halfWidth, double halfHeight) {
        Area outerCircle = new Area(new Ellipse2D.Double(sourceInfo.getX(), sourceInfo.getY(), 2.0 * halfWidth, 2.0 * halfHeight));
        Area innerCircle = new Area(new Ellipse2D.Double(sourceInfo.getX() + this.lineWidth, sourceInfo.getY() + this.lineWidth, 2.0 * (halfWidth - this.lineWidth), 2.0 * (halfHeight - this.lineWidth)));
        outerCircle.subtract(innerCircle);
        return outerCircle;
    }

    protected Collection<Point2D> getIntersections(Line2D line, Area shape) {
        Area intersectionArea = new Area(this.getLineShape(line));
        intersectionArea.intersect(shape);
        if (!intersectionArea.isEmpty()) {
            Rectangle2D bounds2D = intersectionArea.getBounds2D();
            HashSet<Point2D> intersections = new HashSet<Point2D>(2);
            intersections.add(new Point2D.Double(bounds2D.getX(), bounds2D.getY()));
            return intersections;
        }
        return Collections.EMPTY_SET;
    }

    protected Shape getLineShape(Line2D line2D) {
        Path2D.Double line = new Path2D.Double(1, 4);
        ((Path2D)line).moveTo(line2D.getX1(), line2D.getY1());
        ((Path2D)line).lineTo(line2D.getX2(), line2D.getY2());
        ((Path2D)line).lineTo(line2D.getX2() + this.lineWidth, line2D.getY2() + this.lineWidth);
        line.closePath();
        return line;
    }

    protected Area createRectangle(GraphicInfo graphicInfo) {
        Area outerRectangle = new Area(new Rectangle2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight()));
        Area innerRectangle = new Area(new Rectangle2D.Double(graphicInfo.getX() + this.lineWidth, graphicInfo.getY() + this.lineWidth, graphicInfo.getWidth() - 2.0 * this.lineWidth, graphicInfo.getHeight() - 2.0 * this.lineWidth));
        outerRectangle.subtract(innerRectangle);
        return outerRectangle;
    }

    protected Area createGateway(GraphicInfo graphicInfo) {
        Area outerGatewayArea = new Area(this.createGatewayShape(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight()));
        Area innerGatewayArea = new Area(this.createGatewayShape(graphicInfo.getX() + this.lineWidth, graphicInfo.getY() + this.lineWidth, graphicInfo.getWidth() - 2.0 * this.lineWidth, graphicInfo.getHeight() - 2.0 * this.lineWidth));
        outerGatewayArea.subtract(innerGatewayArea);
        return outerGatewayArea;
    }

    private Path2D.Double createGatewayShape(double x, double y, double width, double height) {
        double middleX = x + width / 2.0;
        double middleY = y + height / 2.0;
        Path2D.Double gatewayShape = new Path2D.Double(1, 4);
        gatewayShape.moveTo(x, middleY);
        gatewayShape.lineTo(middleX, y);
        gatewayShape.lineTo(x + width, middleY);
        gatewayShape.lineTo(middleX, y + height);
        gatewayShape.closePath();
        return gatewayShape;
    }

    protected GraphicInfo createGraphicInfo(double x, double y) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(x);
        graphicInfo.setY(y);
        return graphicInfo;
    }

    static {
        AssociationJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        HumanTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        ServiceTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        DecisionTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        HttpTaskJsonConverter.fillTypes(convertersToCmmnMap);
        CaseTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        ProcessTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        TimerEventListenerJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        UserEventListenerJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        TaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        ScriptTaskJsonConverter.fillTypes(convertersToCmmnMap);
        MilestoneJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        CriterionJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        StageJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        DI_RECTANGLES = new ArrayList<String>();
        DI_CIRCLES = new ArrayList<String>();
        DI_SENTRY = new ArrayList<String>();
        DI_CIRCLES.add("TimerEventListener");
        DI_CIRCLES.add("UserEventListener");
        DI_RECTANGLES.add("Task");
        DI_RECTANGLES.add("HumanTask");
        DI_RECTANGLES.add("ServiceTask");
        DI_RECTANGLES.add("DecisionTask");
        DI_RECTANGLES.add("CaseTask");
        DI_RECTANGLES.add("ProcessTask");
        DI_RECTANGLES.add("Milestone");
        DI_RECTANGLES.add("Stage");
        DI_SENTRY.add("EntryCriterion");
        DI_SENTRY.add("ExitCriterion");
    }

    public static class CmmnModelIdHelper {
        protected int planItemIndex = 0;
        protected int criterionId = 0;
        protected int sentryIndex = 0;
        protected int sentryOnPartIndex = 0;

        public int nextPlanItemId() {
            ++this.planItemIndex;
            return this.planItemIndex;
        }

        public int nextCriterionId() {
            ++this.criterionId;
            return this.criterionId;
        }

        public int nextSentryId() {
            ++this.sentryIndex;
            return this.sentryIndex;
        }

        public int nextSentryOnPartId() {
            ++this.sentryOnPartIndex;
            return this.sentryOnPartIndex;
        }
    }
}

