/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.ServiceTask;

public class HttpTaskJsonConverter
extends BaseCmmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap) {
        HttpTaskJsonConverter.fillJsonTypes(convertersToCmmnMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("HttpTask", HttpTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "HttpTask";
    }

    protected CaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        HttpServiceTask task = new HttpServiceTask();
        if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskclass", elementNode))) {
            task.setImplementation(CmmnJsonConverterUtil.getPropertyValueAsString("servicetaskclass", elementNode));
        }
        this.addField("requestMethod", "httptaskrequestmethod", "GET", elementNode, (ServiceTask)task);
        this.addField("requestUrl", "httptaskrequesturl", elementNode, (ServiceTask)task);
        this.addField("requestHeaders", "httptaskrequestheaders", elementNode, (ServiceTask)task);
        this.addField("requestBody", "httptaskrequestbody", elementNode, (ServiceTask)task);
        this.addField("requestBodyEncoding", "httptaskrequestbodyencoding", elementNode, (ServiceTask)task);
        this.addField("requestTimeout", "httptaskrequesttimeout", elementNode, (ServiceTask)task);
        this.addField("disallowRedirects", "httptaskdisallowredirects", elementNode, (ServiceTask)task);
        this.addField("failStatusCodes", "httptaskfailstatuscodes", elementNode, (ServiceTask)task);
        this.addField("handleStatusCodes", "httptaskhandlestatuscodes", elementNode, (ServiceTask)task);
        this.addField("responseVariableName", "httptaskresponsevariablename", elementNode, (ServiceTask)task);
        this.addField("ignoreException", "httptaskignoreexception", elementNode, (ServiceTask)task);
        this.addField("saveRequestVariables", "httptasksaverequestvariables", elementNode, (ServiceTask)task);
        this.addField("saveResponseParameters", "httptasksaveresponseparameters", elementNode, (ServiceTask)task);
        this.addField("resultVariablePrefix", "httptaskresultvariableprefix", elementNode, (ServiceTask)task);
        this.addField("saveResponseParametersTransient", "httptasksaveresponseparameterstransient", elementNode, (ServiceTask)task);
        this.addField("saveResponseVariableAsJson", "httptasksaveresponseasjson", elementNode, (ServiceTask)task);
        return task;
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel) {
    }
}

