/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.ProcessModelAwareConverter;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ProcessTask;

public class ProcessTaskJsonConverter
extends BaseCmmnJsonConverter
implements ProcessModelAwareConverter {
    protected Map<String, String> processModelMap;

    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        ProcessTaskJsonConverter.fillJsonTypes(convertersToCmmnMap);
        ProcessTaskJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ProcessTask", ProcessTaskJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ProcessTask.class, ProcessTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "ProcessTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel) {
        ProcessTask processTask = (ProcessTask)((PlanItem)baseElement).getPlanItemDefinition();
        if (processTask.getFallbackToDefaultTenant() != null) {
            propertiesNode.put("fallbacktodefaulttenant", processTask.getFallbackToDefaultTenant());
        }
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, (PlanItemDefinition)processTask);
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        JsonNode fallbackToDefaultTenant;
        JsonNode processTaskOutParametersNode;
        JsonNode processTaskInParametersNode;
        ProcessTask task = new ProcessTask();
        JsonNode processModelReferenceNode = CmmnJsonConverterUtil.getProperty("processtaskprocessreference", elementNode);
        if (processModelReferenceNode != null && processModelReferenceNode.has("id") && !processModelReferenceNode.get("id").isNull()) {
            String processModelId = processModelReferenceNode.get("id").asText();
            if (this.processModelMap != null) {
                String processModelKey = this.processModelMap.get(processModelId);
                task.setProcessRef(processModelKey);
            }
        }
        if ((processTaskInParametersNode = CmmnJsonConverterUtil.getProperty("processtaskinparameters", elementNode)) != null && processTaskInParametersNode.has("inParameters") && !processTaskInParametersNode.get("inParameters").isNull()) {
            JsonNode inParametersNode = processTaskInParametersNode.get("inParameters");
            task.setInParameters(this.readIOParameters(inParametersNode));
        }
        if ((processTaskOutParametersNode = CmmnJsonConverterUtil.getProperty("processtaskoutparameters", elementNode)) != null && processTaskOutParametersNode.has("outParameters") && !processTaskOutParametersNode.get("outParameters").isNull()) {
            JsonNode outParametersNode = processTaskOutParametersNode.get("outParameters");
            task.setOutParameters(this.readIOParameters(outParametersNode));
        }
        if ((fallbackToDefaultTenant = CmmnJsonConverterUtil.getProperty("fallbacktodefaulttenant", elementNode)) != null) {
            task.setFallbackToDefaultTenant(Boolean.valueOf(fallbackToDefaultTenant.booleanValue()));
        }
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)task);
        return task;
    }

    private List<IOParameter> readIOParameters(JsonNode parametersNode) {
        ArrayList<IOParameter> ioParameters = new ArrayList<IOParameter>();
        for (JsonNode paramNode : parametersNode) {
            IOParameter ioParameter = new IOParameter();
            ioParameter.setSource(paramNode.get("source").asText());
            ioParameter.setSourceExpression(paramNode.get("sourceExpression").asText());
            ioParameter.setTarget(paramNode.get("target").asText());
            ioParameter.setTargetExpression(paramNode.get("targetExpression").asText());
            ioParameters.add(ioParameter);
        }
        return ioParameters;
    }

    @Override
    public void setProcessModelMap(Map<String, String> processModelMap) {
        this.processModelMap = processModelMap;
    }
}

