/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.CollectionUtils;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.cmmn.model.PlanItemDefinition;

public class ListenerConverterUtil {
    public static void convertLifecycleListenersToJson(ObjectMapper objectMapper, ObjectNode propertiesNode, PlanItemDefinition planItemDefinition) {
        ObjectNode planItemLifecycleListeners = ListenerConverterUtil.convertListenersToJson(objectMapper, "planItemLifecycleListeners", planItemDefinition.getLifecycleListeners());
        if (planItemLifecycleListeners != null) {
            propertiesNode.set("planitemlifecyclelisteners", (JsonNode)planItemLifecycleListeners);
        }
    }

    public static ObjectNode convertListenersToJson(ObjectMapper objectMapper, String jsonPropertyName, List<FlowableListener> listeners) {
        if (listeners != null) {
            ObjectNode listenersNode = objectMapper.createObjectNode();
            ArrayNode itemsNode = objectMapper.createArrayNode();
            for (FlowableListener listener : listeners) {
                ObjectNode propertyItemNode = objectMapper.createObjectNode();
                if (StringUtils.isNotEmpty((CharSequence)listener.getEvent())) {
                    propertyItemNode.put("event", listener.getEvent());
                }
                if (StringUtils.isNotEmpty((CharSequence)listener.getSourceState())) {
                    propertyItemNode.put("sourceState", listener.getSourceState());
                }
                if (StringUtils.isNotEmpty((CharSequence)listener.getTargetState())) {
                    propertyItemNode.put("targetState", listener.getTargetState());
                }
                if ("class".equals(listener.getImplementationType())) {
                    propertyItemNode.put("className", listener.getImplementation());
                } else if ("expression".equals(listener.getImplementationType())) {
                    propertyItemNode.put("expression", listener.getImplementation());
                } else if ("delegateExpression".equals(listener.getImplementationType())) {
                    propertyItemNode.put("delegateExpression", listener.getImplementation());
                }
                if (CollectionUtils.isNotEmpty(listener.getFieldExtensions())) {
                    ArrayNode fieldsArray = objectMapper.createArrayNode();
                    for (FieldExtension fieldExtension : listener.getFieldExtensions()) {
                        ObjectNode fieldNode = objectMapper.createObjectNode();
                        fieldNode.put("name", fieldExtension.getFieldName());
                        if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getStringValue())) {
                            fieldNode.put("stringValue", fieldExtension.getStringValue());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getExpression())) {
                            fieldNode.put("expression", fieldExtension.getExpression());
                        }
                        fieldsArray.add((JsonNode)fieldNode);
                    }
                    propertyItemNode.set("fields", (JsonNode)fieldsArray);
                }
                itemsNode.add((JsonNode)propertyItemNode);
            }
            listenersNode.set(jsonPropertyName, (JsonNode)itemsNode);
            return listenersNode;
        }
        return null;
    }

    public static void convertJsonToLifeCycleListeners(JsonNode elementNode, PlanItemDefinition planItemDefinition) {
        List<FlowableListener> listeners = ListenerConverterUtil.convertJsonToListeners(elementNode, "planitemlifecyclelisteners", "planItemLifecycleListeners");
        if (listeners != null) {
            planItemDefinition.getLifecycleListeners().addAll(listeners);
        }
    }

    public static List<FlowableListener> convertJsonToListeners(JsonNode elementNode, String propertyName, String innerPropertyName) {
        JsonNode listenersNode = CmmnJsonConverterUtil.getProperty(propertyName, elementNode);
        if (listenersNode != null) {
            listenersNode = listenersNode.get(innerPropertyName);
        }
        if (listenersNode != null && !listenersNode.isNull()) {
            ArrayList<FlowableListener> listeners = new ArrayList<FlowableListener>();
            for (JsonNode listenerNode : listenersNode) {
                JsonNode targetStateNode;
                JsonNode sourceStateNode;
                FlowableListener listener = new FlowableListener();
                JsonNode eventNode = listenerNode.get("event");
                if (eventNode != null && !eventNode.isNull()) {
                    listener.setEvent(eventNode.asText());
                }
                if ((sourceStateNode = listenerNode.get("sourceState")) != null && !sourceStateNode.isNull()) {
                    listener.setSourceState(sourceStateNode.asText());
                }
                if ((targetStateNode = listenerNode.get("targetState")) != null && !targetStateNode.isNull()) {
                    listener.setTargetState(targetStateNode.asText());
                }
                if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getValueAsString("className", listenerNode))) {
                    listener.setImplementationType("class");
                    listener.setImplementation(CmmnJsonConverterUtil.getValueAsString("className", listenerNode));
                } else if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getValueAsString("expression", listenerNode))) {
                    listener.setImplementationType("expression");
                    listener.setImplementation(CmmnJsonConverterUtil.getValueAsString("expression", listenerNode));
                } else if (StringUtils.isNotEmpty((CharSequence)CmmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode))) {
                    listener.setImplementationType("delegateExpression");
                    listener.setImplementation(CmmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode));
                }
                JsonNode fieldsNode = listenerNode.get("fields");
                if (fieldsNode != null) {
                    for (JsonNode fieldNode : fieldsNode) {
                        JsonNode nameNode = fieldNode.get("name");
                        if (nameNode == null || nameNode.isNull() || !StringUtils.isNotEmpty((CharSequence)nameNode.asText())) continue;
                        FieldExtension fieldExtension = new FieldExtension();
                        fieldExtension.setFieldName(nameNode.asText());
                        fieldExtension.setStringValue(CmmnJsonConverterUtil.getValueAsString("stringValue", fieldNode));
                        if (StringUtils.isEmpty((CharSequence)fieldExtension.getStringValue())) {
                            fieldExtension.setStringValue(CmmnJsonConverterUtil.getValueAsString("string", fieldNode));
                        }
                        if (StringUtils.isEmpty((CharSequence)fieldExtension.getStringValue())) {
                            fieldExtension.setExpression(CmmnJsonConverterUtil.getValueAsString("expression", fieldNode));
                        }
                        listener.getFieldExtensions().add(fieldExtension);
                    }
                }
                listeners.add(listener);
            }
            return listeners;
        }
        return null;
    }
}

