/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanItem;

public class AssociationJsonConverter
extends BaseCmmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        AssociationJsonConverter.fillJsonTypes(convertersToCmmnMap);
        AssociationJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap) {
        convertersToCmmnMap.put("Association", AssociationJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(Association.class, AssociationJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "Association";
    }

    public void convertToJson(BaseElement baseElement, CmmnModel model, ArrayNode shapesArrayNode) {
        Criterion criterion;
        PlanItem sourcePlanItem;
        Association association = (Association)baseElement;
        ObjectNode flowNode = CmmnJsonConverterUtil.createChildShape(association.getId(), "Association", 172.0, 212.0, 128.0, 212.0);
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        GraphicInfo sourceGraphicInfo = model.getGraphicInfo(association.getSourceRef());
        if (sourceGraphicInfo == null && (sourcePlanItem = model.findPlanItemByPlanItemDefinitionId(association.getSourceRef())) != null) {
            sourceGraphicInfo = model.getGraphicInfo(sourcePlanItem.getId());
        }
        if (sourceGraphicInfo == null) {
            return;
        }
        dockNode.put("x", sourceGraphicInfo.getWidth() / 2.0);
        dockNode.put("y", sourceGraphicInfo.getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        List graphicInfoList = model.getFlowLocationGraphicInfo(association.getId());
        if (graphicInfoList.size() > 2) {
            for (int i = 1; i < graphicInfoList.size() - 1; ++i) {
                GraphicInfo graphicInfo = (GraphicInfo)graphicInfoList.get(i);
                dockNode = this.objectMapper.createObjectNode();
                dockNode.put("x", graphicInfo.getX());
                dockNode.put("y", graphicInfo.getY());
                dockersArrayNode.add((JsonNode)dockNode);
            }
        }
        String targetElementId = association.getTargetRef();
        PlanItem planItem = model.findPlanItem(association.getTargetRef());
        if (planItem == null && (criterion = model.getCriterion(association.getTargetRef())) == null) {
            PlanItem targetPlanItem = model.findPlanItemByPlanItemDefinitionId(association.getTargetRef());
            if (targetPlanItem == null) {
                return;
            }
            targetElementId = targetPlanItem.getId();
        }
        GraphicInfo targetGraphicInfo = model.getGraphicInfo(targetElementId);
        GraphicInfo flowGraphicInfo = (GraphicInfo)graphicInfoList.get(graphicInfoList.size() - 1);
        double diffTopY = Math.abs(flowGraphicInfo.getY() - targetGraphicInfo.getY());
        double diffRightX = Math.abs(flowGraphicInfo.getX() - (targetGraphicInfo.getX() + targetGraphicInfo.getWidth()));
        double diffBottomY = Math.abs(flowGraphicInfo.getY() - (targetGraphicInfo.getY() + targetGraphicInfo.getHeight()));
        dockNode = this.objectMapper.createObjectNode();
        if (diffTopY < 5.0) {
            dockNode.put("x", targetGraphicInfo.getWidth() / 2.0);
            dockNode.put("y", 0.0);
        } else if (diffRightX < 5.0) {
            dockNode.put("x", targetGraphicInfo.getWidth());
            dockNode.put("y", targetGraphicInfo.getHeight() / 2.0);
        } else if (diffBottomY < 5.0) {
            dockNode.put("x", targetGraphicInfo.getWidth() / 2.0);
            dockNode.put("y", targetGraphicInfo.getHeight());
        } else {
            dockNode.put("x", 0.0);
            dockNode.put("y", targetGraphicInfo.getHeight() / 2.0);
        }
        dockersArrayNode.add((JsonNode)dockNode);
        flowNode.set("dockers", (JsonNode)dockersArrayNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        outgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(targetElementId));
        flowNode.set("outgoing", (JsonNode)outgoingArrayNode);
        flowNode.set("target", (JsonNode)CmmnJsonConverterUtil.createResourceNode(targetElementId));
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", association.getId());
        propertiesNode.put("transitionevent", association.getTransitionEvent());
        flowNode.set("properties", (JsonNode)propertiesNode);
        shapesArrayNode.add((JsonNode)flowNode);
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext) {
    }

    protected Association convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        Association association = new Association();
        association.setId(CmmnJsonConverterUtil.getElementId(elementNode));
        association.setTransitionEvent(CmmnJsonConverterUtil.getPropertyValueAsString("transitionevent", elementNode));
        String sourceRef = CmmnJsonConverterUtil.lookForSourceRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes"));
        if (sourceRef != null) {
            association.setSourceRef(sourceRef);
            String targetId = elementNode.get("target").get("resourceId").asText();
            association.setTargetRef(CmmnJsonConverterUtil.getElementId(shapeMap.get(targetId)));
        }
        return association;
    }
}

