/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.AbstractEventListenerJsonConverter;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.CmmnModelJsonConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.GenericEventListener;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;

public class GenericEventListenerJsonConverter
extends AbstractEventListenerJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        GenericEventListenerJsonConverter.fillJsonTypes(convertersToCmmnMap);
        GenericEventListenerJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("EventListener", GenericEventListenerJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(GenericEventListener.class, GenericEventListenerJsonConverter.class);
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext) {
        this.convertCommonElementToJson(elementNode, propertiesNode, baseElement);
        GenericEventListener genericEventListener = (GenericEventListener)((PlanItem)baseElement).getPlanItemDefinition();
        if (StringUtils.isNotEmpty((CharSequence)genericEventListener.getEventType())) {
            propertiesNode.put("eventkey", genericEventListener.getEventType());
            this.setPropertyValue("eventname", this.getExtensionValue("eventName", (PlanItemDefinition)genericEventListener), propertiesNode);
            CmmnModelJsonConverterUtil.addEventOutParameters((List)genericEventListener.getExtensionElements().get("eventOutParameter"), propertiesNode, this.objectMapper);
            CmmnModelJsonConverterUtil.addEventCorrelationParameters((List)genericEventListener.getExtensionElements().get("eventCorrelationParameter"), propertiesNode, this.objectMapper);
            this.setPropertyValue("channelkey", this.getExtensionValue("channelKey", (PlanItemDefinition)genericEventListener), propertiesNode);
            this.setPropertyValue("channelname", this.getExtensionValue("channelName", (PlanItemDefinition)genericEventListener), propertiesNode);
            this.setPropertyValue("channeltype", this.getExtensionValue("channelType", (PlanItemDefinition)genericEventListener), propertiesNode);
            this.setPropertyValue("channeldestination", this.getExtensionValue("channelDestination", (PlanItemDefinition)genericEventListener), propertiesNode);
            String keyDetectionType = this.getExtensionValue("keyDetectionType", (PlanItemDefinition)genericEventListener);
            String keyDetectionValue = this.getExtensionValue("keyDetectionValue", (PlanItemDefinition)genericEventListener);
            if (StringUtils.isNotEmpty((CharSequence)keyDetectionType) && StringUtils.isNotEmpty((CharSequence)keyDetectionValue)) {
                if ("fixedValue".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionfixedvalue", keyDetectionValue, propertiesNode);
                } else if ("jsonField".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonfield", keyDetectionValue, propertiesNode);
                } else if ("jsonPointer".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonpointer", keyDetectionValue, propertiesNode);
                }
            }
        }
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        GenericEventListener genericEventListener = new GenericEventListener();
        this.convertCommonJsonToElement(elementNode, (EventListener)genericEventListener);
        String eventType = CmmnJsonConverterUtil.getPropertyValueAsString("eventkey", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)eventType)) {
            genericEventListener.setEventType(eventType);
            this.addFlowableExtensionElementWithValue("eventName", this.getPropertyValueAsString("eventname", elementNode), (PlanItemDefinition)genericEventListener);
            CmmnModelJsonConverterUtil.convertJsonToOutParameters(elementNode, (BaseElement)genericEventListener);
            CmmnModelJsonConverterUtil.convertJsonToCorrelationParameters(elementNode, "eventCorrelationParameter", (BaseElement)genericEventListener);
            this.addFlowableExtensionElementWithValue("channelKey", this.getPropertyValueAsString("channelkey", elementNode), (PlanItemDefinition)genericEventListener);
            this.addFlowableExtensionElementWithValue("channelName", this.getPropertyValueAsString("channelname", elementNode), (PlanItemDefinition)genericEventListener);
            this.addFlowableExtensionElementWithValue("channelType", this.getPropertyValueAsString("channeltype", elementNode), (PlanItemDefinition)genericEventListener);
            this.addFlowableExtensionElementWithValue("channelDestination", this.getPropertyValueAsString("channeldestination", elementNode), (PlanItemDefinition)genericEventListener);
            String fixedValue = this.getPropertyValueAsString("keydetectionfixedvalue", elementNode);
            String jsonField = this.getPropertyValueAsString("keydetectionjsonfield", elementNode);
            String jsonPointer = this.getPropertyValueAsString("keydetectionjsonpointer", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)fixedValue)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "fixedValue", (PlanItemDefinition)genericEventListener);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", fixedValue, (PlanItemDefinition)genericEventListener);
            } else if (StringUtils.isNotEmpty((CharSequence)jsonField)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "jsonField", (PlanItemDefinition)genericEventListener);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", jsonField, (PlanItemDefinition)genericEventListener);
            } else if (StringUtils.isNotEmpty((CharSequence)jsonPointer)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "jsonPointer", (PlanItemDefinition)genericEventListener);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", jsonPointer, (PlanItemDefinition)genericEventListener);
            }
        }
        return genericEventListener;
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "EventListener";
    }
}

