/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.constants.CmmnStencilConstants;
import org.flowable.cmmn.editor.constants.EditorJsonConstants;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.CollectionUtils;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.ExtensionAttribute;
import org.flowable.cmmn.model.ExtensionElement;

public class CmmnModelJsonConverterUtil
implements EditorJsonConstants,
CmmnStencilConstants {
    public static void addEventOutParameters(List<ExtensionElement> eventParameterElements, ObjectNode propertiesNode, ObjectMapper objectMapper) {
        if (CollectionUtils.isEmpty(eventParameterElements)) {
            return;
        }
        ObjectNode valueNode = objectMapper.createObjectNode();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (ExtensionElement element : eventParameterElements) {
            ObjectNode itemNode = objectMapper.createObjectNode();
            itemNode.put("eventName", element.getAttributeValue(null, "source"));
            itemNode.put("eventType", element.getAttributeValue(null, "sourceType"));
            itemNode.put("variableName", element.getAttributeValue(null, "target"));
            arrayNode.add((JsonNode)itemNode);
        }
        valueNode.set("outParameters", (JsonNode)arrayNode);
        propertiesNode.set("eventoutparameters", (JsonNode)valueNode);
    }

    public static void addEventInParameters(List<ExtensionElement> eventParameterElements, ObjectNode propertiesNode, ObjectMapper objectMapper) {
        if (CollectionUtils.isEmpty(eventParameterElements)) {
            return;
        }
        ObjectNode valueNode = objectMapper.createObjectNode();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (ExtensionElement element : eventParameterElements) {
            ObjectNode itemNode = objectMapper.createObjectNode();
            itemNode.put("variableName", element.getAttributeValue(null, "source"));
            itemNode.put("eventName", element.getAttributeValue(null, "target"));
            itemNode.put("eventType", element.getAttributeValue(null, "targetType"));
            arrayNode.add((JsonNode)itemNode);
        }
        valueNode.set("inParameters", (JsonNode)arrayNode);
        propertiesNode.set("eventinparameters", (JsonNode)valueNode);
    }

    public static void addEventCorrelationParameters(List<ExtensionElement> eventParameterElements, ObjectNode propertiesNode, ObjectMapper objectMapper) {
        if (CollectionUtils.isEmpty(eventParameterElements)) {
            return;
        }
        ObjectNode valueNode = objectMapper.createObjectNode();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (ExtensionElement element : eventParameterElements) {
            ObjectNode itemNode = objectMapper.createObjectNode();
            itemNode.put("name", element.getAttributeValue(null, "name"));
            itemNode.put("type", element.getAttributeValue(null, "nameType"));
            itemNode.put("value", element.getAttributeValue(null, "value"));
            arrayNode.add((JsonNode)itemNode);
        }
        valueNode.set("correlationParameters", (JsonNode)arrayNode);
        propertiesNode.set("eventcorrelationparameters", (JsonNode)valueNode);
    }

    public static void convertJsonToOutParameters(JsonNode objectNode, BaseElement baseElement) {
        JsonNode parametersNode = CmmnModelJsonConverterUtil.getProperty("eventoutparameters", objectNode);
        if ((parametersNode = CmmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)) != null && parametersNode.get("outParameters") != null) {
            parametersNode = CmmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode);
            JsonNode parameterArray = parametersNode.get("outParameters");
            for (JsonNode parameterNode : parameterArray) {
                if (parameterNode.get("eventName") == null || parameterNode.get("eventName").isNull()) continue;
                ExtensionElement extensionElement = CmmnModelJsonConverterUtil.addFlowableExtensionElement("eventOutParameter", baseElement);
                String eventName = parameterNode.get("eventName").asText();
                String eventType = parameterNode.get("eventType").asText();
                String variableName = parameterNode.get("variableName").asText();
                CmmnModelJsonConverterUtil.addExtensionAttribute("source", eventName, extensionElement);
                CmmnModelJsonConverterUtil.addExtensionAttribute("sourceType", eventType, extensionElement);
                CmmnModelJsonConverterUtil.addExtensionAttribute("target", variableName, extensionElement);
            }
        }
    }

    public static void convertJsonToInParameters(JsonNode objectNode, BaseElement baseElement) {
        JsonNode parametersNode = CmmnModelJsonConverterUtil.getProperty("eventinparameters", objectNode);
        if ((parametersNode = CmmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)) != null && parametersNode.get("inParameters") != null) {
            parametersNode = CmmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode);
            JsonNode parameterArray = parametersNode.get("inParameters");
            for (JsonNode parameterNode : parameterArray) {
                if (parameterNode.get("variableName") == null || parameterNode.get("variableName").isNull()) continue;
                ExtensionElement extensionElement = CmmnModelJsonConverterUtil.addFlowableExtensionElement("eventInParameter", baseElement);
                String variableName = parameterNode.get("variableName").asText();
                String eventName = parameterNode.get("eventName").asText();
                String eventType = parameterNode.get("eventType").asText();
                CmmnModelJsonConverterUtil.addExtensionAttribute("source", variableName, extensionElement);
                CmmnModelJsonConverterUtil.addExtensionAttribute("target", eventName, extensionElement);
                CmmnModelJsonConverterUtil.addExtensionAttribute("targetType", eventType, extensionElement);
            }
        }
    }

    public static void convertJsonToCorrelationParameters(JsonNode objectNode, String correlationPropertyName, BaseElement baseElement) {
        JsonNode parametersNode = CmmnModelJsonConverterUtil.getProperty("eventcorrelationparameters", objectNode);
        if ((parametersNode = CmmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)) != null && parametersNode.get("correlationParameters") != null) {
            parametersNode = CmmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode);
            JsonNode parameterArray = parametersNode.get("correlationParameters");
            for (JsonNode parameterNode : parameterArray) {
                if (parameterNode.get("name") == null || parameterNode.get("name").isNull()) continue;
                ExtensionElement extensionElement = CmmnModelJsonConverterUtil.addFlowableExtensionElement(correlationPropertyName, baseElement);
                String name = parameterNode.get("name").asText();
                String type = parameterNode.get("type").asText();
                String value = parameterNode.get("value").asText();
                CmmnModelJsonConverterUtil.addExtensionAttribute("name", name, extensionElement);
                CmmnModelJsonConverterUtil.addExtensionAttribute("type", type, extensionElement);
                CmmnModelJsonConverterUtil.addExtensionAttribute("value", value, extensionElement);
            }
        }
    }

    public static String getPropertyValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = CmmnModelJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !"null".equalsIgnoreCase(propertyNode.asText())) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static boolean getPropertyValueAsBoolean(String name, JsonNode objectNode) {
        return CmmnModelJsonConverterUtil.getPropertyValueAsBoolean(name, objectNode, false);
    }

    public static boolean getPropertyValueAsBoolean(String name, JsonNode objectNode, boolean defaultValue) {
        boolean result = defaultValue;
        String stringValue = CmmnModelJsonConverterUtil.getPropertyValueAsString(name, objectNode);
        if ("Yes".equalsIgnoreCase(stringValue) || "true".equalsIgnoreCase(stringValue)) {
            result = true;
        } else if ("No".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
            result = false;
        }
        return result;
    }

    public static List<String> getPropertyValueAsList(String name, JsonNode objectNode) {
        ArrayList<String> resultList = new ArrayList<String>();
        JsonNode propertyNode = CmmnModelJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !"null".equalsIgnoreCase(propertyNode.asText())) {
            String[] valueList;
            String propertyValue = propertyNode.asText();
            for (String value : valueList = propertyValue.split(",")) {
                resultList.add(value.trim());
            }
        }
        return resultList;
    }

    public static JsonNode getProperty(String name, JsonNode objectNode) {
        JsonNode propertyNode = null;
        if (objectNode.get("properties") != null) {
            JsonNode propertiesNode = objectNode.get("properties");
            propertyNode = propertiesNode.get(name);
        }
        return propertyNode;
    }

    public static String getPropertyFormKey(JsonNode elementNode, Map<String, String> formMap) {
        String formKey = CmmnModelJsonConverterUtil.getPropertyValueAsString("formkeydefinition", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)formKey)) {
            return formKey;
        }
        JsonNode formReferenceNode = CmmnModelJsonConverterUtil.getProperty("formreference", elementNode);
        if (formReferenceNode != null && formReferenceNode.get("id") != null && formMap != null && formMap.containsKey(formReferenceNode.get("id").asText())) {
            return formMap.get(formReferenceNode.get("id").asText());
        }
        return null;
    }

    public static ExtensionElement addFlowableExtensionElement(String name, BaseElement baseElement) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setName(name);
        extensionElement.setNamespace("http://flowable.org/cmmn");
        extensionElement.setNamespacePrefix("flowable");
        baseElement.addExtensionElement(extensionElement);
        return extensionElement;
    }

    public static void addExtensionAttribute(String name, String value, ExtensionElement extensionElement) {
        ExtensionAttribute attribute = new ExtensionAttribute(name);
        attribute.setValue(value);
        extensionElement.addAttribute(attribute);
    }

    protected static List<JsonLookupResult> getCmmnModelChildShapesPropertyValues(JsonNode editorJsonNode, String propertyName, List<String> allowedStencilTypes) {
        ArrayList<JsonLookupResult> result = new ArrayList<JsonLookupResult>();
        CmmnModelJsonConverterUtil.internalGetCmmnChildShapePropertyValues(editorJsonNode, propertyName, allowedStencilTypes, result);
        return result;
    }

    protected static void internalGetCmmnChildShapePropertyValues(JsonNode editorJsonNode, String propertyName, List<String> allowedStencilTypes, List<JsonLookupResult> result) {
        JsonNode childShapesNode = editorJsonNode.get("childShapes");
        if (childShapesNode != null && childShapesNode.isArray()) {
            ArrayNode childShapesArrayNode = (ArrayNode)childShapesNode;
            for (JsonNode childShapeNode : childShapesArrayNode) {
                JsonNode properties;
                String childShapeNodeStencilId = CmmnJsonConverterUtil.getStencilId(childShapeNode);
                boolean readPropertiesNode = allowedStencilTypes.contains(childShapeNodeStencilId);
                if (readPropertiesNode && (properties = childShapeNode.get("properties")) != null && properties.has(propertyName)) {
                    JsonNode nameNode = properties.get("name");
                    JsonNode propertyNode = properties.get(propertyName);
                    result.add(new JsonLookupResult(CmmnJsonConverterUtil.getElementId(childShapeNode), nameNode != null ? nameNode.asText() : null, propertyNode));
                }
                if (!childShapeNode.has("childShapes")) continue;
                CmmnModelJsonConverterUtil.internalGetCmmnChildShapePropertyValues(childShapeNode, propertyName, allowedStencilTypes, result);
            }
        }
    }

    public static List<JsonLookupResult> getCmmnModelFormReferences(JsonNode editorJsonNode) {
        ArrayList<String> allowedStencilTypes = new ArrayList<String>();
        allowedStencilTypes.add("HumanTask");
        allowedStencilTypes.add("CasePlanModel");
        return CmmnModelJsonConverterUtil.getCmmnModelChildShapesPropertyValues(editorJsonNode, "formreference", allowedStencilTypes);
    }

    public static List<JsonLookupResult> getCmmnModelDecisionTableReferences(JsonNode editorJsonNode) {
        ArrayList<String> allowedStencilTypes = new ArrayList<String>();
        allowedStencilTypes.add("DecisionTask");
        return CmmnModelJsonConverterUtil.getCmmnModelChildShapesPropertyValues(editorJsonNode, "decisiontaskdecisiontablereference", allowedStencilTypes);
    }

    public static List<JsonLookupResult> getCmmnModelCaseReferences(JsonNode editorJsonNode) {
        ArrayList<String> allowedStencilTypes = new ArrayList<String>();
        allowedStencilTypes.add("CaseTask");
        return CmmnModelJsonConverterUtil.getCmmnModelChildShapesPropertyValues(editorJsonNode, "casetaskcasereference", allowedStencilTypes);
    }

    public static List<JsonLookupResult> getCmmnModelProcessReferences(JsonNode editorJsonNode) {
        ArrayList<String> allowedStencilTypes = new ArrayList<String>();
        allowedStencilTypes.add("ProcessTask");
        return CmmnModelJsonConverterUtil.getCmmnModelChildShapesPropertyValues(editorJsonNode, "processtaskprocessreference", allowedStencilTypes);
    }

    public static List<JsonLookupResult> getCmmnModelDecisionReferences(JsonNode editorJsonNode) {
        ArrayList<String> allowedStencilTypes = new ArrayList<String>();
        allowedStencilTypes.add("DecisionTask");
        return CmmnModelJsonConverterUtil.getCmmnModelChildShapesPropertyValues(editorJsonNode, "decisiontaskdecisiontablereference", allowedStencilTypes);
    }

    public static List<JsonNode> filterOutJsonNodes(List<JsonLookupResult> lookupResults) {
        ArrayList<JsonNode> jsonNodes = new ArrayList<JsonNode>(lookupResults.size());
        for (JsonLookupResult lookupResult : lookupResults) {
            jsonNodes.add(lookupResult.getJsonNode());
        }
        return jsonNodes;
    }

    public static class JsonLookupResult {
        private String id;
        private String name;
        private JsonNode jsonNode;

        public JsonLookupResult(String id, String name, JsonNode jsonNode) {
            this(name, jsonNode);
            this.id = id;
        }

        public JsonLookupResult(String name, JsonNode jsonNode) {
            this.name = name;
            this.jsonNode = jsonNode;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public JsonNode getJsonNode() {
            return this.jsonNode;
        }

        public void setJsonNode(JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }
    }
}

