/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.cmmn.rest.service.api.repository.BaseCaseDefinitionResource;
import org.flowable.cmmn.rest.service.api.repository.FormDefinitionResponse;
import org.flowable.form.api.FormDefinition;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Definitions"}, description="Manage Case Definitions", authorizations={@Authorization(value="basicAuth")})
public class CaseDefinitionFormDefinitionCollectionResource
extends BaseCaseDefinitionResource {
    @ApiOperation(value="List form definitions for a case definition", nickname="listCaseDefinitionFormDefinitions", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case definition was found and the form definitions are returned.", response=FormDefinition.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/form-definitions"}, produces={"application/json"})
    public List<FormDefinitionResponse> getFormDefinitionsForCaseDefinition(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId, HttpServletRequest request) {
        List formDefinitions = this.repositoryService.getFormDefinitionsForCaseDefinition(caseDefinitionId);
        return this.restResponseFactory.createFormDefinitionResponseList(formDefinitions, caseDefinitionId);
    }
}

