/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.entity.ContentType;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.repository.DeploymentResourceResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Cmmn Deployment"}, description="Manage Cmmn Deployment", authorizations={@Authorization(value="basicAuth")})
public class DeploymentResourceResource {
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected CmmnRepositoryService repositoryService;

    @ApiOperation(value="Get a deployment resource", tags={"Deployment"}, notes="Replace ** by ResourceId")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both deployment and resource have been found and the resource has been returned."), @ApiResponse(code=404, message="Indicates the requested deployment was not found or there is no resource with the given id present in the deployment. The status-description contains additional information.")})
    @GetMapping(value={"/cmmn-repository/deployments/{deploymentId}/resources/**"}, produces={"application/json"})
    public DeploymentResourceResponse getDeploymentResource(@ApiParam(name="deploymentId") @PathVariable(value="deploymentId") String deploymentId, HttpServletRequest request) {
        CmmnDeployment deployment = (CmmnDeployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.");
        }
        String pathInfo = request.getPathInfo();
        String resourceName = pathInfo.replace("/cmmn-repository/deployments/" + deploymentId + "/resources/", "");
        List resourceList = this.repositoryService.getDeploymentResourceNames(deploymentId);
        if (resourceList.contains(resourceName)) {
            String contentType = null;
            contentType = resourceName.toLowerCase().endsWith(".cmmn") ? ContentType.TEXT_XML.getMimeType() : this.contentTypeResolver.resolveContentType(resourceName);
            DeploymentResourceResponse response = this.restResponseFactory.createDeploymentResourceResponse(deploymentId, resourceName, contentType);
            return response;
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with id '" + resourceName + "' in deployment '" + deploymentId + "'.");
    }
}

