/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.caze;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.rest.service.api.RestActionRequest;
import org.flowable.cmmn.rest.service.api.runtime.caze.BaseCaseInstanceResource;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstanceResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Instances"}, description="Manage Case Instances", authorizations={@Authorization(value="basicAuth")})
public class CaseInstanceResource
extends BaseCaseInstanceResource {
    @ApiOperation(value="Get a case instance", tags={"Case Instances"}, nickname="getCaseInstance")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case instance was found and returned."), @ApiResponse(code=404, message="Indicates the requested case instance was not found.")})
    @GetMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}"}, produces={"application/json"})
    public CaseInstanceResponse getCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, HttpServletRequest request) {
        return this.restResponseFactory.createCaseInstanceResponse(this.getCaseInstanceFromRequest(caseInstanceId));
    }

    @ApiOperation(value="Execute an action on a case instance", tags={"Plan Item Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case instance was found and the action is performed."), @ApiResponse(code=204, message="Indicates the case was found, the action was performed and the action caused the case instance to end."), @ApiResponse(code=400, message="Indicates an illegal action was requested, required parameters are missing in the request body or illegal variables are passed in. Status description contains additional information about the error."), @ApiResponse(code=404, message="Indicates the case instance was not found.")})
    @PutMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}"}, produces={"application/json"})
    public CaseInstanceResponse performCaseInstanceAction(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, @RequestBody RestActionRequest actionRequest, HttpServletRequest request, HttpServletResponse response) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequest(caseInstanceId);
        if (!"evaluateCriteria".equals(actionRequest.getAction())) {
            throw new FlowableIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
        }
        this.runtimeService.evaluateCriteria(caseInstance.getId());
        caseInstance = (CaseInstance)this.runtimeService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult();
        if (caseInstance == null) {
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return null;
        }
        return this.restResponseFactory.createCaseInstanceResponse(caseInstance);
    }

    @ApiOperation(value="Delete a case instance", tags={"Case Instances"}, nickname="deleteCaseInstance")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the case instance was found and deleted. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested case instance was not found.")})
    @DeleteMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}"})
    public void deleteProcessInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, @RequestParam(value="deleteReason", required=false) String deleteReason, HttpServletResponse response) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequest(caseInstanceId);
        this.runtimeService.terminateCaseInstance(caseInstance.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

