/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.history.caze;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletResponse;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.history.caze.HistoricCaseInstanceBaseResource;
import org.flowable.cmmn.rest.service.api.history.caze.HistoricCaseInstanceResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Case"}, description="Manage History Case Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricCaseInstanceResource
extends HistoricCaseInstanceBaseResource {
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected CmmnRepositoryService cmmnRepositoryService;
    @Autowired
    protected CmmnHistoryService cmmnhistoryService;
    @Autowired
    protected CmmnRuntimeService cmmnRuntimeService;

    @ApiOperation(value="Get a historic case instance", tags={"History Case"}, nickname="getHistoricCaseInstance")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that the historic process instances could be found."), @ApiResponse(code=404, message="Indicates that the historic process instances could not be found.")})
    @GetMapping(value={"/cmmn-history/historic-case-instances/{caseInstanceId}"}, produces={"application/json"})
    public HistoricCaseInstanceResponse getCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId) {
        HistoricCaseInstanceResponse caseInstanceResponse = this.restResponseFactory.createHistoricCaseInstanceResponse(this.getHistoricCaseInstanceFromRequest(caseInstanceId));
        CaseDefinition caseDefinition = (CaseDefinition)this.cmmnRepositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstanceResponse.getCaseDefinitionId()).singleResult();
        if (caseDefinition != null) {
            caseInstanceResponse.setCaseDefinitionName(caseDefinition.getName());
            caseInstanceResponse.setCaseDefinitionDescription(caseDefinition.getDescription());
        }
        return caseInstanceResponse;
    }

    @ApiOperation(value=" Delete a historic case instance", tags={"History Case"}, nickname="deleteHistoricCaseInstance")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates that the historic process instance was deleted."), @ApiResponse(code=404, message="Indicates that the historic process instance could not be found.")})
    @DeleteMapping(value={"/cmmn-history/historic-case-instances/{caseInstanceId}"})
    public void deleteCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, HttpServletResponse response) {
        HistoricCaseInstance caseInstance = this.getHistoricCaseInstanceFromRequest(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteHistoricCase(caseInstance);
        }
        this.cmmnhistoryService.deleteHistoricCaseInstance(caseInstance.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

