/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.caze;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemDefinitionType;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.rest.service.api.RestActionRequest;
import org.flowable.cmmn.rest.service.api.history.caze.StageResponse;
import org.flowable.cmmn.rest.service.api.runtime.caze.BaseCaseInstanceResource;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstanceResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Instances"}, description="Manage Case Instances", authorizations={@Authorization(value="basicAuth")})
public class CaseInstanceResource
extends BaseCaseInstanceResource {
    @ApiOperation(value="Get a case instance", tags={"Case Instances"}, nickname="getCaseInstance")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case instance was found and returned."), @ApiResponse(code=404, message="Indicates the requested case instance was not found.")})
    @GetMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}"}, produces={"application/json"})
    public CaseInstanceResponse getCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, HttpServletRequest request) {
        CaseInstanceResponse caseInstanceResponse = this.restResponseFactory.createCaseInstanceResponse(this.getCaseInstanceFromRequest(caseInstanceId));
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstanceResponse.getCaseDefinitionId()).singleResult();
        if (caseDefinition != null) {
            caseInstanceResponse.setCaseDefinitionName(caseDefinition.getName());
            caseInstanceResponse.setCaseDefinitionDescription(caseDefinition.getDescription());
        }
        return caseInstanceResponse;
    }

    @ApiOperation(value="Execute an action on a case instance", tags={"Plan Item Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case instance was found and the action is performed."), @ApiResponse(code=204, message="Indicates the case was found, the action was performed and the action caused the case instance to end."), @ApiResponse(code=400, message="Indicates an illegal action was requested, required parameters are missing in the request body or illegal variables are passed in. Status description contains additional information about the error."), @ApiResponse(code=404, message="Indicates the case instance was not found.")})
    @PutMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}"}, produces={"application/json"})
    public CaseInstanceResponse performCaseInstanceAction(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, @RequestBody RestActionRequest actionRequest, HttpServletRequest request, HttpServletResponse response) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequest(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.doCaseInstanceAction(caseInstance, actionRequest);
        }
        if (!"evaluateCriteria".equals(actionRequest.getAction())) {
            throw new FlowableIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
        }
        this.runtimeService.evaluateCriteria(caseInstance.getId());
        caseInstance = (CaseInstance)this.runtimeService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult();
        if (caseInstance == null) {
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return null;
        }
        return this.restResponseFactory.createCaseInstanceResponse(caseInstance);
    }

    @ApiOperation(value="Delete a case instance", tags={"Case Instances"}, nickname="deleteCaseInstance")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the case instance was found and deleted. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested case instance was not found.")})
    @DeleteMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}"})
    public void deleteCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, @RequestParam(value="deleteReason", required=false) String deleteReason, HttpServletResponse response) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequest(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteCaseInstance(caseInstance);
        }
        this.runtimeService.terminateCaseInstance(caseInstance.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @GetMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}/stage-overview"}, produces={"application/json"})
    public List<StageResponse> getStageOverview(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId) {
        CaseInstance caseInstance = (CaseInstance)this.runtimeService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id " + caseInstanceId);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessStageOverview(caseInstance);
        }
        List stagePlanItemInstances = ((PlanItemInstanceQuery)this.runtimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).planItemDefinitionType(PlanItemDefinitionType.STAGE).includeEnded().orderByEndTime().asc()).list();
        CmmnModel cmmnModel = this.repositoryService.getCmmnModel(caseInstance.getCaseDefinitionId());
        List stages = cmmnModel.getPrimaryCase().getPlanModel().findPlanItemDefinitionsOfType(Stage.class, true);
        stages.sort(Comparator.comparing(Stage::getDisplayOrder, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(stage -> this.getPlanItemInstanceEndTime(stagePlanItemInstances, (Stage)stage), Comparator.nullsLast(Comparator.naturalOrder())));
        ArrayList<StageResponse> stageResponses = new ArrayList<StageResponse>(stages.size());
        for (Stage stage2 : stages) {
            if (!stage2.isIncludeInStageOverview()) continue;
            StageResponse stageResponse = new StageResponse(stage2.getId(), stage2.getName());
            Optional<PlanItemInstance> planItemInstance = this.getPlanItemInstance(stagePlanItemInstances, stage2);
            if (planItemInstance.isPresent()) {
                stageResponse.setEnded(planItemInstance.get().getEndedTime() != null);
                stageResponse.setCurrent("active".equals(planItemInstance.get().getState()));
            }
            stageResponses.add(stageResponse);
        }
        return stageResponses;
    }

    protected Date getPlanItemInstanceEndTime(List<PlanItemInstance> stagePlanItemInstances, Stage stage) {
        return this.getPlanItemInstance(stagePlanItemInstances, stage).map(PlanItemInstance::getEndedTime).orElse(null);
    }

    protected Optional<PlanItemInstance> getPlanItemInstance(List<PlanItemInstance> stagePlanItemInstances, Stage stage) {
        PlanItemInstance planItemInstance = null;
        for (PlanItemInstance p : stagePlanItemInstances) {
            if (!p.getPlanItemDefinitionId().equals(stage.getId())) continue;
            if (p.getEndedTime() == null) {
                planItemInstance = p;
                continue;
            }
            if (planItemInstance != null) continue;
            planItemInstance = p;
        }
        return Optional.ofNullable(planItemInstance);
    }
}

