/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.history.milestone;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import org.flowable.cmmn.api.history.HistoricMilestoneInstance;
import org.flowable.cmmn.rest.service.api.history.milestone.HistoricMilestoneInstanceBaseResource;
import org.flowable.cmmn.rest.service.api.history.milestone.HistoricMilestoneInstanceResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Milestone"}, description="Manage History Milestone Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricMilestoneInstanceResource
extends HistoricMilestoneInstanceBaseResource {
    @ApiOperation(value="Get a historic milestone instance by id", tags={"History Milestone"}, nickname="getHistoricMilestoneInstanceById")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that the historic milestone instances could be found."), @ApiResponse(code=404, message="Indicates that the historic milestone instances could not be found.")})
    @GetMapping(value={"/cmmn-history/historic-milestone-instances/{milestoneInstanceId}"}, produces={"application/json"})
    public HistoricMilestoneInstanceResponse getMilestoneInstance(@ApiParam(name="milestoneInstanceId") @PathVariable String milestoneInstanceId, HttpServletRequest request) {
        HistoricMilestoneInstance milestoneInstance = (HistoricMilestoneInstance)this.historyService.createHistoricMilestoneInstanceQuery().milestoneInstanceId(milestoneInstanceId).singleResult();
        if (milestoneInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a milestone instance with id '" + milestoneInstanceId + "'.", HistoricMilestoneInstance.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryMilestoneInfoById(milestoneInstance);
        }
        return this.restResponseFactory.createHistoricMilestoneInstanceResponse(milestoneInstance);
    }
}

