/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.history.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.rest.service.api.CmmnFormHandlerRestApiInterceptor;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.FormModelResponse;
import org.flowable.cmmn.rest.service.api.history.task.HistoricTaskInstanceBaseResource;
import org.flowable.cmmn.rest.service.api.history.task.HistoricTaskInstanceResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.form.api.FormInfo;
import org.flowable.form.model.SimpleFormModel;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History Task"}, description="Manage History Task Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricTaskInstanceResource
extends HistoricTaskInstanceBaseResource {
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected CmmnHistoryService historyService;
    @Autowired
    protected CmmnTaskService taskService;
    @Autowired(required=false)
    protected CmmnFormHandlerRestApiInterceptor formHandlerRestApiInterceptor;

    @ApiOperation(value="Get a single historic task instance", tags={"History Task"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that the historic task instances could be found."), @ApiResponse(code=404, message="Indicates that the historic task instances could not be found.")})
    @GetMapping(value={"/cmmn-history/historic-task-instances/{taskId}"}, produces={"application/json"})
    public HistoricTaskInstanceResponse getTaskInstance(@ApiParam(name="taskId") @PathVariable String taskId, HttpServletRequest request) {
        return this.restResponseFactory.createHistoricTaskInstanceResponse(this.getHistoricTaskInstanceFromRequest(taskId));
    }

    @ApiOperation(value="Delete a historic task instance", tags={"History Task"}, notes="")
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates that the historic task instance was deleted."), @ApiResponse(code=404, message="Indicates that the historic task instance could not be found.")})
    @DeleteMapping(value={"/cmmn-history/historic-task-instances/{taskId}"})
    public void deleteTaskInstance(@ApiParam(name="taskId") @PathVariable String taskId, HttpServletResponse response) {
        HistoricTaskInstance task = this.getHistoricTaskInstanceFromRequestWithoutAccessCheck(taskId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteHistoricTask(task);
        }
        this.historyService.deleteHistoricTaskInstance(taskId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ApiOperation(value="Get a historic task instance form", tags={"History Task"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the task form is returned"), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @GetMapping(value={"/cmmn-history/historic-task-instances/{taskId}/form"}, produces={"application/json"})
    public String getTaskForm(@ApiParam(name="taskId") @PathVariable String taskId, HttpServletRequest request) {
        HistoricTaskInstance task = this.getHistoricTaskInstanceFromRequest(taskId);
        if (StringUtils.isEmpty((CharSequence)task.getFormKey())) {
            throw new FlowableIllegalArgumentException("Task has no form defined");
        }
        FormInfo formInfo = this.taskService.getTaskFormModel(task.getId());
        if (this.formHandlerRestApiInterceptor != null) {
            return this.formHandlerRestApiInterceptor.convertHistoricTaskFormInfo(formInfo, task);
        }
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        return this.restResponseFactory.getFormModelString(new FormModelResponse(formInfo, formModel));
    }
}

