/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.management;

import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.rest.service.api.CmmnRestApiInterceptor;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.job.api.DeadLetterJobQuery;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobQuery;
import org.flowable.job.api.SuspendedJobQuery;
import org.flowable.job.api.TimerJobQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class JobBaseResource {
    @Autowired
    protected CmmnManagementService managementService;
    @Autowired(required=false)
    protected CmmnRestApiInterceptor restApiInterceptor;

    protected Job getJobById(String jobId) {
        Job job = (Job)((JobQuery)this.managementService.createJobQuery().jobId(jobId)).singleResult();
        this.validateJob(job, jobId);
        return job;
    }

    protected Job getTimerJobById(String jobId) {
        Job job = (Job)((TimerJobQuery)this.managementService.createTimerJobQuery().jobId(jobId)).singleResult();
        this.validateJob(job, jobId);
        return job;
    }

    protected Job getSuspendedJobById(String jobId) {
        Job job = (Job)((SuspendedJobQuery)this.managementService.createSuspendedJobQuery().jobId(jobId)).singleResult();
        this.validateJob(job, jobId);
        return job;
    }

    protected Job getDeadLetterJobById(String jobId) {
        Job job = (Job)((DeadLetterJobQuery)this.managementService.createDeadLetterJobQuery().jobId(jobId)).singleResult();
        this.validateJob(job, jobId);
        return job;
    }

    protected HistoryJob getHistoryJobById(String jobId) {
        HistoryJob job = (HistoryJob)this.managementService.createHistoryJobQuery().jobId(jobId).singleResult();
        this.validateHistoryJob(job, jobId);
        return job;
    }

    protected void validateJob(Job job, String jobId) {
        if (job == null) {
            throw new FlowableObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessJobInfoById(job);
        }
    }

    protected void validateHistoryJob(HistoryJob job, String jobId) {
        if (job == null) {
            throw new FlowableObjectNotFoundException("Could not find a history job with id '" + jobId + "'.", HistoryJob.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryJobInfoById(job);
        }
    }
}

