/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.caze;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.rest.service.api.engine.variable.RestVariable;
import org.flowable.cmmn.rest.service.api.runtime.caze.BaseCaseInstanceResource;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.exception.FlowableConflictException;
import org.flowable.common.rest.exception.FlowableContentNotSupportedException;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class BaseVariableResource
extends BaseCaseInstanceResource {
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected Environment env;
    protected boolean isSerializableVariableAllowed;

    @PostConstruct
    protected void postConstruct() {
        this.isSerializableVariableAllowed = (Boolean)this.env.getProperty("rest.variables.allow.serializable", Boolean.class, (Object)true);
    }

    protected PlanItemInstance getPlanItemInstanceFromRequest(String planItemInstanceId) {
        PlanItemInstance planItemInstance = (PlanItemInstance)this.runtimeService.createPlanItemInstanceQuery().planItemInstanceId(planItemInstanceId).singleResult();
        if (planItemInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a plan item instance with id '" + planItemInstanceId + "'.");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessPlanItemInstanceInfoById(planItemInstance);
        }
        return planItemInstance;
    }

    public RestVariable getVariableFromRequest(CaseInstance caseInstance, String variableName, boolean includeBinary) {
        if (caseInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a case instance", CaseInstance.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessCaseInstanceVariable(caseInstance, variableName);
        }
        return this.getVariableFromRequestWithoutAccessCheck(caseInstance.getId(), variableName, 3, includeBinary);
    }

    public RestVariable getVariableFromRequest(PlanItemInstance planItemInstance, String variableName, boolean includeBinary) {
        if (planItemInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a plan item instance", CaseInstance.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessPlanItemInstanceVariable(planItemInstance, variableName);
        }
        return this.getVariableFromRequestWithoutAccessCheck(planItemInstance.getId(), variableName, 8, includeBinary);
    }

    protected RestVariable getVariableFromRequestWithoutAccessCheck(String instanceId, String variableName, int variableType, boolean includeBinary) {
        Object value = null;
        if (variableType == 8) {
            value = this.runtimeService.getLocalVariable(instanceId, variableName);
        } else if (variableType == 3) {
            value = this.runtimeService.getVariable(instanceId, variableName);
        } else {
            throw new FlowableIllegalArgumentException("Unknown variable type " + variableType);
        }
        if (value == null) {
            if (variableType == 8) {
                throw new FlowableObjectNotFoundException("Plan item instance '" + instanceId + "' doesn't have a variable with name: '" + variableName + "'.", VariableInstance.class);
            }
            throw new FlowableObjectNotFoundException("Case instance '" + instanceId + "' doesn't have a variable with name: '" + variableName + "'.", VariableInstance.class);
        }
        return this.constructRestVariable(variableName, value, instanceId, variableType, includeBinary, null);
    }

    protected byte[] getVariableDataByteArray(CaseInstance caseInstance, String variableName, HttpServletResponse response) {
        RestVariable variable = this.getVariableFromRequest(caseInstance, variableName, true);
        return this.restVariableDataToRestResponse(variable, response);
    }

    protected byte[] getVariableDataByteArray(PlanItemInstance planItemInstance, String variableName, HttpServletResponse response) {
        RestVariable variable = this.getVariableFromRequest(planItemInstance, variableName, true);
        return this.restVariableDataToRestResponse(variable, response);
    }

    protected byte[] restVariableDataToRestResponse(RestVariable variable, HttpServletResponse response) {
        byte[] result;
        block4: {
            result = null;
            try {
                if ("binary".equals(variable.getType())) {
                    result = (byte[])variable.getValue();
                    response.setContentType("application/octet-stream");
                    break block4;
                }
                if ("serializable".equals(variable.getType())) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    ObjectOutputStream outputStream = new ObjectOutputStream(buffer);
                    outputStream.writeObject(variable.getValue());
                    outputStream.close();
                    result = buffer.toByteArray();
                    response.setContentType("application/x-java-serialized-object");
                    break block4;
                }
                throw new FlowableObjectNotFoundException("The variable does not have a binary data stream.", null);
            }
            catch (IOException ioe) {
                throw new FlowableException("Error getting variable " + variable.getName(), (Throwable)ioe);
            }
        }
        return result;
    }

    protected RestVariable constructRestVariable(String variableName, Object value, String caseInstanceId, int variableType, boolean includeBinary, RestVariable.RestVariableScope scope) {
        return this.restResponseFactory.createRestVariable(variableName, value, scope, caseInstanceId, variableType, includeBinary);
    }

    protected List<RestVariable> processCaseVariables(CaseInstance caseInstance) {
        List<RestVariable> variables = this.addVariables(caseInstance);
        ArrayList<RestVariable> result = new ArrayList<RestVariable>(variables);
        return result;
    }

    protected Object createVariable(CaseInstance caseInstance, HttpServletRequest request, HttpServletResponse response) {
        return this.createVariable(caseInstance.getId(), 3, request, response, RestVariable.RestVariableScope.GLOBAL, this.createVariableInterceptor(caseInstance));
    }

    protected Object createVariable(PlanItemInstance planItemInstance, HttpServletRequest request, HttpServletResponse response) {
        return this.createVariable(planItemInstance.getId(), 8, request, response, RestVariable.RestVariableScope.LOCAL, this.createVariableInterceptor(planItemInstance));
    }

    protected Object createVariable(String instanceId, int variableType, HttpServletRequest request, HttpServletResponse response, RestVariable.RestVariableScope scope, VariableInterceptor variableInterceptor) {
        Object result = null;
        if (request instanceof MultipartHttpServletRequest) {
            result = this.setBinaryVariable((MultipartHttpServletRequest)request, instanceId, variableType, true, scope, variableInterceptor);
        } else {
            ArrayList<RestVariable> inputVariables = new ArrayList<RestVariable>();
            ArrayList<RestVariable> resultVariables = new ArrayList<RestVariable>();
            result = resultVariables;
            try {
                List variableObjects = (List)this.objectMapper.readValue((InputStream)request.getInputStream(), List.class);
                for (Object restObject : variableObjects) {
                    RestVariable restVariable = (RestVariable)((Object)this.objectMapper.convertValue(restObject, RestVariable.class));
                    inputVariables.add(restVariable);
                }
            }
            catch (Exception e) {
                throw new FlowableIllegalArgumentException("Failed to serialize to a RestVariable instance", (Throwable)e);
            }
            if (inputVariables == null || inputVariables.size() == 0) {
                throw new FlowableIllegalArgumentException("Request didn't contain a list of variables to create.");
            }
            HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
            for (RestVariable var : inputVariables) {
                if (var.getName() == null) {
                    throw new FlowableIllegalArgumentException("Variable name is required");
                }
                Object actualVariableValue = this.restResponseFactory.getVariableValue(var);
                variablesToSet.put(var.getName(), actualVariableValue);
            }
            if (!variablesToSet.isEmpty()) {
                Map setVariables;
                variableInterceptor.createVariables(variablesToSet);
                if (variableType == 8 || scope == RestVariable.RestVariableScope.LOCAL) {
                    this.runtimeService.setLocalVariables(instanceId, variablesToSet);
                    setVariables = this.runtimeService.getLocalVariables(instanceId, variablesToSet.keySet());
                } else {
                    this.runtimeService.setVariables(instanceId, variablesToSet);
                    setVariables = this.runtimeService.getVariables(instanceId, variablesToSet.keySet());
                }
                for (RestVariable inputVariable : inputVariables) {
                    String variableName = inputVariable.getName();
                    Object variableValue = setVariables.get(variableName);
                    resultVariables.add(this.restResponseFactory.createRestVariable(variableName, variableValue, scope, instanceId, variableType, false));
                }
            }
        }
        response.setStatus(HttpStatus.CREATED.value());
        return result;
    }

    protected List<RestVariable> addVariables(CaseInstance caseInstance) {
        Map<String, Object> rawVariables = this.runtimeService.getVariables(caseInstance.getId());
        if (this.restApiInterceptor != null) {
            rawVariables = this.restApiInterceptor.accessCaseInstanceVariables(caseInstance, rawVariables);
        }
        return this.restResponseFactory.createRestVariables(rawVariables, caseInstance.getId(), 3);
    }

    public void deleteAllVariables(CaseInstance caseInstance, HttpServletResponse response) {
        Set<String> currentVariables = this.runtimeService.getVariables(caseInstance.getId()).keySet();
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteCaseInstanceVariables(caseInstance, currentVariables);
        }
        this.runtimeService.removeVariables(caseInstance.getId(), currentVariables);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected RestVariable setSimpleVariable(RestVariable restVariable, String instanceId, boolean isNew, RestVariable.RestVariableScope scope, int variableType, VariableInterceptor variableInterceptor) {
        if (restVariable.getName() == null) {
            throw new FlowableIllegalArgumentException("Variable name is required");
        }
        Object actualVariableValue = this.restResponseFactory.getVariableValue(restVariable);
        this.setVariable(instanceId, restVariable.getName(), actualVariableValue, scope, isNew, variableInterceptor);
        RestVariable variable = this.getVariableFromRequestWithoutAccessCheck(instanceId, restVariable.getName(), variableType, false);
        variable.setVariableScope(scope);
        return variable;
    }

    protected RestVariable setBinaryVariable(MultipartHttpServletRequest request, String instanceId, int responseVariableType, boolean isNew, RestVariable.RestVariableScope scope, VariableInterceptor variableInterceptor) {
        if (request.getFileMap().size() == 0) {
            throw new FlowableIllegalArgumentException("No file content was found in request body.");
        }
        MultipartFile file = request.getFile((String)request.getFileMap().keySet().iterator().next());
        if (file == null) {
            throw new FlowableIllegalArgumentException("No file content was found in request body.");
        }
        String variableScope = null;
        String variableName = null;
        String variableType = null;
        Map paramMap = request.getParameterMap();
        for (String parameterName : paramMap.keySet()) {
            if (((String[])paramMap.get(parameterName)).length <= 0) continue;
            if ("scope".equalsIgnoreCase(parameterName)) {
                variableScope = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if ("name".equalsIgnoreCase(parameterName)) {
                variableName = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if (!"type".equalsIgnoreCase(parameterName)) continue;
            variableType = ((String[])paramMap.get(parameterName))[0];
        }
        try {
            if (variableName == null) {
                throw new FlowableIllegalArgumentException("No variable name was found in request body.");
            }
            if (variableType != null) {
                if (!"binary".equals(variableType) && !"serializable".equals(variableType)) {
                    throw new FlowableIllegalArgumentException("Only 'binary' and 'serializable' are supported as variable type.");
                }
            } else {
                variableType = "binary";
            }
            if (variableScope != null) {
                scope = RestVariable.getScopeFromString(variableScope);
            }
            if (variableType.equals("binary")) {
                byte[] variableBytes = IOUtils.toByteArray((InputStream)file.getInputStream());
                this.setVariable(instanceId, variableName, variableBytes, scope, isNew, variableInterceptor);
            } else if (this.isSerializableVariableAllowed) {
                ObjectInputStream stream = new ObjectInputStream(file.getInputStream());
                Object value = stream.readObject();
                this.setVariable(instanceId, variableName, value, scope, isNew, variableInterceptor);
                stream.close();
            } else {
                throw new FlowableContentNotSupportedException("Serialized objects are not allowed");
            }
            RestVariable restVariable = this.getVariableFromRequestWithoutAccessCheck(instanceId, variableName, responseVariableType, false);
            restVariable.setVariableScope(scope);
            return restVariable;
        }
        catch (IOException ioe) {
            throw new FlowableIllegalArgumentException("Could not process multipart content", (Throwable)ioe);
        }
        catch (ClassNotFoundException ioe) {
            throw new FlowableContentNotSupportedException("The provided body contains a serialized object for which the class was not found: " + ioe.getMessage());
        }
    }

    protected void setVariable(String instanceId, String name, Object value, RestVariable.RestVariableScope scope, boolean isNew, VariableInterceptor variableInterceptor) {
        if (isNew) {
            variableInterceptor.createVariables(Collections.singletonMap(name, value));
        } else {
            variableInterceptor.updateVariables(Collections.singletonMap(name, value));
        }
        if (RestVariable.RestVariableScope.LOCAL == scope) {
            if (isNew && this.runtimeService.hasLocalVariable(instanceId, name)) {
                throw new FlowableConflictException("Local variable '" + name + "' is already present on plan item instance '" + instanceId + "'.");
            }
            this.runtimeService.setLocalVariable(instanceId, name, value);
        } else {
            this.runtimeService.setVariable(instanceId, name, value);
        }
    }

    protected VariableInterceptor createVariableInterceptor(final PlanItemInstance planItemInstance) {
        if (this.restApiInterceptor != null) {
            return new VariableInterceptor(){

                @Override
                public void createVariables(Map<String, Object> variables) {
                    BaseVariableResource.this.restApiInterceptor.createPlanItemInstanceVariables(planItemInstance, variables);
                }

                @Override
                public void updateVariables(Map<String, Object> variables) {
                    BaseVariableResource.this.restApiInterceptor.updatePlanItemInstanceVariables(planItemInstance, variables);
                }
            };
        }
        return NoopVariableInterceptor.INSTANCE;
    }

    protected VariableInterceptor createVariableInterceptor(final CaseInstance caseInstance) {
        if (this.restApiInterceptor != null) {
            return new VariableInterceptor(){

                @Override
                public void createVariables(Map<String, Object> variables) {
                    BaseVariableResource.this.restApiInterceptor.createCaseInstanceVariables(caseInstance, variables);
                }

                @Override
                public void updateVariables(Map<String, Object> variables) {
                    BaseVariableResource.this.restApiInterceptor.updateCaseInstanceVariables(caseInstance, variables);
                }
            };
        }
        return NoopVariableInterceptor.INSTANCE;
    }

    protected static class NoopVariableInterceptor
    implements VariableInterceptor {
        static final VariableInterceptor INSTANCE = new NoopVariableInterceptor();

        protected NoopVariableInterceptor() {
        }

        @Override
        public void createVariables(Map<String, Object> variables) {
        }

        @Override
        public void updateVariables(Map<String, Object> variables) {
        }
    }

    protected static interface VariableInterceptor {
        public void createVariables(Map<String, Object> var1);

        public void updateVariables(Map<String, Object> var1);
    }
}

