/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.history.planitem;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.cmmn.api.history.HistoricPlanItemInstance;
import org.flowable.cmmn.rest.service.api.history.planitem.HistoricPlanItemInstanceBaseResource;
import org.flowable.cmmn.rest.service.api.history.planitem.HistoricPlanItemInstanceResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"History PlanItem"}, description="Manage History Plan Item Instances", authorizations={@Authorization(value="basicAuth")})
public class HistoricPlanItemInstanceResource
extends HistoricPlanItemInstanceBaseResource {
    @ApiOperation(value="Get a historic plan item instance", tags={"History PlanItem"}, nickname="getHistoricPlanItemInstance")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that the historic plan item instances could be found."), @ApiResponse(code=404, message="Indicates that the historic plan item instances could not be found.")})
    @GetMapping(value={"/cmmn-history/historic-planitem-instances/{planItemInstanceId}"}, produces={"application/json"})
    public HistoricPlanItemInstanceResponse getPlanItemInstance(@ApiParam(name="planItemInstanceId") @PathVariable String planItemInstanceId) {
        HistoricPlanItemInstance planItemInstance = (HistoricPlanItemInstance)this.historyService.createHistoricPlanItemInstanceQuery().planItemInstanceId(planItemInstanceId).singleResult();
        if (planItemInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find a plan item instance with id '" + planItemInstanceId + "'.", HistoricPlanItemInstance.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessHistoryPlanItemInfoById(planItemInstance);
        }
        return this.restResponseFactory.createHistoricPlanItemInstanceResponse(planItemInstance);
    }
}

