/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.CmmnMigrationService;
import org.flowable.cmmn.api.migration.CaseInstanceMigrationDocument;
import org.flowable.cmmn.api.migration.HistoricCaseInstanceMigrationDocument;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationDocumentConverter;
import org.flowable.cmmn.engine.impl.migration.HistoricCaseInstanceMigrationDocumentConverter;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.rest.service.api.CmmnFormHandlerRestApiInterceptor;
import org.flowable.cmmn.rest.service.api.FormModelResponse;
import org.flowable.cmmn.rest.service.api.repository.BaseCaseDefinitionResource;
import org.flowable.cmmn.rest.service.api.repository.CaseDefinitionActionRequest;
import org.flowable.cmmn.rest.service.api.repository.CaseDefinitionResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.form.api.FormEngineConfigurationApi;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.model.SimpleFormModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Definitions"}, description="Manage Case Definitions", authorizations={@Authorization(value="basicAuth")})
public class CaseDefinitionResource
extends BaseCaseDefinitionResource {
    @Autowired
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    @Autowired
    protected CmmnMigrationService cmmnMigrationService;
    @Autowired(required=false)
    protected CmmnFormHandlerRestApiInterceptor formHandlerRestApiInterceptor;

    @ApiOperation(value="Get a case definition", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the case definitions are returned"), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}"}, produces={"application/json"})
    public CaseDefinitionResponse getCaseDefinition(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequest(caseDefinitionId);
        return this.restResponseFactory.createCaseDefinitionResponse(caseDefinition);
    }

    @ApiOperation(value="Execute actions for a case definition", tags={"Case Definitions"}, notes="Execute actions for a case definition (Update category)")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates action has been executed for the specified process. (category altered)"), @ApiResponse(code=400, message="Indicates no category was defined in the request body."), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @PutMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}"}, produces={"application/json"})
    public CaseDefinitionResponse executeCaseDefinitionAction(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId, @ApiParam(required=true) @RequestBody CaseDefinitionActionRequest actionRequest) {
        if (actionRequest == null) {
            throw new FlowableIllegalArgumentException("No action found in request body.");
        }
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequest(caseDefinitionId);
        if (actionRequest.getCategory() != null) {
            this.repositoryService.setCaseDefinitionCategory(caseDefinition.getId(), actionRequest.getCategory());
            CaseDefinitionResponse response = this.restResponseFactory.createCaseDefinitionResponse(caseDefinition);
            response.setCategory(actionRequest.getCategory());
            return response;
        }
        throw new FlowableIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
    }

    @ApiOperation(value="Get a case definition start form", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the case definition form is returned"), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/start-form"}, produces={"application/json"})
    public String getProcessDefinitionStartForm(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId) {
        FormEngineConfigurationApi formEngineConfiguration = (FormEngineConfigurationApi)this.cmmnEngineConfiguration.getEngineConfigurations().get("cfg.formEngine");
        if (formEngineConfiguration == null) {
            return null;
        }
        FormRepositoryService formRepositoryService = formEngineConfiguration.getFormRepositoryService();
        if (formRepositoryService == null) {
            return null;
        }
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequest(caseDefinitionId);
        FormInfo formInfo = this.getStartForm(formRepositoryService, caseDefinition);
        if (this.formHandlerRestApiInterceptor != null) {
            return this.formHandlerRestApiInterceptor.convertStartFormInfo(formInfo, caseDefinition);
        }
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        return this.restResponseFactory.getFormModelString(new FormModelResponse(formInfo, formModel));
    }

    @ApiOperation(value="Migrate all instances of case definition", tags={"Case Definitions"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates case instances were found and migration was executed."), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @PostMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/migrate"}, produces={"application/json"})
    public void migrateInstancesOfCaseDefinition(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId, @RequestBody String migrationDocumentJson) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequestWithoutAccessCheck(caseDefinitionId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.migrateInstancesOfCaseDefinition(caseDefinition, migrationDocumentJson);
        }
        CaseInstanceMigrationDocument migrationDocument = CaseInstanceMigrationDocumentConverter.convertFromJson((String)migrationDocumentJson);
        this.cmmnMigrationService.migrateCaseInstancesOfCaseDefinition(caseDefinitionId, migrationDocument);
    }

    @ApiOperation(value="Migrate all historic case instances of case definition", tags={"Case Definitions"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates historic case instances were found and migration was executed."), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @PostMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/migrate-historic-instances"}, produces={"application/json"})
    public void migrateHistoricInstancesOfCaseDefinition(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId, @RequestBody String migrationDocumentJson) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequestWithoutAccessCheck(caseDefinitionId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.migrateHistoricInstancesOfCaseDefinition(caseDefinition, migrationDocumentJson);
        }
        HistoricCaseInstanceMigrationDocument migrationDocument = HistoricCaseInstanceMigrationDocumentConverter.convertFromJson((String)migrationDocumentJson);
        this.cmmnMigrationService.migrateHistoricCaseInstancesOfCaseDefinition(caseDefinitionId, migrationDocument);
    }

    @ApiOperation(value="Batch migrate all instances of case definition", tags={"Case Definitions"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates case instances were found and batch migration was started."), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @PostMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/batch-migrate"}, produces={"application/json"})
    public void batchMigrateInstancesOfCaseDefinition(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId, @RequestBody String migrationDocumentJson) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequestWithoutAccessCheck(caseDefinitionId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.migrateInstancesOfCaseDefinition(caseDefinition, migrationDocumentJson);
        }
        CaseInstanceMigrationDocument migrationDocument = CaseInstanceMigrationDocumentConverter.convertFromJson((String)migrationDocumentJson);
        this.cmmnMigrationService.batchMigrateCaseInstancesOfCaseDefinition(caseDefinitionId, migrationDocument);
    }

    @ApiOperation(value="Batch migrate all historic instances of case definition", tags={"Case Definitions"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates historic case instances were found and batch migration was started."), @ApiResponse(code=404, message="Indicates the requested case definition was not found.")})
    @PostMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/batch-migrate-historic-instances"}, produces={"application/json"})
    public void batchMigrateHistoricInstancesOfCaseDefinition(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId, @RequestBody String migrationDocumentJson) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequestWithoutAccessCheck(caseDefinitionId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.migrateHistoricInstancesOfCaseDefinition(caseDefinition, migrationDocumentJson);
        }
        HistoricCaseInstanceMigrationDocument migrationDocument = HistoricCaseInstanceMigrationDocumentConverter.convertFromJson((String)migrationDocumentJson);
        this.cmmnMigrationService.batchMigrateHistoricCaseInstancesOfCaseDefinition(caseDefinitionId, migrationDocument);
    }

    protected FormInfo getStartForm(FormRepositoryService formRepositoryService, CaseDefinition caseDefinition) {
        FormInfo formInfo = null;
        CmmnModel cmmnModel = this.repositoryService.getCmmnModel(caseDefinition.getId());
        Case caze = cmmnModel.getCaseById(caseDefinition.getKey());
        Stage stage = caze.getPlanModel();
        if (StringUtils.isNotEmpty((CharSequence)stage.getFormKey())) {
            if (stage.isSameDeployment()) {
                CmmnDeployment deployment = (CmmnDeployment)this.repositoryService.createDeploymentQuery().deploymentId(caseDefinition.getDeploymentId()).singleResult();
                formInfo = formRepositoryService.getFormModelByKeyAndParentDeploymentId(stage.getFormKey(), deployment.getParentDeploymentId(), caseDefinition.getTenantId(), this.cmmnEngineConfiguration.isFallbackToDefaultTenant());
            } else {
                formInfo = formRepositoryService.getFormModelByKey(stage.getFormKey(), caseDefinition.getTenantId(), this.cmmnEngineConfiguration.isFallbackToDefaultTenant());
            }
        }
        if (formInfo == null) {
            throw new FlowableObjectNotFoundException("Case definition does not have a start form defined: " + caseDefinition.getId());
        }
        return formInfo;
    }
}

