/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.rest.service.api.repository.BaseDeploymentResourceDataResource;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Definitions"}, description="Manage Case Definitions", authorizations={@Authorization(value="basicAuth")})
public class CaseDefinitionResourceDataResource
extends BaseDeploymentResourceDataResource {
    @ApiOperation(value="Get a case definition resource content", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both case definition and resource have been found and the resource data has been returned."), @ApiResponse(code=404, message="Indicates the requested case definition was not found or there is no resource with the given id present in the case definition. The status-description contains additional information.")})
    @GetMapping(value={"/cmmn-repository/case-definitions/{caseDefinitionId}/resourcedata"})
    public byte[] getProcessDefinitionResource(@ApiParam(name="caseDefinitionId") @PathVariable String caseDefinitionId, HttpServletResponse response) {
        CaseDefinition caseDefinition = this.getCaseDefinitionFromRequest(caseDefinitionId);
        return this.getDeploymentResourceData(caseDefinition.getDeploymentId(), caseDefinition.getResourceName(), response);
    }

    protected CaseDefinition getCaseDefinitionFromRequest(String caseDefinitionId) {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseDefinitionId).singleResult();
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find a case definition with id '" + caseDefinitionId + "'.", CaseDefinition.class);
        }
        return caseDefinition;
    }
}

