/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.repository.BaseDeploymentResource;
import org.flowable.cmmn.rest.service.api.repository.DeploymentResourceResponse;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Cmmn Deployment"}, description="Manage Cmmn Deployment", authorizations={@Authorization(value="basicAuth")})
public class DeploymentResourceCollectionResource
extends BaseDeploymentResource {
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected CmmnRepositoryService repositoryService;

    @ApiOperation(value="List resources in a deployment", tags={"Deployment"}, nickname="listDeploymentResources", notes="The dataUrl property in the resulting JSON for a single resource contains the actual URL to use for retrieving the binary resource.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the deployment was found and the resource list has been returned."), @ApiResponse(code=404, message="Indicates the requested deployment was not found.")})
    @GetMapping(value={"/cmmn-repository/deployments/{deploymentId}/resources"}, produces={"application/json"})
    public List<DeploymentResourceResponse> getDeploymentResources(@ApiParam(name="deploymentId") @PathVariable String deploymentId) {
        CmmnDeployment deployment = this.getCmmnDeployment(deploymentId);
        List resourceList = this.repositoryService.getDeploymentResourceNames(deployment.getId());
        return this.restResponseFactory.createDeploymentResourceResponseList(deploymentId, resourceList, this.contentTypeResolver);
    }
}

