/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.caze;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.CmmnMigrationService;
import org.flowable.cmmn.api.StageResponse;
import org.flowable.cmmn.api.migration.CaseInstanceMigrationDocument;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.ChangePlanItemStateBuilder;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationDocumentConverter;
import org.flowable.cmmn.rest.service.api.runtime.caze.BaseCaseInstanceResource;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstanceResponse;
import org.flowable.cmmn.rest.service.api.runtime.caze.CaseInstanceUpdateRequest;
import org.flowable.cmmn.rest.service.api.runtime.caze.ChangePlanItemStateRequest;
import org.flowable.cmmn.rest.service.api.runtime.caze.PlanItemDefinitionWithTargetIdsRequest;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Case Instances"}, description="Manage Case Instances", authorizations={@Authorization(value="basicAuth")})
public class CaseInstanceResource
extends BaseCaseInstanceResource {
    @Autowired
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    @Autowired
    protected CmmnMigrationService cmmnMigrationService;

    @ApiOperation(value="Get a case instance", tags={"Case Instances"}, nickname="getCaseInstance")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case instance was found and returned."), @ApiResponse(code=404, message="Indicates the requested case instance was not found.")})
    @GetMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}"}, produces={"application/json"})
    public CaseInstanceResponse getCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId) {
        CaseInstanceResponse caseInstanceResponse = this.restResponseFactory.createCaseInstanceResponse(this.getCaseInstanceFromRequest(caseInstanceId));
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstanceResponse.getCaseDefinitionId()).singleResult();
        if (caseDefinition != null) {
            caseInstanceResponse.setCaseDefinitionName(caseDefinition.getName());
            caseInstanceResponse.setCaseDefinitionDescription(caseDefinition.getDescription());
        }
        return caseInstanceResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="Update case instance properties or execute an action on a case instance (body needs to contain an 'action' property for the latter).", tags={"Case Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case instance was found and the action/update is performed."), @ApiResponse(code=204, message="Indicates the case was found, the change was performed and it caused the case instance to end."), @ApiResponse(code=400, message="Indicates an illegal parameter was passed, required parameters are missing in the request body or illegal variables are passed in. Status description contains additional information about the error."), @ApiResponse(code=404, message="Indicates the case instance was not found.")})
    @PutMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}"}, produces={"application/json"})
    public CaseInstanceResponse updateCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, @RequestBody CaseInstanceUpdateRequest updateRequest, HttpServletResponse response) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequestWithoutAccessCheck(caseInstanceId);
        if (StringUtils.isNotEmpty((CharSequence)updateRequest.getAction())) {
            if (this.restApiInterceptor != null) {
                this.restApiInterceptor.doCaseInstanceAction(caseInstance, updateRequest);
            }
            if (!"evaluateCriteria".equals(updateRequest.getAction())) throw new FlowableIllegalArgumentException("Invalid action: '" + updateRequest.getAction() + "'.");
            this.runtimeService.evaluateCriteria(caseInstance.getId());
        } else {
            if (this.restApiInterceptor != null) {
                this.restApiInterceptor.updateCaseInstance(caseInstance, updateRequest);
            }
            if (StringUtils.isNotEmpty((CharSequence)updateRequest.getName())) {
                this.runtimeService.setCaseInstanceName(caseInstanceId, updateRequest.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)updateRequest.getBusinessKey())) {
                this.runtimeService.updateBusinessKey(caseInstanceId, updateRequest.getBusinessKey());
            }
        }
        caseInstance = (CaseInstance)this.runtimeService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult();
        if (caseInstance != null) return this.restResponseFactory.createCaseInstanceResponse(caseInstance);
        response.setStatus(HttpStatus.NO_CONTENT.value());
        return null;
    }

    @ApiOperation(value="Terminate a case instance", tags={"Case Instances"}, nickname="terminateCaseInstance", code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the case instance was found and terminate. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested case instance was not found.")})
    @DeleteMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void terminateCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequestWithoutAccessCheck(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.terminateCaseInstance(caseInstance);
        }
        this.runtimeService.terminateCaseInstance(caseInstance.getId());
    }

    @ApiOperation(value="Delete a case instance", tags={"Case Instances"}, nickname="deleteCaseInstance", code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the case instance was found and deleted. Response body is left empty intentionally."), @ApiResponse(code=404, message="Indicates the requested case instance was not found.")})
    @DeleteMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}/delete"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequestWithoutAccessCheck(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteCaseInstance(caseInstance);
        }
        this.runtimeService.deleteCaseInstance(caseInstance.getId());
    }

    @GetMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}/stage-overview"}, produces={"application/json"})
    public List<StageResponse> getStageOverview(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequestWithoutAccessCheck(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessStageOverview(caseInstance);
        }
        return this.runtimeService.getStageOverview(caseInstanceId);
    }

    @ApiOperation(value="Change the state of a case instance", tags={"Case Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case instance was found and change state activity was executed."), @ApiResponse(code=404, message="Indicates the requested case instance was not found.")})
    @PostMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}/change-state"}, produces={"application/json"})
    public void changePlanItemState(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, @RequestBody ChangePlanItemStateRequest planItemStateRequest) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequestWithoutAccessCheck(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.changePlanItemState(caseInstance, planItemStateRequest);
        }
        ChangePlanItemStateBuilder changePlanItemStateBuilder = this.runtimeService.createChangePlanItemStateBuilder().caseInstanceId(caseInstanceId);
        if (planItemStateRequest.getActivatePlanItemDefinitionIds() != null && !planItemStateRequest.getActivatePlanItemDefinitionIds().isEmpty()) {
            changePlanItemStateBuilder.activatePlanItemDefinitionIds(planItemStateRequest.getActivatePlanItemDefinitionIds()).changeState();
        } else if (planItemStateRequest.getMoveToAvailablePlanItemDefinitionIds() != null && !planItemStateRequest.getMoveToAvailablePlanItemDefinitionIds().isEmpty()) {
            changePlanItemStateBuilder.changeToAvailableStateByPlanItemDefinitionIds(planItemStateRequest.getMoveToAvailablePlanItemDefinitionIds()).changeState();
        } else if (planItemStateRequest.getAddWaitingForRepetitionPlanItemDefinitionIds() != null && !planItemStateRequest.getAddWaitingForRepetitionPlanItemDefinitionIds().isEmpty()) {
            changePlanItemStateBuilder.addWaitingForRepetitionPlanItemDefinitionIds(planItemStateRequest.getAddWaitingForRepetitionPlanItemDefinitionIds()).changeState();
        } else if (planItemStateRequest.getRemoveWaitingForRepetitionPlanItemDefinitionIds() != null && !planItemStateRequest.getRemoveWaitingForRepetitionPlanItemDefinitionIds().isEmpty()) {
            changePlanItemStateBuilder.removeWaitingForRepetitionPlanItemDefinitionIds(planItemStateRequest.getRemoveWaitingForRepetitionPlanItemDefinitionIds()).changeState();
        } else if (planItemStateRequest.getTerminatePlanItemDefinitionIds() != null && !planItemStateRequest.getTerminatePlanItemDefinitionIds().isEmpty()) {
            changePlanItemStateBuilder.terminatePlanItemDefinitionIds(planItemStateRequest.getTerminatePlanItemDefinitionIds()).changeState();
        } else if (planItemStateRequest.getChangePlanItemIds() != null && !planItemStateRequest.getChangePlanItemIds().isEmpty()) {
            changePlanItemStateBuilder.changePlanItemIds(planItemStateRequest.getChangePlanItemIds()).changeState();
        } else if (planItemStateRequest.getChangePlanItemIdsWithDefinitionId() != null && !planItemStateRequest.getChangePlanItemIdsWithDefinitionId().isEmpty()) {
            changePlanItemStateBuilder.changePlanItemIdsWithDefinitionId(planItemStateRequest.getChangePlanItemIdsWithDefinitionId()).changeState();
        } else if (planItemStateRequest.getChangePlanItemDefinitionsWithNewTargetIds() != null && !planItemStateRequest.getChangePlanItemDefinitionsWithNewTargetIds().isEmpty()) {
            for (PlanItemDefinitionWithTargetIdsRequest definition : planItemStateRequest.getChangePlanItemDefinitionsWithNewTargetIds()) {
                changePlanItemStateBuilder.changePlanItemDefinitionWithNewTargetIds(definition.getExistingPlanItemDefinitionId(), definition.getNewPlanItemId(), definition.getNewPlanItemDefinitionId());
            }
            changePlanItemStateBuilder.changeState();
        }
    }

    @ApiOperation(value="Migrate case instance", tags={"Case Instances"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the case instance was found and migration was executed."), @ApiResponse(code=409, message="Indicates the requested case instance action cannot be executed since the case-instance is already activated/suspended."), @ApiResponse(code=404, message="Indicates the requested case instance was not found.")})
    @PostMapping(value={"/cmmn-runtime/case-instances/{caseInstanceId}/migrate"}, produces={"application/json"})
    public void migrateCaseInstance(@ApiParam(name="caseInstanceId") @PathVariable String caseInstanceId, @RequestBody String migrationDocumentJson) {
        CaseInstance caseInstance = this.getCaseInstanceFromRequestWithoutAccessCheck(caseInstanceId);
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.migrateCaseInstance(caseInstance, migrationDocumentJson);
        }
        CaseInstanceMigrationDocument migrationDocument = CaseInstanceMigrationDocumentConverter.convertFromJson((String)migrationDocumentJson);
        this.cmmnMigrationService.migrateCaseInstance(caseInstanceId, migrationDocument);
    }
}

