/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.caze;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.rest.service.api.runtime.caze.BaseVariableResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Plan Item Instance Variables"}, description="Manage Plan Item Instances Variables", authorizations={@Authorization(value="basicAuth")})
public class PlanItemInstanceVariableDataResource
extends BaseVariableResource {
    @ApiOperation(value="Get the binary data for a variable", tags={"Plan Item Instance Variables"}, nickname="getPlanItemInstanceVariableData")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the plan item instance was found and the requested variables are returned."), @ApiResponse(code=404, message="Indicates the requested plan item was not found or the plan item does not have a variable with the given name (in the given scope). Status message provides additional information.")})
    @ResponseBody
    @GetMapping(value={"/cmmn-runtime/plan-item-instances/{planItemInstanceId}/variables/{variableName}/data"})
    public byte[] getVariableData(@ApiParam(name="planItemInstanceId") @PathVariable(value="planItemInstanceId") String planItemInstanceId, @ApiParam(name="variableName") @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletResponse response) {
        PlanItemInstance planItemInstance = this.getPlanItemInstanceFromRequest(planItemInstanceId);
        return this.getVariableDataByteArray(planItemInstance, variableName, response);
    }
}

