/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.cmmn.rest.service.api.engine.variable.RestVariable;
import org.flowable.cmmn.rest.service.api.runtime.task.TaskVariableBaseResource;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.exception.FlowableConflictException;
import org.flowable.task.api.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Api(tags={"Task Variables"}, description="Manage Tasks variables", authorizations={@Authorization(value="basicAuth")})
public class TaskVariableCollectionResource
extends TaskVariableBaseResource {
    @Autowired
    protected ObjectMapper objectMapper;

    @ApiOperation(value="List variables for a task", tags={"Task Variables"}, nickname="listTaskVariables")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task was found and the requested variables are returned"), @ApiResponse(code=404, message="Indicates the requested task was not found..")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="scope", dataType="string", value="Scope of variable to be returned. When local, only task-local variable value is returned. When global, only variable value from the task\u2019s parent execution-hierarchy are returned. When the parameter is omitted, a local variable will be returned if it exists, otherwise a global variable.", paramType="query")})
    @GetMapping(value={"/cmmn-runtime/tasks/{taskId}/variables"}, produces={"application/json"})
    public List<RestVariable> getVariables(@ApiParam(name="taskId") @PathVariable String taskId, @ApiParam(hidden=true) @RequestParam(value="scope", required=false) String scope) {
        Map<String, RestVariable> variableMap = new HashMap<String, RestVariable>();
        Task task = this.getTaskFromRequestWithoutAccessCheck(taskId);
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(scope);
        if (variableScope == null) {
            this.addLocalVariables(task, variableMap);
            this.addGlobalVariables(task, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            this.addGlobalVariables(task, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            this.addLocalVariables(task, variableMap);
        }
        if (this.restApiInterceptor != null) {
            variableMap = this.restApiInterceptor.accessTaskVariables(task, variableMap);
        }
        ArrayList<RestVariable> result = new ArrayList<RestVariable>(variableMap.values());
        return result;
    }

    @ApiOperation(value="Create new variables on a task", tags={"Tasks", "Task Variables"}, notes="This endpoint can be used in 2 ways: By passing a JSON Body (RestVariable or an Array of RestVariable) or by passing a multipart/form-data Object.\nIt is possible to create simple (non-binary) variable or list of variables or new binary variable \nAny number of variables can be passed into the request body array.\nNB: Swagger V2 specification does not support this use case that is why this endpoint might be buggy/incomplete if used with other tools.", code=201)
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", type="org.flowable.rest.service.api.engine.variable.RestVariable", value="Create a variable on a task", paramType="body", example="{\n    \"name\":\"intProcVar\"\n    \"type\":\"integer\"\n    \"value\":123,\n }"), @ApiImplicitParam(name="name", value="Required name of the variable", dataType="string", paramType="form", example="Simple content item"), @ApiImplicitParam(name="type", value="Type of variable that is created. If omitted, reverts to raw JSON-value type (string, boolean, integer or double)", dataType="string", paramType="form", example="integer"), @ApiImplicitParam(name="scope", value="Scope of variable that is created. If omitted, local is assumed.", dataType="string", paramType="form", example="local")})
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the variables were created and the result is returned."), @ApiResponse(code=400, message="Indicates the name of a variable to create was missing or that an attempt is done to create a variable on a standalone task (without a process associated) with scope global or an empty array of variables was included in the request or request did not contain an array of variables. Status message provides additional information."), @ApiResponse(code=404, message="Indicates the requested task was not found."), @ApiResponse(code=409, message="Indicates the task already has a variable with the given name. Use the PUT method to update the task variable instead."), @ApiResponse(code=415, message="Indicates the serializable data contains an object for which no class is present in the JVM running the Flowable engine and therefore cannot be deserialized.")})
    @PostMapping(value={"/cmmn-runtime/tasks/{taskId}/variables"}, produces={"application/json"}, consumes={"text/plain", "application/json", "multipart/form-data"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Object createTaskVariable(@ApiParam(name="taskId") @PathVariable String taskId, HttpServletRequest request) {
        Task task = this.getTaskFromRequestWithoutAccessCheck(taskId);
        Object result = null;
        if (request instanceof MultipartHttpServletRequest) {
            result = this.setBinaryVariable((MultipartHttpServletRequest)request, task, true);
        } else {
            ArrayList<RestVariable> inputVariables = new ArrayList<RestVariable>();
            ArrayList<RestVariable> resultVariables = new ArrayList<RestVariable>();
            result = resultVariables;
            try {
                List variableObjects = (List)this.objectMapper.readValue((InputStream)request.getInputStream(), List.class);
                for (Object restObject : variableObjects) {
                    RestVariable restVariable = (RestVariable)((Object)this.objectMapper.convertValue(restObject, RestVariable.class));
                    inputVariables.add(restVariable);
                }
            }
            catch (Exception e) {
                throw new FlowableIllegalArgumentException("Failed to serialize to a RestVariable instance", (Throwable)e);
            }
            if (inputVariables == null || inputVariables.size() == 0) {
                throw new FlowableIllegalArgumentException("Request didn't contain a list of variables to create.");
            }
            RestVariable.RestVariableScope sharedScope = null;
            RestVariable.RestVariableScope varScope = null;
            HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
            for (RestVariable var : inputVariables) {
                varScope = var.getVariableScope();
                if (var.getName() == null) {
                    throw new FlowableIllegalArgumentException("Variable name is required");
                }
                if (varScope == null) {
                    varScope = RestVariable.RestVariableScope.LOCAL;
                }
                if (sharedScope == null) {
                    sharedScope = varScope;
                }
                if (varScope != sharedScope) {
                    throw new FlowableIllegalArgumentException("Only allowed to update multiple variables in the same scope.");
                }
                if (this.hasVariableOnScope(task, var.getName(), varScope)) {
                    throw new FlowableConflictException("Variable '" + var.getName() + "' is already present on task '" + task.getId() + "'.");
                }
                Object actualVariableValue = this.restResponseFactory.getVariableValue(var);
                variablesToSet.put(var.getName(), actualVariableValue);
            }
            if (!variablesToSet.isEmpty()) {
                Map setVariables;
                if (this.restApiInterceptor != null) {
                    this.restApiInterceptor.createTaskVariables(task, variablesToSet, sharedScope);
                }
                if (sharedScope == RestVariable.RestVariableScope.LOCAL) {
                    this.taskService.setVariablesLocal(task.getId(), variablesToSet);
                    setVariables = this.taskService.getVariablesLocal(task.getId(), variablesToSet.keySet());
                } else if (task.getScopeId() != null) {
                    this.runtimeService.setVariables(task.getScopeId(), variablesToSet);
                    setVariables = this.runtimeService.getVariables(task.getScopeId(), variablesToSet.keySet());
                } else {
                    throw new FlowableIllegalArgumentException("Cannot set global variables on task '" + task.getId() + "', task is not part of process.");
                }
                for (RestVariable inputVariable : inputVariables) {
                    String variableName = inputVariable.getName();
                    Object variableValue = setVariables.get(variableName);
                    resultVariables.add(this.restResponseFactory.createRestVariable(variableName, variableValue, varScope, task.getId(), 1, false));
                }
            }
        }
        return result;
    }

    @ApiOperation(value="Delete all local variables on a task", tags={"Tasks"}, code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates all local task variables have been deleted. Response-body is intentionally empty."), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @DeleteMapping(value={"/cmmn-runtime/tasks/{taskId}/variables"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllLocalTaskVariables(@ApiParam(name="taskId") @PathVariable String taskId) {
        Task task = this.getTaskFromRequestWithoutAccessCheck(taskId);
        Set<String> currentVariables = this.taskService.getVariablesLocal(task.getId()).keySet();
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteTaskVariables(task, currentVariables, RestVariable.RestVariableScope.LOCAL);
        }
        this.taskService.removeVariablesLocal(task.getId(), currentVariables);
    }

    protected void addGlobalVariables(Task task, Map<String, RestVariable> variableMap) {
        if (task.getScopeId() != null) {
            Map rawVariables = this.runtimeService.getVariables(task.getScopeId());
            List<RestVariable> globalVariables = this.restResponseFactory.createRestVariables(rawVariables, task.getId(), 1, RestVariable.RestVariableScope.GLOBAL);
            for (RestVariable var : globalVariables) {
                if (variableMap.containsKey(var.getName())) continue;
                variableMap.put(var.getName(), var);
            }
        }
    }

    protected void addLocalVariables(Task task, Map<String, RestVariable> variableMap) {
        Map rawVariables = this.taskService.getVariablesLocal(task.getId());
        List<RestVariable> localVariables = this.restResponseFactory.createRestVariables(rawVariables, task.getId(), 1, RestVariable.RestVariableScope.LOCAL);
        for (RestVariable var : localVariables) {
            variableMap.put(var.getName(), var);
        }
    }
}

