/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class InstantRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "instant";
    }

    @Override
    public Class<?> getVariableType() {
        return Instant.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof String)) {
                throw new FlowableIllegalArgumentException("Converter can only convert string to instant");
            }
            try {
                return Instant.parse((String)result.getValue());
            }
            catch (DateTimeParseException e) {
                throw new FlowableIllegalArgumentException("The given variable value is not an instant: '" + result.getValue() + "'", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Instant)) {
                throw new FlowableIllegalArgumentException("Converter can only convert instant");
            }
            result.setValue(variableValue.toString());
        } else {
            result.setValue(null);
        }
    }
}

