/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import java.util.UUID;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class UUIDRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "uuid";
    }

    @Override
    public Class<?> getVariableType() {
        return UUID.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof String)) {
                throw new FlowableIllegalArgumentException("Converter can only convert Strings");
            }
            return UUID.fromString((String)result.getValue());
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof UUID)) {
                throw new FlowableIllegalArgumentException("Converter can only convert UUIDs");
            }
            result.setValue(((UUID)variableValue).toString());
        } else {
            result.setValue(null);
        }
    }
}

