/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.api;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;

public class RequestUtil {
    private static final FastDateFormat shortDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final FastDateFormat longDateFormatOutputFormater = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssz");
    private static final DateTimeFormatter longDateFormat = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").optionalStart().appendLiteral('T').appendPattern("HH:mm").optionalStart().appendPattern(":ss").optionalStart().appendPattern(".SSS").optionalEnd().optionalEnd().optionalStart().appendOffset("+HH:mm", "Z").optionalEnd().optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();

    public static boolean getBoolean(Map<String, String> requestParams, String name, boolean defaultValue) {
        boolean value = defaultValue;
        if (requestParams.get(name) != null) {
            value = Boolean.valueOf(requestParams.get(name));
        }
        return value;
    }

    public static int getInteger(Map<String, String> requestParams, String name, int defaultValue) {
        int value = defaultValue;
        if (requestParams.get(name) != null) {
            value = Integer.valueOf(requestParams.get(name));
        }
        return value;
    }

    public static Date getDate(Map<String, String> requestParams, String name) {
        if (requestParams != null && name != null) {
            return RequestUtil.parseLongDate(requestParams.get(name));
        }
        return null;
    }

    public static Date parseLongDate(String aDate) {
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(aDate, longDateFormat);
        return Date.from(offsetDateTime.toInstant());
    }

    public static String dateToString(Date date) {
        String dateString = null;
        if (date != null) {
            dateString = longDateFormatOutputFormater.format(date);
        }
        return dateString;
    }

    public static Integer parseToInteger(String integer) {
        Integer parsedInteger = null;
        try {
            parsedInteger = Integer.parseInt(integer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parsedInteger;
    }

    public static Date parseToDate(String date) {
        Date parsedDate = null;
        try {
            parsedDate = shortDateFormat.parse(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parsedDate;
    }

    public static List<String> parseToList(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String[] valueParts = value.split(",");
        ArrayList<String> values = new ArrayList<String>(valueParts.length);
        Collections.addAll(values, valueParts);
        return values;
    }
}

