/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.resolver;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.rest.resolver.ContentTypeResolver;

public class DefaultContentTypeResolver
implements ContentTypeResolver {
    protected final Map<String, String> fileExtensionToContentType = new HashMap<String, String>();
    protected String unknownFileContentType = "application/octet-stream";

    public DefaultContentTypeResolver() {
        this.fileExtensionToContentType.put("png", "image/png");
        this.fileExtensionToContentType.put("txt", "text/plain");
        this.fileExtensionToContentType.put("xml", "text/xml");
        this.fileExtensionToContentType.put("bpmn", "text/xml");
        this.fileExtensionToContentType.put("cmmn", "text/xml");
        this.fileExtensionToContentType.put("dmn", "text/xml");
        this.fileExtensionToContentType.put("app", "application/json");
        this.fileExtensionToContentType.put("event", "application/json");
        this.fileExtensionToContentType.put("form", "application/json");
        this.fileExtensionToContentType.put("channel", "application/json");
    }

    @Override
    public String resolveContentType(String resourceName) {
        if (resourceName != null && !resourceName.isEmpty()) {
            String lowerResourceName = resourceName.toLowerCase();
            String fileExtension = StringUtils.substringAfterLast((String)lowerResourceName, (int)46);
            return this.fileExtensionToContentType.getOrDefault(fileExtension, this.unknownFileContentType);
        }
        return null;
    }

    public void addFileExtensionMapping(String fileExtension, String contentType) {
        this.fileExtensionToContentType.put(fileExtension, contentType);
    }

    public void setUnknownFileContentType(String unknownFileContentType) {
        this.unknownFileContentType = unknownFileContentType;
    }
}

