/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import java.math.BigDecimal;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class BigDecimalRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "bigDecimal";
    }

    @Override
    public Class<?> getVariableType() {
        return BigDecimal.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            return new BigDecimal(result.getValue().toString());
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof BigDecimal)) {
                throw new FlowableIllegalArgumentException("Converter can only convert big decimal values");
            }
            result.setValue(((BigDecimal)variableValue).toPlainString());
        } else {
            result.setValue(null);
        }
    }
}

