/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import java.math.BigInteger;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class BigIntegerRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "bigInteger";
    }

    @Override
    public Class<?> getVariableType() {
        return BigInteger.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            return new BigInteger(result.getValue().toString());
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof BigInteger)) {
                throw new FlowableIllegalArgumentException("Converter can only convert big integer values");
            }
            result.setValue(variableValue.toString());
        } else {
            result.setValue(null);
        }
    }
}

