/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class LocalDateRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "localDate";
    }

    @Override
    public Class<?> getVariableType() {
        return LocalDate.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof String)) {
                throw new FlowableIllegalArgumentException("Converter can only convert string to localDate");
            }
            try {
                return LocalDate.parse((String)result.getValue());
            }
            catch (DateTimeParseException e) {
                throw new FlowableIllegalArgumentException("The given variable value is not a localDate: '" + String.valueOf(result.getValue()) + "'", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof LocalDate)) {
                throw new FlowableIllegalArgumentException("Converter can only convert localDate");
            }
            result.setValue(variableValue.toString());
        } else {
            result.setValue(null);
        }
    }
}

