/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.test;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentTestHelper {
    private static Logger log = LoggerFactory.getLogger(ContentTestHelper.class);
    public static final String EMPTY_LINE = "\n";
    static Map<String, ContentEngine> contentEngines = new HashMap<String, ContentEngine>();

    public static ContentEngine getContentEngine(String configurationResource) {
        ContentEngine contentEngine = contentEngines.get(configurationResource);
        if (contentEngine == null) {
            log.debug("==== BUILDING CONTENT ENGINE ========================================================================");
            contentEngine = ContentEngineConfiguration.createContentEngineConfigurationFromResource(configurationResource).setDatabaseSchemaUpdate("drop-create").buildContentEngine();
            log.debug("==== CONTENT ENGINE CREATED =========================================================================");
            contentEngines.put(configurationResource, contentEngine);
        }
        return contentEngine;
    }

    public static void closeContentEngines() {
        for (ContentEngine contentEngine : contentEngines.values()) {
            contentEngine.close();
        }
        contentEngines.clear();
    }

    public static void assertAndEnsureCleanDb(ContentEngine contentEngine) {
        log.debug("verifying that db is clean after test");
        ContentService contentService = contentEngine.getContentEngineConfiguration().getContentService();
        List items = contentService.createContentItemQuery().list();
        if (items != null && !items.isEmpty()) {
            throw new AssertionError((Object)"ContentItem is not empty");
        }
    }
}

